/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.LocalDomainCommand;
import com.sun.enterprise.backup.BackupRequest;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.ObjectAnalyzer;
import com.sun.enterprise.util.io.DomainDirs;
import java.io.File;
import java.io.IOException;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;

public abstract class BackupCommands
extends LocalDomainCommand {
    BackupRequest request;
    private static final LocalStringsImpl strings = new LocalStringsImpl(BackupCommands.class);
    @Param(name="verbose", optional=true)
    boolean verbose;
    @Param(name="domain_name", primary=true, optional=true)
    String domainName;
    @Param(name="_configonly", optional=true)
    String configonly;
    @Param(optional=true)
    String backupconfig;
    @Param(optional=true)
    String backupdir;
    private String desc = null;
    private int recycleLimit = 0;

    protected void checkOptions() throws CommandException {
        File domainsDirFile;
        if (this.verbose && this.programOpts.isTerse()) {
            throw new CommandValidationException(strings.get("NoVerboseAndTerseAtTheSameTime"));
        }
        if (this.domainDirParam == null || this.domainDirParam.length() <= 0) {
            try {
                this.domainDirParam = DomainDirs.getDefaultDomainsDir().getPath();
            }
            catch (IOException ioe) {
                throw new CommandException(ioe.getMessage());
            }
        }
        if (!(domainsDirFile = new File(this.domainDirParam)).isDirectory()) {
            throw new CommandValidationException(strings.get("InvalidDomainPath", new Object[]{this.domainDirParam}));
        }
        if (this.domainName == null) {
            this.domainName = this.getDomainName();
        }
    }

    protected void setDescription(String d) {
        this.desc = d;
    }

    protected void setBackupDir(String dir) {
        this.backupdir = dir;
    }

    protected void setRecycleLimit(int limit) {
        this.recycleLimit = limit;
    }

    protected void prepareRequest() throws CommandValidationException {
        File backupdir_f = null;
        if (this.backupdir != null && !(backupdir_f = new File(this.backupdir)).isAbsolute()) {
            throw new CommandValidationException(strings.get("InvalidBackupDirPath", new Object[]{this.backupdir}));
        }
        this.request = new BackupRequest(this.domainDirParam, this.domainName, backupdir_f, null, this.desc, this.recycleLimit);
        this.request.setTerse(this.programOpts.isTerse());
        this.request.setVerbose(this.verbose);
    }

    protected boolean isWritableDirectory(File domainFile) {
        boolean result = false;
        if (domainFile.isDirectory() || domainFile.canWrite()) {
            result = true;
        }
        return result;
    }

    public String toString() {
        return super.toString() + "\n" + ObjectAnalyzer.toString((Object)((Object)this));
    }
}

