/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.optional.BackupCommands;
import com.sun.enterprise.admin.cli.remote.DASUtils;
import com.sun.enterprise.backup.BackupException;
import com.sun.enterprise.backup.BackupManager;
import com.sun.enterprise.backup.BackupWarningException;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.ObjectAnalyzer;
import java.io.File;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="backup-domain")
@Scoped(value=PerLookup.class)
public final class BackupDomainCommand
extends BackupCommands {
    @Param(name="description", optional=true)
    String description;
    @Param(name="_force", optional=true)
    String force;
    @Param(name="_recyclelimit", optional=true)
    String recycleLimit;
    private static final LocalStringsImpl strings = new LocalStringsImpl(BackupDomainCommand.class);

    protected void validate() throws CommandException {
        if (this.domainName == null) {
            super.validate();
        }
        this.checkOptions();
        File domainFile = new File(new File(this.domainDirParam), this.domainName);
        if (!this.isWritableDirectory(domainFile)) {
            throw new CommandException(strings.get("InvalidDirectory", new Object[]{domainFile.getPath()}));
        }
        if (this.force == null && DASUtils.pingDASQuietly((ProgramOptions)this.programOpts, (Environment)this.env)) {
            throw new CommandException(strings.get("DomainIsNotStopped", new Object[]{this.domainName}));
        }
        int limit = 0;
        if (this.recycleLimit != null) {
            try {
                limit = Integer.parseInt(this.recycleLimit.trim());
            }
            catch (NumberFormatException ex) {
                limit = -1;
            }
            if (limit < 0) {
                throw new CommandException(strings.get("InvalidBackupRecycleLimit", new Object[]{this.recycleLimit}));
            }
        }
        this.setDescription(this.description);
        this.setBackupDir(this.backupdir);
        this.setRecycleLimit(limit);
        this.prepareRequest();
        this.initializeLogger();
    }

    protected int executeCommand() throws CommandException {
        try {
            BackupManager mgr = new BackupManager(this.request);
            logger.info(mgr.backup());
        }
        catch (BackupWarningException bwe) {
            logger.info(bwe.getMessage());
        }
        catch (BackupException be) {
            throw new CommandException((Throwable)be);
        }
        return 0;
    }

    public String toString() {
        return super.toString() + "\n" + ObjectAnalyzer.toString((Object)((Object)this));
    }
}

