/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.optional.BackupCommands;
import com.sun.enterprise.admin.cli.optional.BackupDomainCommand;
import com.sun.enterprise.admin.cli.remote.DASUtils;
import com.sun.enterprise.backup.BackupException;
import com.sun.enterprise.backup.BackupRequest;
import com.sun.enterprise.backup.BackupWarningException;
import com.sun.enterprise.backup.RestoreManager;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.ObjectAnalyzer;
import java.io.File;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="restore-domain")
@Scoped(value=PerLookup.class)
public final class RestoreDomainCommand
extends BackupCommands {
    @Param(name="filename", optional=true)
    private String backupFilename;
    @Param(name="force", optional=true, defaultValue="false")
    private boolean force;
    @Param(name="description", optional=true, obsolete=true)
    private String description;
    private static final LocalStringsImpl strings = new LocalStringsImpl(BackupDomainCommand.class);

    protected void validate() throws CommandException, CommandValidationException {
        File f;
        if (this.backupFilename == null && this.domainName == null) {
            if (!this.force) {
                throw new CommandException(strings.get("UseForceOption"));
            }
            super.validate();
        }
        this.checkOptions();
        if (DASUtils.pingDASQuietly((ProgramOptions)this.programOpts, (Environment)this.env)) {
            throw new CommandException(strings.get("DomainIsNotStopped", new Object[]{this.domainName}));
        }
        if (!(this.backupFilename == null || (f = new File(this.backupFilename)).exists() && f.canRead())) {
            throw new CommandValidationException(strings.get("FileDoesNotExist", new Object[]{this.backupFilename}));
        }
        this.setBackupDir(this.backupdir);
        this.initRequest();
        this.initializeLogger();
    }

    protected int executeCommand() throws CommandException {
        try {
            RestoreManager mgr = new RestoreManager(this.request);
            logger.info(mgr.restore());
        }
        catch (BackupWarningException bwe) {
            logger.info(bwe.getMessage());
        }
        catch (BackupException be) {
            throw new CommandException((Throwable)be);
        }
        return 0;
    }

    private void initRequest() throws CommandValidationException {
        File backupdir_f = null;
        if (this.backupdir != null && !(backupdir_f = new File(this.backupdir)).isAbsolute()) {
            throw new CommandValidationException(strings.get("InvalidBackupDirPath", new Object[]{this.backupdir}));
        }
        boolean configonlybackup = false;
        if (this.configonly != null && new Boolean(this.configonly).booleanValue()) {
            configonlybackup = true;
        }
        this.request = new BackupRequest(this.domainDirParam, this.domainName, backupdir_f, this.backupConfig, this.backupFilename, configonlybackup);
        this.request.setTerse(this.programOpts.isTerse());
        this.request.setVerbose(this.verbose);
        this.request.setForce(this.force);
    }

    public String toString() {
        return super.toString() + "\n" + ObjectAnalyzer.toString((Object)((Object)this));
    }
}

