/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.core.deployment;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="list-sub-components")
@I18n(value="list.sub.components")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
public class ListSubComponentsCommand
implements AdminCommand {
    @Param(primary=true)
    private String modulename = null;
    @Param(optional=true)
    private String appname = null;
    @Param(optional=true)
    private String type = null;
    @Inject
    public ApplicationRegistry appRegistry;
    @Param(optional=true, defaultValue="false")
    private Boolean resources = false;
    @Param(optional=true, defaultValue="false", shortName="t")
    public Boolean terse = false;
    @Inject
    public Deployment deployment;
    @Inject
    public Applications applications;
    @Inject
    private CommandRunner commandRunner;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListSubComponentsCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        ActionReport.MessagePart part = report.getTopMessagePart();
        String applicationName = this.modulename;
        if (this.appname != null) {
            applicationName = this.appname;
        }
        try {
            VersioningUtils.checkIdentifier((String)applicationName);
        }
        catch (VersioningSyntaxException ex) {
            report.setMessage(ex.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!this.deployment.isRegistered(applicationName)) {
            report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{applicationName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        com.sun.enterprise.config.serverbeans.Application application = this.applications.getApplication(applicationName);
        if (application.isLifecycleModule() || application.isOSGiModule()) {
            if (!this.terse.booleanValue()) {
                part.setMessage(localStrings.getLocalString("listsubcomponents.no.elements.to.list", "Nothing to List."));
            }
            return;
        }
        ApplicationInfo appInfo = this.appRegistry.get(applicationName);
        if (appInfo == null) {
            report.setMessage(localStrings.getLocalString("application.not.enabled", "Application {0} is not in an enabled state", new Object[]{applicationName}));
            return;
        }
        Application app = (Application)appInfo.getMetaData(Application.class);
        Map<Object, Object> subComponents = new LinkedHashMap();
        HashMap<String, String> subComponentsMap = new HashMap<String, String>();
        if (this.appname == null) {
            subComponents = this.getAppLevelComponents(app, this.type, subComponentsMap);
        } else {
            BundleDescriptor bundleDesc = app.getModuleByUri(this.modulename);
            if (bundleDesc == null) {
                report.setMessage(localStrings.getLocalString("listsubcomponents.invalidmodulename", "Invalid module name", new Object[]{this.appname, this.modulename}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            subComponents = this.getModuleLevelComponents(bundleDesc, this.type, subComponentsMap);
        }
        if (this.type != null && !this.type.equals("servlets") && !this.type.equals("ejbs")) {
            report.setMessage(localStrings.getLocalString("listsubcomponents.invalidtype", "The type option has invalid value {0}. It should have a value of servlets or ejbs.", new Object[]{this.type}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        List<Object> subModuleInfos = new ArrayList();
        if (!app.isVirtual()) {
            subModuleInfos = this.getSubModulesForEar(app);
        }
        int i = 0;
        for (String string : subComponents.keySet()) {
            Module module;
            ActionReport.MessagePart childPart = part.addChild();
            childPart.setMessage(string + (String)subComponents.get(string));
            if (this.appname == null && !app.isVirtual() && subModuleInfos.get(i) != null) {
                childPart.addProperty("moduleInfo", (String)subModuleInfos.get(i));
            }
            if (this.resources.booleanValue() && (module = application.getModule(string)) != null) {
                ActionReport subReport = report.addSubActionsReport();
                CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation("_list-resources", subReport);
                ParameterMap parameters = new ParameterMap();
                parameters.add((Object)"appname", (Object)application.getName());
                parameters.add((Object)"modulename", (Object)module.getName());
                inv.parameters(parameters).execute();
                ActionReport.MessagePart subPart = subReport.getTopMessagePart();
                for (ActionReport.MessagePart cp : subPart.getChildren()) {
                    ActionReport.MessagePart resourcesChildPart = childPart.addChild();
                    resourcesChildPart.setMessage("  " + cp.getMessage());
                }
            }
            ++i;
        }
        Set keys = subComponentsMap.keySet();
        for (String key : keys) {
            part.addProperty(key, (String)subComponentsMap.get(key));
        }
        if (subComponents.size() == 0 && !this.terse.booleanValue()) {
            part.setMessage(localStrings.getLocalString("listsubcomponents.no.elements.to.list", "Nothing to List."));
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private List<String> getSubModulesForEar(Application application) {
        ArrayList<String> moduleInfoList = new ArrayList<String>();
        for (ModuleDescriptor moduleDesc : application.getModules()) {
            String moduleInfo = moduleDesc.getArchiveUri() + ":" + moduleDesc.getModuleType();
            if (moduleDesc.getModuleType().equals((Object)XModuleType.WAR)) {
                moduleInfo = moduleInfo + ":" + moduleDesc.getContextRoot();
            }
            moduleInfoList.add(moduleInfo);
        }
        return moduleInfoList;
    }

    private Map<String, String> getAppLevelComponents(Application application, String type, Map<String, String> subComponentsMap) {
        LinkedHashMap<String, String> subComponentList = new LinkedHashMap();
        if (application.isVirtual()) {
            BundleDescriptor bundleDescriptor = application.getStandaloneBundleDescriptor();
            subComponentList = this.getModuleLevelComponents(bundleDescriptor, type, subComponentsMap);
        } else {
            Collection<ModuleDescriptor> modules = new ArrayList();
            if (type == null) {
                modules = application.getModules();
            } else if (type.equals("servlets")) {
                modules = application.getModuleDescriptorsByType(XModuleType.WAR);
            } else if (type.equals("ejbs")) {
                modules = application.getModuleDescriptorsByType(XModuleType.EJB);
                Collection webModules = application.getModuleDescriptorsByType(XModuleType.WAR);
                for (ModuleDescriptor webModule : webModules) {
                    if (webModule.getDescriptor().getExtensionsDescriptors(EjbBundleDescriptor.class).size() <= 0) continue;
                    modules.add(webModule);
                }
            }
            for (ModuleDescriptor module : modules) {
                StringBuffer sb = new StringBuffer();
                String moduleName = module.getArchiveUri();
                sb.append(" <");
                String moduleType = this.getModuleType(module);
                sb.append(moduleType);
                sb.append(">");
                subComponentList.put(moduleName, sb.toString());
                subComponentsMap.put(module.getArchiveUri(), moduleType);
            }
        }
        return subComponentList;
    }

    private Map<String, String> getModuleLevelComponents(BundleDescriptor bundle, String type, Map<String, String> subComponentsMap) {
        LinkedHashMap<String, String> moduleSubComponentMap;
        block6: {
            block5: {
                moduleSubComponentMap = new LinkedHashMap<String, String>();
                if (!(bundle instanceof WebBundleDescriptor)) break block5;
                WebBundleDescriptor wbd = (WebBundleDescriptor)bundle;
                Collection ejbBundleDescs = wbd.getExtensionsDescriptors(EjbBundleDescriptor.class);
                if (ejbBundleDescs.size() > 0) {
                    EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)ejbBundleDescs.iterator().next();
                    moduleSubComponentMap.putAll(this.getModuleLevelComponents((BundleDescriptor)ejbBundle, type, subComponentsMap));
                }
                if (type != null && type.equals("ejbs")) {
                    return moduleSubComponentMap;
                }
                for (WebComponentDescriptor wcd : wbd.getWebComponentDescriptors()) {
                    StringBuffer sb = new StringBuffer();
                    String canonicalName = wcd.getCanonicalName();
                    sb.append(" <");
                    String wcdType = wcd.isServlet() ? "Servlet" : "JSP";
                    sb.append(wcdType);
                    sb.append(">");
                    moduleSubComponentMap.put(canonicalName, sb.toString());
                    subComponentsMap.put(wcd.getCanonicalName(), wcdType);
                }
                break block6;
            }
            if (!(bundle instanceof EjbBundleDescriptor)) break block6;
            if (type != null && type.equals("servlets")) {
                return moduleSubComponentMap;
            }
            EjbBundleDescriptor ebd = (EjbBundleDescriptor)bundle;
            for (EjbDescriptor ejbDesc : ebd.getEjbs()) {
                StringBuffer sb = new StringBuffer();
                String ejbName = ejbDesc.getName();
                sb.append(" <");
                String ejbType = this.getEjbType(ejbDesc);
                sb.append(ejbType);
                sb.append(">");
                moduleSubComponentMap.put(ejbName, sb.toString());
                subComponentsMap.put(ejbDesc.getName(), ejbType);
            }
        }
        return moduleSubComponentMap;
    }

    private String getEjbType(EjbDescriptor ejbDesc) {
        String type = null;
        if (ejbDesc.getType().equals("Session")) {
            EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)ejbDesc;
            if (sessionDesc.isStateful()) {
                type = "StatefulSessionBean";
            } else if (sessionDesc.isStateless()) {
                type = "StatelessSessionBean";
            } else if (sessionDesc.isSingleton()) {
                type = "SingletonSessionBean";
            }
        } else if (ejbDesc.getType().equals("Message-driven")) {
            type = "MessageDrivenBean";
        } else if (ejbDesc.getType().equals("Entity")) {
            type = "EntityBean";
        }
        return type;
    }

    private String getModuleType(ModuleDescriptor modDesc) {
        String type = null;
        if (modDesc.getModuleType().equals((Object)XModuleType.EJB)) {
            type = "EJBModule";
        } else if (modDesc.getModuleType().equals((Object)XModuleType.WAR)) {
            type = "WebModule";
        } else if (modDesc.getModuleType().equals((Object)XModuleType.CAR)) {
            type = "AppClientModule";
        } else if (modDesc.getModuleType().equals((Object)XModuleType.RAR)) {
            type = "ConnectorModule";
        }
        return type;
    }
}

