/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-supported-cipher-suites")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.supported.cipher.suites")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE})
public class ListSupportedCipherSuites
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListSupportedCipherSuites.class);
    @Inject
    SSLUtils sslutils;
    @Param(optional=true, primary=true, defaultValue="server")
    private String target;

    public void execute(AdminCommandContext context) {
        String[] cipherSuites;
        ActionReport report = context.getActionReport();
        for (String cipherSuite : cipherSuites = this.sslutils.getSupportedCipherSuites()) {
            if (cipherSuite.contains("_KRB5_")) continue;
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            part.setMessage(cipherSuite);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

