/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;

public final class StringUtils {
    public static final String LINE_SEP = System.getProperty("line.separator");

    private StringUtils() {
    }

    public static Vector lineSplit(String data) {
        return StringUtils.split(data, 10);
    }

    public static Vector split(String data, int ch) {
        Vector<String> elems = new Vector<String>();
        int pos = -1;
        int i = 0;
        while ((pos = data.indexOf(ch, i)) != -1) {
            String elem = data.substring(i, pos);
            elems.addElement(elem);
            i = pos + 1;
        }
        elems.addElement(data.substring(i));
        return elems;
    }

    public static String replace(String data, String from, String to) {
        StringBuffer buf = new StringBuffer(data.length());
        int pos = -1;
        int i = 0;
        while ((pos = data.indexOf(from, i)) != -1) {
            buf.append(data.substring(i, pos)).append(to);
            i = pos + from.length();
        }
        buf.append(data.substring(i));
        return buf.toString();
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        pw.flush();
        pw.close();
        return sw.toString();
    }

    public static boolean endsWith(StringBuffer buffer, String suffix) {
        if (suffix.length() > buffer.length()) {
            return false;
        }
        int bufferIndex = buffer.length() - 1;
        for (int endIndex = suffix.length() - 1; endIndex >= 0; --endIndex) {
            if (buffer.charAt(bufferIndex) != suffix.charAt(endIndex)) {
                return false;
            }
            --bufferIndex;
        }
        return true;
    }

    public static String resolveBackSlash(String input) {
        StringBuffer b = new StringBuffer();
        boolean backSlashSeen = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (!backSlashSeen) {
                if (c == '\\') {
                    backSlashSeen = true;
                    continue;
                }
                b.append(c);
                continue;
            }
            switch (c) {
                case '\\': {
                    b.append('\\');
                    break;
                }
                case 'n': {
                    b.append('\n');
                    break;
                }
                case 'r': {
                    b.append('\r');
                    break;
                }
                case 't': {
                    b.append('\t');
                    break;
                }
                case 'f': {
                    b.append('\f');
                    break;
                }
                case 's': {
                    b.append(" \t\n\r\f");
                    break;
                }
                default: {
                    b.append(c);
                }
            }
            backSlashSeen = false;
        }
        return b.toString();
    }

    public static long parseHumanSizes(String humanSize) throws Exception {
        long KILOBYTE = 1024L;
        long MEGABYTE = 0x100000L;
        long GIGABYTE = 0x40000000L;
        long TERABYTE = 0x10000000000L;
        long PETABYTE = 0x4000000000000L;
        if (!Character.isDigit(humanSize.charAt(humanSize.length() - 1))) {
            char c = humanSize.charAt(humanSize.length() - 1);
            long value = Long.valueOf(humanSize.substring(0, humanSize.length() - 1));
            switch (c) {
                case 'K': {
                    return value * 1024L;
                }
                case 'M': {
                    return value * 0x100000L;
                }
                case 'G': {
                    return value * 0x40000000L;
                }
                case 'T': {
                    return value * 0x10000000000L;
                }
                case 'P': {
                    return value * 0x4000000000000L;
                }
            }
            return value;
        }
        return Long.parseLong(humanSize);
    }
}

