/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver.ssl;

import com.sun.grizzly.config.SSLConfigHolder;
import com.sun.grizzly.config.dom.Ssl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.glassfish.admin.mbeanserver.JMXSslConfigHolder;
import org.glassfish.admin.mbeanserver.Util;

public class SecureRMIServerSocketFactory
extends SslRMIServerSocketFactory {
    private final InetAddress mAddress;
    private final Ssl ssl;
    private volatile String[] enabledCipherSuites = null;
    private volatile String[] enabledProtocols = null;
    private final Object cipherSuitesSync = new Object();
    private final Object protocolsSync = new Object();
    private Map socketMap = new HashMap();

    public SecureRMIServerSocketFactory(Ssl sslConfig, InetAddress addr) {
        this.mAddress = addr;
        this.ssl = sslConfig;
        Util.getLogger().info("Creating a SecureRMIServerSocketFactory @ " + addr.getHostAddress() + "with ssl config = " + this.ssl.toString());
    }

    public boolean equals(Object obj) {
        if (obj instanceof SecureRMIServerSocketFactory) {
            return this.hashCode() == obj.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return this.ssl.hashCode() + this.mAddress.hashCode();
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        JMXSslConfigHolder sslConfigHolder;
        if (this.socketMap.containsKey(new Integer(port))) {
            return (ServerSocket)this.socketMap.get(new Integer(port));
        }
        int backlog = 5;
        try {
            sslConfigHolder = new JMXSslConfigHolder(this.ssl);
        }
        catch (SSLException ssle) {
            throw new IllegalStateException(ssle);
        }
        sslConfigHolder.configureSSL();
        SSLContext context = sslConfigHolder.getSSLContext();
        SSLServerSocket sslSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket(port, 5, this.mAddress);
        this.configureSSLSocket(sslSocket, sslConfigHolder);
        Util.getLogger().info("SSLServerSocket " + sslSocket.getLocalSocketAddress() + "and " + sslSocket.toString() + " created");
        this.socketMap.put(new Integer(port), sslSocket);
        return sslSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureSSLSocket(SSLServerSocket sslSocket, SSLConfigHolder sslConfigHolder) {
        Object object;
        if (sslConfigHolder.getEnabledCipherSuites() != null) {
            if (this.enabledCipherSuites == null) {
                object = this.cipherSuitesSync;
                synchronized (object) {
                    if (this.enabledCipherSuites == null) {
                        this.enabledCipherSuites = SecureRMIServerSocketFactory.configureEnabledCiphers(sslSocket, sslConfigHolder.getEnabledCipherSuites());
                    }
                }
            }
            sslSocket.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        if (sslConfigHolder.getEnabledProtocols() != null) {
            if (this.enabledProtocols == null) {
                object = this.protocolsSync;
                synchronized (object) {
                    if (this.enabledProtocols == null) {
                        this.enabledProtocols = SecureRMIServerSocketFactory.configureEnabledProtocols(sslSocket, sslConfigHolder.getEnabledProtocols());
                    }
                }
            }
            sslSocket.setEnabledProtocols(this.enabledProtocols);
        }
        sslSocket.setUseClientMode(sslConfigHolder.isClientMode());
    }

    private static final String[] configureEnabledProtocols(SSLServerSocket socket, String[] requestedProtocols) {
        String[] supportedProtocols = socket.getSupportedProtocols();
        String[] protocols = null;
        ArrayList<String> list = null;
        block0: for (String supportedProtocol : supportedProtocols) {
            for (String protocol : requestedProtocols) {
                if (!supportedProtocol.equals(protocol = protocol.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(protocol);
                continue block0;
            }
        }
        if (list != null) {
            protocols = list.toArray(new String[list.size()]);
        }
        return protocols;
    }

    private static final String[] configureEnabledCiphers(SSLServerSocket socket, String[] requestedCiphers) {
        String[] supportedCiphers = socket.getSupportedCipherSuites();
        String[] ciphers = null;
        ArrayList<String> list = null;
        block0: for (String supportedCipher : supportedCiphers) {
            for (String cipher : requestedCiphers) {
                if (!supportedCipher.equals(cipher = cipher.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(cipher);
                continue block0;
            }
        }
        if (list != null) {
            ciphers = list.toArray(new String[list.size()]);
        }
        return ciphers;
    }
}

