/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JaccProvider;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-jacc-provider")
@Scoped(value=PerLookup.class)
@I18n(value="delete.jacc.provider")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DeleteJaccProvider
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteJaccProvider.class);
    @Param(name="jaccprovidername", primary=true)
    private String jaccprovider;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    @Inject(name="default-instance-name")
    private Config config;
    @Inject
    private Configs configs;
    @Inject
    private Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Config tmp = null;
        try {
            tmp = this.configs.getConfigByName(this.target);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (tmp != null) {
            this.config = tmp;
        }
        if (tmp == null) {
            Cluster cluster;
            Server targetServer = this.domain.getServerNamed(this.target);
            if (targetServer != null) {
                this.config = this.domain.getConfigNamed(targetServer.getConfigRef());
            }
            if ((cluster = this.domain.getClusterNamed(this.target)) != null) {
                this.config = this.domain.getConfigNamed(cluster.getConfigRef());
            }
        }
        SecurityService securityService = this.config.getSecurityService();
        try {
            List jaccProviders = securityService.getJaccProvider();
            JaccProvider jprov = null;
            for (JaccProvider jaccProv : jaccProviders) {
                if (!jaccProv.getName().equals(this.jaccprovider)) continue;
                jprov = jaccProv;
                break;
            }
            if (jprov == null) {
                report.setMessage(localStrings.getLocalString("delete.jacc.provider.notfound", "JaccProvider named {0} not found", new Object[]{this.jaccprovider}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if ("default".equals(jprov.getName()) || "simple".equals(jprov.getName())) {
                report.setMessage(localStrings.getLocalString("delete.jacc.provider.notallowed", "JaccProvider named {0} is a system provider and cannot be deleted", new Object[]{this.jaccprovider}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            final JaccProvider jaccprov = jprov;
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<SecurityService>(){

                public Object run(SecurityService param) throws PropertyVetoException, TransactionFailure {
                    param.getJaccProvider().remove(jaccprov);
                    return null;
                }
            }, (ConfigBeanProxy)securityService);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.jacc.provider.fail", "Deletion of JaccProvider {0} failed", new Object[]{this.jaccprovider}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

