/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl;

import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.container.common.impl.EntityManagerWrapper;
import com.sun.enterprise.container.common.impl.FactoryForEntityManagerFactoryWrapper;
import com.sun.enterprise.container.common.spi.EjbNamingReferenceManager;
import com.sun.enterprise.container.common.spi.WebServiceReferenceManager;
import com.sun.enterprise.container.common.spi.util.CallFlowAgent;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.DataSourceDefinitionDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.naming.spi.NamingObjectFactory;
import com.sun.enterprise.naming.spi.NamingUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.ComponentNamingUtil;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.api.naming.JNDIBinding;
import org.glassfish.api.naming.NamingObjectProxy;
import org.glassfish.javaee.services.DataSourceDefinitionProxy;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ComponentEnvManagerImpl
implements ComponentEnvManager {
    private static final String JAVA_COLON = "java:";
    private static final String JAVA_COMP_ENV_STRING = "java:comp/env/";
    private static final String JAVA_COMP_PREFIX = "java:comp/";
    private static final String JAVA_MODULE_PREFIX = "java:module/";
    private static final String JAVA_APP_PREFIX = "java:app/";
    private static final String JAVA_GLOBAL_PREFIX = "java:global/";
    private static final String EIS_STRING = "/eis/";
    @Inject
    private Habitat habitat;
    @Inject
    private Logger _logger;
    @Inject
    GlassfishNamingManager namingManager;
    @Inject
    ComponentNamingUtil componentNamingUtil;
    @Inject
    private transient CallFlowAgent callFlowAgent;
    @Inject
    private transient TransactionManager txManager;
    @Inject
    private ProcessEnvironment processEnv;
    @Inject
    private NamingUtils namingUtils;
    @Inject
    private InvocationManager invMgr;
    private Map<String, JndiNameEnvironment> compId2Env = new ConcurrentHashMap<String, JndiNameEnvironment>();
    private static final String ID_SEPARATOR = "_";

    public void register(String componentId, JndiNameEnvironment env) {
        this.compId2Env.put(componentId, env);
    }

    public void unregister(String componentId) {
        this.compId2Env.remove(componentId);
    }

    @Override
    public JndiNameEnvironment getJndiNameEnvironment(String componentId) {
        return this.compId2Env.get(componentId);
    }

    @Override
    public JndiNameEnvironment getCurrentJndiNameEnvironment() {
        JndiNameEnvironment desc = null;
        ComponentInvocation inv = this.invMgr.getCurrentInvocation();
        if (inv != null && inv.componentId != null) {
            desc = this.compId2Env.get(inv.componentId);
        }
        return desc;
    }

    @Override
    public String bindToComponentNamespace(JndiNameEnvironment env) throws NamingException {
        Application app;
        String compEnvId = this.getComponentEnvId(env);
        ArrayList<JNDIBinding> bindings = new ArrayList<JNDIBinding>();
        this.addJNDIBindings(env, ScopeType.COMPONENT, bindings);
        this.addJNDIBindings(env, ScopeType.MODULE, bindings);
        if (!(env instanceof ApplicationClientDescriptor)) {
            this.addJNDIBindings(env, ScopeType.APP, bindings);
        }
        if (env instanceof Application) {
            app = (Application)env;
            for (ApplicationClientDescriptor applicationClientDescriptor : app.getApplicationClientDescriptors()) {
                this.addJNDIBindings((JndiNameEnvironment)applicationClientDescriptor, ScopeType.APP, bindings);
            }
            this.namingManager.bindToAppNamespace(this.getApplicationName(env), bindings);
        } else {
            boolean treatComponentAsModule = this.getTreatComponentAsModule(env);
            this.namingManager.bindToComponentNamespace(this.getApplicationName(env), this.getModuleName(env), compEnvId, treatComponentAsModule, bindings);
            compEnvId = this.getComponentEnvId(env);
        }
        if (!(env instanceof ApplicationClientDescriptor)) {
            ArrayList<JNDIBinding> globalBindings = new ArrayList<JNDIBinding>();
            this.addJNDIBindings(env, ScopeType.GLOBAL, globalBindings);
            if (env instanceof Application) {
                Application app2 = (Application)env;
                for (ApplicationClientDescriptor next : app2.getApplicationClientDescriptors()) {
                    this.addJNDIBindings((JndiNameEnvironment)next, ScopeType.GLOBAL, globalBindings);
                }
            }
            for (JNDIBinding jNDIBinding : globalBindings) {
                this.namingManager.publishObject(jNDIBinding.getName(), jNDIBinding.getValue(), true);
            }
        }
        app = this.getApplicationFromEnv(env);
        if (!(env instanceof ApplicationClientDescriptor) && app.getBundleDescriptors(ApplicationClientDescriptor.class).size() > 0) {
            for (JNDIBinding jNDIBinding : bindings) {
                if (!this.dependencyAppliesToScope(jNDIBinding.getName(), ScopeType.APP)) continue;
                String internalGlobalJavaAppName = this.componentNamingUtil.composeInternalGlobalJavaAppName(app.getAppName(), jNDIBinding.getName());
                this.namingManager.publishObject(internalGlobalJavaAppName, jNDIBinding.getValue(), true);
            }
        }
        if (compEnvId != null) {
            this.register(compEnvId, env);
        }
        return compEnvId;
    }

    @Override
    public void addToComponentNamespace(JndiNameEnvironment origEnv, Collection<EnvironmentProperty> envProps, Collection<ResourceReferenceDescriptor> resRefs) throws NamingException {
        String compEnvId = this.getComponentEnvId(origEnv);
        ArrayList<JNDIBinding> bindings = new ArrayList<JNDIBinding>();
        this.addEnvironmentProperties(ScopeType.COMPONENT, envProps.iterator(), bindings);
        this.addResourceReferences(ScopeType.COMPONENT, resRefs.iterator(), bindings);
        boolean treatComponentAsModule = this.getTreatComponentAsModule(origEnv);
        this.namingManager.bindToComponentNamespace(this.getApplicationName(origEnv), this.getModuleName(origEnv), compEnvId, treatComponentAsModule, bindings);
    }

    private void setResourceId(JndiNameEnvironment env, DataSourceDefinitionDescriptor desc) {
        String resourceId = "";
        if (this.dependencyAppliesToScope((Descriptor)desc, ScopeType.COMPONENT)) {
            resourceId = this.getApplicationName(env) + "/" + this.getModuleName(env) + "/" + this.getComponentEnvId(env);
        } else if (this.dependencyAppliesToScope((Descriptor)desc, ScopeType.MODULE)) {
            resourceId = this.getApplicationName(env) + "/" + this.getModuleName(env);
        } else if (this.dependencyAppliesToScope((Descriptor)desc, ScopeType.APP)) {
            resourceId = this.getApplicationName(env);
        }
        desc.setResourceId(resourceId);
    }

    private void addDataSourceBindings(JndiNameEnvironment env, ScopeType scope, Collection<JNDIBinding> jndiBindings) {
        for (DataSourceDefinitionDescriptor dsd : env.getDataSourceDefinitionDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)dsd, scope) || dsd.isDeployed()) continue;
            this.setResourceId(env, dsd);
            DataSourceDefinitionProxy proxy = (DataSourceDefinitionProxy)this.habitat.getComponent(DataSourceDefinitionProxy.class);
            proxy.setDescriptor(dsd);
            String logicalJndiName = this.descriptorToLogicalJndiName((Descriptor)dsd);
            CompEnvBinding envBinding = new CompEnvBinding(logicalJndiName, proxy);
            jndiBindings.add(envBinding);
            dsd.setDeployed(true);
        }
    }

    private ResourceDeployer getResourceDeployer(Object resource, Collection<ResourceDeployer> deployers) {
        ResourceDeployer resourceDeployer = null;
        for (ResourceDeployer deployer : deployers) {
            if (!deployer.handles(resource)) continue;
            resourceDeployer = deployer;
            break;
        }
        return resourceDeployer;
    }

    @Override
    public void unbindFromComponentNamespace(JndiNameEnvironment env) throws NamingException {
        this.undeployDataSourceDefinitions(env);
        ArrayList<JNDIBinding> globalBindings = new ArrayList<JNDIBinding>();
        this.addJNDIBindings(env, ScopeType.GLOBAL, globalBindings);
        for (JNDIBinding next : globalBindings) {
            this.namingManager.unpublishObject(next.getName());
        }
        Application app = this.getApplicationFromEnv(env);
        Set appClientDescs = app.getBundleDescriptors(ApplicationClientDescriptor.class);
        for (ApplicationClientDescriptor acd : appClientDescs) {
            this.undeployDataSourceDefinitions((JndiNameEnvironment)acd);
        }
        if (!(env instanceof ApplicationClientDescriptor) && app.getBundleDescriptors(ApplicationClientDescriptor.class).size() > 0) {
            ArrayList<JNDIBinding> appBindings = new ArrayList<JNDIBinding>();
            this.addJNDIBindings(env, ScopeType.APP, appBindings);
            for (JNDIBinding next : appBindings) {
                String internalGlobalJavaAppName = this.componentNamingUtil.composeInternalGlobalJavaAppName(app.getAppName(), next.getName());
                this.namingManager.unpublishObject(internalGlobalJavaAppName);
            }
        }
        if (env instanceof Application) {
            this.namingManager.unbindAppObjects(this.getApplicationName(env));
        } else {
            String compEnvId = this.getComponentEnvId(env);
            this.namingManager.unbindComponentObjects(compEnvId);
            this.unregister(compEnvId);
        }
    }

    private void undeployDataSourceDefinitions(JndiNameEnvironment env) {
        for (DataSourceDefinitionDescriptor dsd : env.getDataSourceDefinitionDescriptors()) {
            Collection resourceDeployers = this.habitat.getAllByContract(ResourceDeployer.class);
            try {
                if (!dsd.isDeployed()) continue;
                ResourceDeployer deployer = this.getResourceDeployer(dsd, resourceDeployers);
                deployer.undeployResource((Object)dsd);
                dsd.setDeployed(false);
            }
            catch (Exception e) {
                this._logger.log(Level.WARNING, "unable to undeploy DataSourceDefinition [ " + dsd.getName() + " ] ", e);
            }
        }
    }

    private void addEnvironmentProperties(ScopeType scope, Iterator envItr, Collection<JNDIBinding> jndiBindings) {
        while (envItr.hasNext()) {
            EnvironmentProperty next = (EnvironmentProperty)envItr.next();
            if (!this.dependencyAppliesToScope((Descriptor)next, scope) || !next.hasAValue()) continue;
            String name = this.descriptorToLogicalJndiName((Descriptor)next);
            NamingObjectFactory value = next.hasLookupName() ? this.namingUtils.createLazyNamingObjectFactory(name, next.getLookupName(), true) : this.namingUtils.createSimpleNamingObjectFactory(name, next.getValueObject());
            jndiBindings.add(new CompEnvBinding(name, value));
        }
    }

    private void addResourceReferences(ScopeType scope, Iterator resRefItr, Collection<JNDIBinding> jndiBindings) {
        while (resRefItr.hasNext()) {
            ResourceReferenceDescriptor resourceRef = (ResourceReferenceDescriptor)resRefItr.next();
            if (!this.dependencyAppliesToScope((Descriptor)resourceRef, scope)) continue;
            String name = this.descriptorToLogicalJndiName((Descriptor)resourceRef);
            Object value = null;
            String physicalJndiName = resourceRef.getJndiName();
            if (resourceRef.isURLResource()) {
                URL obj = null;
                try {
                    obj = new URL(physicalJndiName);
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
                NamingObjectFactory factory = this.namingUtils.createSimpleNamingObjectFactory(name, (Object)obj);
                value = this.namingUtils.createCloningNamingObjectFactory(name, factory);
            } else if (resourceRef.isORB()) {
                value = this.namingUtils.createLazyNamingObjectFactory(name, physicalJndiName, false);
            } else if (resourceRef.isWebServiceContext()) {
                WebServiceReferenceManager wsRefMgr = (WebServiceReferenceManager)this.habitat.getByContract(WebServiceReferenceManager.class);
                if (wsRefMgr != null) {
                    value = wsRefMgr.getWSContextObject();
                } else {
                    this._logger.log(Level.SEVERE, "Cannot find the following class to proceed with @Resource WebServiceContext" + wsRefMgr + "Please confirm if webservices module is installed ");
                }
            } else {
                value = this.namingUtils.createLazyNamingObjectFactory(name, physicalJndiName, false);
            }
            jndiBindings.add(new CompEnvBinding(name, value));
        }
    }

    private void addJNDIBindings(JndiNameEnvironment env, ScopeType scope, Collection<JNDIBinding> jndiBindings) {
        Object value;
        String name;
        this.addEnvironmentProperties(scope, env.getEnvironmentProperties().iterator(), jndiBindings);
        for (JmsDestinationReferenceDescriptor next : env.getJmsDestinationReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)next, scope)) continue;
            jndiBindings.add(this.getCompEnvBinding(next));
        }
        this.addDataSourceBindings(env, scope, jndiBindings);
        for (JmsDestinationReferenceDescriptor next : env.getEjbReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)next, scope)) continue;
            name = this.descriptorToLogicalJndiName((Descriptor)next);
            EjbReferenceProxy proxy = new EjbReferenceProxy((EjbReferenceDescriptor)next);
            jndiBindings.add(new CompEnvBinding(name, proxy));
        }
        for (JmsDestinationReferenceDescriptor next : env.getMessageDestinationReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)next, scope)) continue;
            jndiBindings.add(this.getCompEnvBinding((MessageDestinationReferenceDescriptor)next));
        }
        this.addResourceReferences(scope, env.getResourceReferenceDescriptors().iterator(), jndiBindings);
        for (JmsDestinationReferenceDescriptor next : env.getEntityManagerFactoryReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)next, scope)) continue;
            name = this.descriptorToLogicalJndiName((Descriptor)next);
            value = new FactoryForEntityManagerFactoryWrapper(next.getUnitName(), this.invMgr, this);
            jndiBindings.add(new CompEnvBinding(name, value));
        }
        for (JmsDestinationReferenceDescriptor next : env.getServiceReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)next, scope)) continue;
            if (next.getMappedName() != null) {
                next.setName(next.getMappedName());
            }
            name = this.descriptorToLogicalJndiName((Descriptor)next);
            value = new WebServiceRefProxy((ServiceReferenceDescriptor)next);
            jndiBindings.add(new CompEnvBinding(name, value));
        }
        for (JmsDestinationReferenceDescriptor next : env.getEntityManagerReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)next, scope)) continue;
            name = this.descriptorToLogicalJndiName((Descriptor)next);
            value = new FactoryForEntityManagerWrapper((EntityManagerReferenceDescriptor)next, this);
            jndiBindings.add(new CompEnvBinding(name, value));
        }
    }

    private CompEnvBinding getCompEnvBinding(final JmsDestinationReferenceDescriptor next) {
        final String name = this.descriptorToLogicalJndiName((Descriptor)next);
        Object value = null;
        if (next.isEJBContext()) {
            value = new EjbContextProxy(next.getRefType());
        } else if (next.isValidator()) {
            value = new ValidatorProxy();
        } else if (next.isValidatorFactory()) {
            value = new ValidatorFactoryProxy();
        } else if (next.isCDIBeanManager()) {
            value = this.namingUtils.createLazyNamingObjectFactory(name, "java:comp/BeanManager", false);
        } else if (next.isManagedBean()) {
            ManagedBeanDescriptor managedBeanDesc = next.getManagedBeanDescriptor();
            value = this.processEnv.getProcessType().isServer() ? this.namingUtils.createLazyNamingObjectFactory(name, next.getJndiName(), false) : this.namingUtils.createLazyNamingObjectFactory(name, managedBeanDesc.getAppJndiName(), false);
        } else {
            value = new NamingObjectFactory(){
                NamingObjectFactory delegate;
                {
                    this.delegate = ComponentEnvManagerImpl.this.namingUtils.createLazyNamingObjectFactory(name, next.getJndiName(), false);
                }

                public boolean isCreateResultCacheable() {
                    return false;
                }

                public Object create(Context ic) throws NamingException {
                    try {
                        return this.delegate.create(ic);
                    }
                    catch (NamingException e) {
                        Object ref = ComponentEnvManagerImpl.this.habitat.getComponent(next.getRefType(), next.getMappedName());
                        if (ref != null) {
                            return ref;
                        }
                        throw e;
                    }
                }
            };
        }
        return new CompEnvBinding(name, value);
    }

    private CompEnvBinding getCompEnvBinding(MessageDestinationReferenceDescriptor next) {
        String name = this.descriptorToLogicalJndiName((Descriptor)next);
        String physicalJndiName = null;
        physicalJndiName = next.isLinkedToMessageDestination() ? next.getMessageDestination().getJndiName() : next.getJndiName();
        NamingObjectFactory value = this.namingUtils.createLazyNamingObjectFactory(name, physicalJndiName, true);
        return new CompEnvBinding(name, value);
    }

    private boolean dependencyAppliesToScope(Descriptor descriptor, ScopeType scope) {
        String name = descriptor.getName();
        return this.dependencyAppliesToScope(name, scope);
    }

    private boolean dependencyAppliesToScope(String name, ScopeType scope) {
        boolean appliesToScope = false;
        switch (scope) {
            case COMPONENT: {
                appliesToScope = name.startsWith(JAVA_COMP_PREFIX) || !name.startsWith(JAVA_COLON);
                break;
            }
            case MODULE: {
                appliesToScope = name.startsWith(JAVA_MODULE_PREFIX);
                break;
            }
            case APP: {
                appliesToScope = name.startsWith(JAVA_APP_PREFIX);
                break;
            }
            case GLOBAL: {
                appliesToScope = name.startsWith(JAVA_GLOBAL_PREFIX);
            }
        }
        return appliesToScope;
    }

    private boolean getTreatComponentAsModule(JndiNameEnvironment env) {
        EjbDescriptor ejbDesc;
        EjbBundleDescriptor ejbBundle;
        boolean treatComponentAsModule = false;
        if (env instanceof WebBundleDescriptor) {
            treatComponentAsModule = true;
        } else if (env instanceof EjbDescriptor && (ejbBundle = (ejbDesc = (EjbDescriptor)env).getEjbBundleDescriptor()).getModuleDescriptor().getDescriptor() instanceof WebBundleDescriptor) {
            treatComponentAsModule = true;
        }
        return treatComponentAsModule;
    }

    private String descriptorToLogicalJndiName(Descriptor descriptor) {
        String rawName = descriptor.getName();
        return rawName.startsWith(JAVA_COLON) ? rawName : JAVA_COMP_ENV_STRING + rawName;
    }

    @Override
    public String getComponentEnvId(JndiNameEnvironment env) {
        String id = null;
        if (env instanceof EjbDescriptor) {
            EjbDescriptor ejbEnv = (EjbDescriptor)env;
            String flattedJndiName = ejbEnv.getJndiName().replace('/', '.');
            EjbBundleDescriptor ejbBundle = ejbEnv.getEjbBundleDescriptor();
            id = ejbEnv.getApplication().getName() + ID_SEPARATOR + ejbBundle.getModuleDescriptor().getArchiveUri() + ID_SEPARATOR + ejbEnv.getName() + ID_SEPARATOR + flattedJndiName + ejbEnv.getUniqueId();
        } else if (env instanceof WebBundleDescriptor) {
            WebBundleDescriptor webEnv = (WebBundleDescriptor)env;
            id = webEnv.getApplication().getName() + ID_SEPARATOR + webEnv.getContextRoot();
        } else if (env instanceof ApplicationClientDescriptor) {
            ApplicationClientDescriptor appEnv = (ApplicationClientDescriptor)env;
            id = "client_" + appEnv.getName() + ID_SEPARATOR + appEnv.getMainClassName();
        } else if (env instanceof ManagedBeanDescriptor) {
            id = ((ManagedBeanDescriptor)env).getGlobalJndiName();
        } else if (env instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)env;
            id = "__ejbBundle___" + ejbBundle.getApplication().getName() + ID_SEPARATOR + ejbBundle.getModuleName();
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, this.getApplicationName(env) + "Component Id: " + id);
        }
        return id;
    }

    private Application getApplicationFromEnv(JndiNameEnvironment env) {
        Application app = null;
        if (env instanceof EjbDescriptor) {
            EjbDescriptor ejbEnv = (EjbDescriptor)env;
            app = ejbEnv.getApplication();
        } else if (env instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)env;
            app = ejbBundle.getApplication();
        } else if (env instanceof WebBundleDescriptor) {
            WebBundleDescriptor webEnv = (WebBundleDescriptor)env;
            app = webEnv.getApplication();
        } else if (env instanceof ApplicationClientDescriptor) {
            ApplicationClientDescriptor appEnv = (ApplicationClientDescriptor)env;
            app = appEnv.getApplication();
        } else if (env instanceof ManagedBeanDescriptor) {
            ManagedBeanDescriptor mb = (ManagedBeanDescriptor)env;
            app = mb.getBundle().getApplication();
        } else if (env instanceof Application) {
            app = (Application)env;
        } else {
            throw new IllegalArgumentException("IllegalJndiNameEnvironment : env");
        }
        return app;
    }

    private String getApplicationName(JndiNameEnvironment env) {
        String appName = "";
        Application app = this.getApplicationFromEnv(env);
        if (app == null) {
            throw new IllegalArgumentException("IllegalJndiNameEnvironment : env");
        }
        appName = app.getAppName();
        return appName;
    }

    private String getModuleName(JndiNameEnvironment env) {
        String moduleName = null;
        if (env instanceof EjbDescriptor) {
            EjbDescriptor ejbEnv = (EjbDescriptor)env;
            EjbBundleDescriptor ejbBundle = ejbEnv.getEjbBundleDescriptor();
            moduleName = ejbBundle.getModuleDescriptor().getModuleName();
        } else if (env instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)env;
            moduleName = ejbBundle.getModuleDescriptor().getModuleName();
        } else if (env instanceof WebBundleDescriptor) {
            WebBundleDescriptor webEnv = (WebBundleDescriptor)env;
            moduleName = webEnv.getModuleName();
        } else if (env instanceof ApplicationClientDescriptor) {
            ApplicationClientDescriptor appEnv = (ApplicationClientDescriptor)env;
            moduleName = appEnv.getModuleName();
        } else if (env instanceof ManagedBeanDescriptor) {
            ManagedBeanDescriptor mb = (ManagedBeanDescriptor)env;
            moduleName = mb.getBundle().getModuleName();
        } else {
            throw new IllegalArgumentException("IllegalJndiNameEnvironment : env");
        }
        return moduleName;
    }

    private static boolean isConnector(String logicalJndiName) {
        return logicalJndiName.indexOf(EIS_STRING) != -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ScopeType {
        COMPONENT,
        MODULE,
        APP,
        GLOBAL;

    }

    private static class CompEnvBinding
    implements JNDIBinding {
        private String name;
        private Object value;

        CompEnvBinding(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }

    private class EjbReferenceProxy
    implements NamingObjectProxy {
        private EjbReferenceDescriptor ejbRef;
        private volatile EjbNamingReferenceManager ejbRefMgr;
        private volatile Object cachedResult = null;
        private Boolean cacheable;

        EjbReferenceProxy(EjbReferenceDescriptor ejbRef) {
            this.ejbRef = ejbRef;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object create(Context ctx) throws NamingException {
            Object result = null;
            if (this.ejbRefMgr == null) {
                EjbReferenceProxy ejbReferenceProxy = this;
                synchronized (ejbReferenceProxy) {
                    if (this.ejbRefMgr == null) {
                        this.ejbRefMgr = (EjbNamingReferenceManager)ComponentEnvManagerImpl.this.habitat.getByContract(EjbNamingReferenceManager.class);
                        this.cacheable = new Boolean(this.ejbRefMgr.isEjbReferenceCacheable(this.ejbRef));
                    }
                }
            }
            if (this.ejbRefMgr != null) {
                result = this.cacheable != null && this.cacheable.booleanValue() ? (this.cachedResult != null ? this.cachedResult : (this.cachedResult = this.ejbRefMgr.resolveEjbReference(this.ejbRef, ctx))) : this.ejbRefMgr.resolveEjbReference(this.ejbRef, ctx);
            }
            if (result == null) {
                throw new NameNotFoundException("Can not resolve ejb reference " + this.ejbRef.getName() + " : " + this.ejbRef);
            }
            return result;
        }
    }

    private class WebServiceRefProxy
    implements NamingObjectProxy {
        private WebServiceReferenceManager wsRefMgr;
        private ServiceReferenceDescriptor serviceRef;

        WebServiceRefProxy(ServiceReferenceDescriptor servRef) {
            this.serviceRef = servRef;
        }

        public Object create(Context ctx) throws NamingException {
            Object result = null;
            this.wsRefMgr = (WebServiceReferenceManager)ComponentEnvManagerImpl.this.habitat.getByContract(WebServiceReferenceManager.class);
            if (this.wsRefMgr != null) {
                result = this.wsRefMgr.resolveWSReference(this.serviceRef, ctx);
            } else {
                ComponentEnvManagerImpl.this._logger.log(Level.SEVERE, "Cannot find the following class to proceed with @WebServiceRef" + this.wsRefMgr + "Please confirm if webservices module is installed ");
            }
            if (result == null) {
                throw new NameNotFoundException("Can not resolve webservice context of type " + this.serviceRef.getName());
            }
            return result;
        }
    }

    private class ValidatorFactoryProxy
    implements NamingObjectProxy {
        private volatile ValidatorFactory validatorFactory;

        ValidatorFactoryProxy() {
        }

        public Object create(Context ctx) throws NamingException {
            String nameForValidatorFactory = "java:comp/ValidatorFactory";
            String exceptionMessage = "Can not obtain reference to ValidatorFactory instance ";
            if (null == this.validatorFactory) {
                try {
                    this.validatorFactory = (ValidatorFactory)ctx.lookup("java:comp/ValidatorFactory");
                }
                catch (NamingException ne) {
                    exceptionMessage = "Unable to lookup java:comp/ValidatorFactory:" + ne.toString();
                }
            }
            if (null == this.validatorFactory) {
                try {
                    this.validatorFactory = Validation.buildDefaultValidatorFactory();
                }
                catch (ValidationException e) {
                    exceptionMessage = "Could not build a default Bean Validator factory: " + e.toString();
                }
            }
            return this.validatorFactory;
        }
    }

    private class ValidatorProxy
    implements NamingObjectProxy {
        private volatile ValidatorFactory validatorFactory;
        private volatile Validator validator;

        ValidatorProxy() {
        }

        public Object create(Context ctx) throws NamingException {
            String nameForValidator = "java:comp/Validator";
            String exceptionMessage = "Can not obtain reference to Validator instance ";
            if (null == this.validator) {
                try {
                    this.validator = (Validator)ctx.lookup("java:comp/Validator");
                }
                catch (NamingException ne) {
                    exceptionMessage = "Unable to lookup java:comp/Validator:" + ne.toString();
                }
            }
            if (null == this.validator) {
                if (null == this.validatorFactory) {
                    ValidatorFactoryProxy factoryProxy = new ValidatorFactoryProxy();
                    this.validatorFactory = (ValidatorFactory)factoryProxy.create(ctx);
                }
                if (null != this.validatorFactory) {
                    ValidatorContext validatorContext = this.validatorFactory.usingContext();
                    this.validator = validatorContext.getValidator();
                }
            }
            if (this.validator == null) {
                throw new NameNotFoundException(exceptionMessage);
            }
            return this.validator;
        }
    }

    private class EjbContextProxy
    implements NamingObjectProxy {
        private volatile EjbNamingReferenceManager ejbRefMgr;
        private String contextType;

        EjbContextProxy(String contextType) {
            this.contextType = contextType;
        }

        public Object create(Context ctx) throws NamingException {
            Object result = null;
            if (this.ejbRefMgr == null) {
                this.ejbRefMgr = (EjbNamingReferenceManager)ComponentEnvManagerImpl.this.habitat.getByContract(EjbNamingReferenceManager.class);
            }
            if (this.ejbRefMgr != null) {
                result = this.ejbRefMgr.getEJBContextObject(this.contextType);
            }
            if (result == null) {
                throw new NameNotFoundException("Can not resolve EJB context of type " + this.contextType);
            }
            return result;
        }
    }

    private class FactoryForEntityManagerWrapper
    implements NamingObjectProxy {
        private final EntityManagerReferenceDescriptor refDesc;
        private final ComponentEnvManager compEnvMgr;

        FactoryForEntityManagerWrapper(EntityManagerReferenceDescriptor refDesc, ComponentEnvManager compEnvMgr) {
            this.refDesc = refDesc;
            this.compEnvMgr = compEnvMgr;
        }

        public Object create(Context ctx) {
            EntityManagerWrapper emWrapper = new EntityManagerWrapper(ComponentEnvManagerImpl.this.txManager, ComponentEnvManagerImpl.this.invMgr, this.compEnvMgr, ComponentEnvManagerImpl.this.callFlowAgent);
            emWrapper.initializeEMWrapper(this.refDesc.getUnitName(), this.refDesc.getPersistenceContextType(), this.refDesc.getProperties());
            return emWrapper;
        }
    }
}

