/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.util.io.DomainDirs;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="change-master-password")
@Scoped(value=PerLookup.class)
public class ChangeMasterPasswordCommand
extends CLICommand {
    @Inject
    private Habitat habitat;
    @Param(name="savemasterpassword", optional=true, defaultValue="false")
    private boolean savemp;
    @Param(name="domain_name_or_node_name", primary=true, optional=true)
    private String domainNameOrNodeName;
    @Param(name="nodedir", optional=true)
    protected String nodeDir;
    private final String CHANGE_MASTER_PASSWORD_DAS = "_change-master-password-das";
    private final String CHANGE_MASTER_PASSWORD_NODE = "_change-master-password-node";

    protected int executeCommand() throws CommandException {
        return 0;
    }

    public int execute(String ... args) throws CommandException {
        super.execute(args);
        CLICommand command = null;
        try {
            if (this.isDomain()) {
                command = CLICommand.getCommand((Habitat)this.habitat, (String)"_change-master-password-das");
                return command.execute(args);
            }
            if (this.nodeDir != null) {
                command = CLICommand.getCommand((Habitat)this.habitat, (String)"_change-master-password-node");
                return command.execute(args);
            }
            ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
            arguments.remove(args.length - 1);
            arguments.add("--nodedir");
            arguments.add(this.getDefaultNodesDirs().getAbsolutePath());
            arguments.add(this.domainNameOrNodeName);
            String[] newargs = arguments.toArray(new String[0]);
            command = CLICommand.getCommand((Habitat)this.habitat, (String)"_change-master-password-node");
            return command.execute(newargs);
        }
        catch (IOException e) {
            throw new CommandException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean isDomain() throws IOException {
        return new File(DomainDirs.getDefaultDomainsDir(), this.domainNameOrNodeName).isDirectory();
    }

    private File getDefaultNodesDirs() throws IOException {
        return new File(DomainDirs.getDefaultDomainsDir().getParent(), "nodes");
    }
}

