/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgi.ee.resources;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.osgi.ee.resources.JDBCResourceManager;
import org.glassfish.osgi.ee.resources.JMSDestinationResourceManager;
import org.glassfish.osgi.ee.resources.JMSResourceManager;
import org.glassfish.osgi.ee.resources.ResourceHelper;
import org.glassfish.osgi.ee.resources.ResourceManager;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.UnprocessedChangeEvents;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceProviderService
implements ConfigListener {
    private Habitat habitat;
    private Resources resources;
    private Servers servers;
    private ObservableBean serverConfigBean;
    private ObservableBean resourcesConfigBean;
    private BundleContext bundleContext;
    private ResourceHelper resourceHelper;
    private static final Logger logger = Logger.getLogger(ResourceProviderService.class.getPackage().getName());

    public ResourceProviderService(Habitat habitat, BundleContext bundleContext) {
        this.habitat = habitat;
        this.bundleContext = bundleContext;
        this.servers = (Servers)habitat.getComponent(Servers.class);
        this.resources = ((Domain)habitat.getComponent(Domain.class)).getResources();
        this.resourceHelper = new ResourceHelper(habitat);
        this.postConstruct();
    }

    private Habitat getHabitat() {
        return this.habitat;
    }

    public void registerResources() {
        Collection<ResourceManager> resourceManagers = this.getAllResourceManagers();
        for (ResourceManager rm : resourceManagers) {
            rm.registerResources(this.bundleContext);
        }
    }

    public void unRegisterResources() {
        Collection<ResourceManager> resourceManagers = this.getAllResourceManagers();
        for (ResourceManager rm : resourceManagers) {
            rm.unRegisterResources(this.bundleContext);
        }
        this.preDestroy();
    }

    public void preDestroy() {
        if (this.serverConfigBean != null) {
            this.serverConfigBean.removeListener((ConfigListener)this);
        }
        if (this.resourcesConfigBean != null) {
            this.resourcesConfigBean.removeListener((ConfigListener)this);
        }
    }

    public void postConstruct() {
        List serversList = this.servers.getServer();
        ServerContext context = (ServerContext)this.getHabitat().getComponent(ServerContext.class);
        String instanceName = context.getInstanceName();
        for (Server server : serversList) {
            if (!server.getName().equals(instanceName)) continue;
            this.serverConfigBean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)server);
            this.serverConfigBean.addListener((ConfigListener)this);
        }
        this.resourcesConfigBean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)this.resources);
        this.resourcesConfigBean.addListener((ConfigListener)this);
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new PropertyChangeHandler(events), (Logger)logger);
    }

    private Collection<ResourceManager> getResourceManagers(BindableResource resource) {
        ArrayList<ResourceManager> resourceManagers = new ArrayList<ResourceManager>();
        for (ResourceManager rm : this.getAllResourceManagers()) {
            if (!rm.handlesResource(resource)) continue;
            resourceManagers.add(rm);
        }
        return resourceManagers;
    }

    private Collection<ResourceManager> getAllResourceManagers() {
        Habitat habitat = this.getHabitat();
        ArrayList<ResourceManager> resourceManagers = new ArrayList<ResourceManager>();
        resourceManagers.add(new JDBCResourceManager(habitat));
        if (this.runtimeSupportsJMS()) {
            this.registerJMSResources(resourceManagers, habitat);
        }
        return resourceManagers;
    }

    private boolean runtimeSupportsJMS() {
        boolean supports = false;
        try {
            Class.forName("javax.jms.QueueConnectionFactory");
            supports = true;
        }
        catch (Throwable e) {
            logger.finest("Exception while loading JMS API " + e);
        }
        return supports;
    }

    private void registerJMSResources(Collection<ResourceManager> resourceManagers, Habitat habitat) {
        resourceManagers.add(new JMSResourceManager(habitat));
        resourceManagers.add(new JMSDestinationResourceManager(habitat));
    }

    private ResourceHelper getResourceHelper() {
        return this.resourceHelper;
    }

    private void debug(String s) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[osgi-ee-resources] : " + s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PropertyChangeHandler
    implements Changed {
        PropertyChangeEvent[] events;

        private PropertyChangeHandler(PropertyChangeEvent[] events) {
            this.events = events;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
            NotProcessed np = null;
            switch (type) {
                case ADD: {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("A new " + changedType.getName() + " was added : " + changedInstance);
                    }
                    np = this.handleAddEvent(changedInstance);
                    break;
                }
                case CHANGE: {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("A " + changedType.getName() + " was changed : " + changedInstance);
                    }
                    np = this.handleChangeEvent(changedInstance);
                    break;
                }
                case REMOVE: {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("A " + changedType.getName() + " was removed : " + changedInstance);
                    }
                    np = this.handleRemoveEvent(changedInstance);
                    break;
                }
                default: {
                    np = new NotProcessed("Unrecognized type of change: " + type);
                }
            }
            NotProcessed notProcessed = np;
            return notProcessed;
        }

        private <T extends ConfigBeanProxy> NotProcessed handleRemoveEvent(T removedInstance) {
            if (removedInstance instanceof ResourceRef) {
                ResourceRef resourceRef = (ResourceRef)removedInstance;
                String resourceName = resourceRef.getRef();
                BindableResource resource = (BindableResource)ResourceProviderService.this.resources.getResourceByName(BindableResource.class, resourceName);
                this.unRegisterResource(resource);
            } else if (removedInstance instanceof BindableResource) {
                this.unRegisterResource((BindableResource)removedInstance);
            }
            return null;
        }

        private <T extends ConfigBeanProxy> NotProcessed handleChangeEvent(T changedInstance) {
            block5: {
                block4: {
                    if (!(changedInstance instanceof ResourceRef)) break block4;
                    ResourceRef resourceRef = (ResourceRef)changedInstance;
                    String refName = resourceRef.getRef();
                    for (PropertyChangeEvent event : this.events) {
                        String propertyName = event.getPropertyName();
                        if (!"enabled".equalsIgnoreCase(propertyName)) continue;
                        boolean newValue = Boolean.parseBoolean(event.getNewValue().toString());
                        boolean oldValue = Boolean.parseBoolean(event.getOldValue().toString());
                        if (newValue && oldValue) continue;
                        BindableResource bindableResource = (BindableResource)ResourceProviderService.this.resources.getResourceByName(BindableResource.class, refName);
                        if (newValue) {
                            this.registerResource(bindableResource, resourceRef);
                            continue;
                        }
                        this.unRegisterResource(bindableResource);
                    }
                    break block5;
                }
                if (!(changedInstance instanceof BindableResource)) break block5;
                BindableResource bindableResource = (BindableResource)changedInstance;
                for (PropertyChangeEvent event : this.events) {
                    String propertyName = event.getPropertyName();
                    if (!"enabled".equalsIgnoreCase(propertyName)) continue;
                    boolean newValue = Boolean.parseBoolean(event.getNewValue().toString());
                    boolean oldValue = Boolean.parseBoolean(event.getOldValue().toString());
                    if (newValue && oldValue) continue;
                    if (newValue) {
                        this.registerResource(bindableResource);
                        continue;
                    }
                    this.unRegisterResource(bindableResource);
                }
            }
            return null;
        }

        private void unRegisterResource(BindableResource bindableResource) {
            Collection resourceManagers = ResourceProviderService.this.getResourceManagers(bindableResource);
            for (ResourceManager rm : resourceManagers) {
                ResourceRef ref = ResourceProviderService.this.getResourceHelper().getResourceRef(bindableResource.getJndiName());
                rm.unRegisterResource(bindableResource, ref, ResourceProviderService.this.bundleContext);
            }
        }

        private void registerResource(BindableResource bindableResource, ResourceRef ref) {
            Collection resourceManagers = ResourceProviderService.this.getResourceManagers(bindableResource);
            for (ResourceManager rm : resourceManagers) {
                rm.registerResource(bindableResource, ref, ResourceProviderService.this.bundleContext);
            }
        }

        private void registerResource(BindableResource bindableResource) {
            ResourceRef ref = ResourceProviderService.this.getResourceHelper().getResourceRef(bindableResource.getJndiName());
            this.registerResource(bindableResource, ref);
        }

        private <T extends ConfigBeanProxy> NotProcessed handleAddEvent(T addedInstance) {
            if (addedInstance instanceof ResourceRef) {
                ResourceRef resourceRef = (ResourceRef)addedInstance;
                String resourceName = resourceRef.getRef();
                BindableResource resource = (BindableResource)ResourceProviderService.this.resources.getResourceByName(BindableResource.class, resourceName);
                if (resource != null) {
                    this.registerResource(resource, resourceRef);
                }
            }
            return null;
        }
    }
}

