/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.impl;

import com.sun.corba.ee.spi.folb.GroupInfoService;
import com.sun.corba.ee.spi.folb.GroupInfoServiceObserver;
import com.sun.enterprise.naming.impl.GroupInfoServiceObserverImpl;
import com.sun.enterprise.naming.impl.RoundRobinPolicy;
import com.sun.enterprise.naming.impl.SerialContext;
import com.sun.enterprise.naming.impl.WrappedSerialContext;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.NamingManager;
import org.glassfish.api.naming.NamingObjectsProvider;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ORBLocator;
import org.jvnet.hk2.component.Habitat;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialInitContextFactory
implements InitialContextFactory {
    public static final String LOAD_BALANCING_PROPERTY = "com.sun.appserv.iiop.loadbalancingpolicy";
    public static final String IIOP_ENDPOINTS_PROPERTY = "com.sun.appserv.iiop.endpoints";
    public static final String IIOP_URL_PROPERTY = "com.sun.appserv.ee.iiop.endpointslist";
    public static final String IC_BASED_WEIGHTED = "ic-based-weighted";
    public static final String IC_BASED = "ic-based";
    public static final String IIOP_URL = "iiop:1.2@";
    public static final String CORBALOC = "corbaloc:";
    private static volatile boolean initialized = false;
    private static volatile RoundRobinPolicy rrPolicy;
    private static volatile GroupInfoServiceObserverImpl giso;
    protected static final Logger _logger;
    private static String defaultHost;
    private static String defaultPort;
    private static Habitat defaultHabitat;
    private boolean useLB;
    private final Habitat habitat;

    private static void doLog(Level level, String fmt, Object ... args) {
        if (_logger.isLoggable(level)) {
            _logger.log(level, fmt, args);
        }
    }

    private static void fineLog(String fmt, Object ... args) {
        SerialInitContextFactory.doLog(Level.FINE, fmt, args);
    }

    static void setDefaultHost(String host) {
        defaultHost = host;
    }

    static void setDefaultPort(String port) {
        defaultPort = port;
    }

    static void setDefaultHabitat(Habitat h) {
        defaultHabitat = h;
    }

    static Habitat getDefaultHabitat() {
        return defaultHabitat;
    }

    private boolean propertyIsSet(Hashtable env, String pname) {
        String value = this.getEnvSysProperty(env, pname);
        return value != null && !value.isEmpty();
    }

    private List<String> splitOnComma(String arg) {
        String[] splits;
        ArrayList<String> result = new ArrayList<String>();
        if (arg != null && (splits = arg.split(",")) != null) {
            for (String str : splits) {
                result.add(str.trim());
            }
        }
        return result;
    }

    private String getEnvSysProperty(Hashtable env, String pname) {
        String value = (String)env.get(pname);
        if (value == null) {
            value = System.getProperty(pname);
        }
        return value;
    }

    private List<String> getEndpointList(Hashtable env) {
        String first;
        ArrayList<String> list = new ArrayList<String>();
        String lbpv = this.getEnvSysProperty(env, LOAD_BALANCING_PROPERTY);
        List<String> lbList = this.splitOnComma(lbpv);
        if (lbList.size() > 0 && ((first = lbList.remove(0)).equals(IC_BASED) || first.equals(IC_BASED_WEIGHTED))) {
            System.setProperty(LOAD_BALANCING_PROPERTY, first);
        }
        list.addAll(lbList);
        if (list.isEmpty()) {
            String iepv = this.getEnvSysProperty(env, IIOP_ENDPOINTS_PROPERTY);
            List<String> epList = this.splitOnComma(iepv);
            list.addAll(epList);
        }
        if (list.isEmpty()) {
            String urlValue = (String)env.get("java.naming.provider.url");
            list.addAll(rrPolicy.getEndpointForProviderURL(urlValue));
        }
        if (list.isEmpty()) {
            String host = this.getEnvSysProperty(env, "org.omg.CORBA.ORBInitialHost");
            String port = this.getEnvSysProperty(env, "org.omg.CORBA.ORBInitialPort");
            if (host != null && port != null) {
                list.addAll(rrPolicy.getAddressPortList(host, port));
                _logger.log(Level.WARNING, "no.endpoints.selected", new Object[]{host, port});
            }
        }
        if (list.isEmpty() && defaultHost != null && defaultPort != null) {
            list.add(defaultHost + ":" + defaultPort);
        }
        if (list.isEmpty()) {
            _logger.log(Level.SEVERE, "no.endpoints");
            throw new RuntimeException("Cannot Proceed. No Endpoints specified.");
        }
        return list;
    }

    private String getCorbalocURL(List<String> list) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String str : list) {
            if (first) {
                first = false;
                sb.append(CORBALOC);
            } else {
                sb.append(',');
            }
            sb.append(IIOP_URL);
            sb.append(str.trim());
        }
        SerialInitContextFactory.fineLog("corbaloc url ==> {0}", sb.toString());
        return sb.toString();
    }

    public SerialInitContextFactory() {
        Habitat temp = defaultHabitat;
        if (temp == null) {
            temp = Globals.getDefaultHabitat();
        }
        if (temp == null) {
            temp = Globals.getStaticHabitat();
        }
        this.habitat = temp;
    }

    private ORB getORB() {
        ORBLocator orbLocator;
        if (this.habitat != null && (orbLocator = (ORBLocator)this.habitat.getByContract(ORBLocator.class)) != null) {
            return orbLocator.getORB();
        }
        throw new RuntimeException("Could not get ORB");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Context getInitialContext(Hashtable env) throws NamingException {
        Object epList;
        Hashtable<String, String> myEnv = env == null ? new Hashtable<String, String>() : env;
        boolean bl = this.useLB = this.propertyIsSet(env, IIOP_ENDPOINTS_PROPERTY) || this.propertyIsSet(env, LOAD_BALANCING_PROPERTY);
        if (this.useLB && !initialized) {
            Class<SerialInitContextFactory> clazz = SerialInitContextFactory.class;
            // MONITORENTER : com.sun.enterprise.naming.impl.SerialInitContextFactory.class
            if (!initialized) {
                epList = this.getEndpointList(myEnv);
                rrPolicy = new RoundRobinPolicy((List<String>)epList);
                GroupInfoService gis = null;
                try {
                    gis = (GroupInfoService)this.getORB().resolve_initial_references("FolbClientGroupInfoService");
                }
                catch (InvalidName ex) {
                    SerialInitContextFactory.doLog(Level.SEVERE, "Exception in SerialInitContextFactory constructor {0}", new Object[]{ex});
                }
                giso = new GroupInfoServiceObserverImpl(gis, rrPolicy);
                gis.addObserver((GroupInfoServiceObserver)giso);
                SerialInitContextFactory.fineLog("getGIS: rrPolicy = {0}", rrPolicy);
                if (this.habitat != null) {
                    for (NamingObjectsProvider provider : this.habitat.getAllByContract(NamingObjectsProvider.class)) {
                    }
                }
                giso.membershipChange();
                initialized = true;
            }
            // MONITOREXIT : clazz
        }
        if (this.useLB || initialized) {
            if (!myEnv.containsKey(IIOP_URL_PROPERTY)) {
                Context ctx = SerialContext.getStickyContext();
                if (ctx != null) {
                    return ctx;
                }
                if (env.containsKey(IIOP_ENDPOINTS_PROPERTY) || env.containsKey(LOAD_BALANCING_PROPERTY)) {
                    epList = SerialInitContextFactory.class;
                    // MONITORENTER : com.sun.enterprise.naming.impl.SerialInitContextFactory.class
                    List<String> list = this.getEndpointList(myEnv);
                    rrPolicy.setClusterInstanceInfoFromString(list);
                    giso.membershipChange();
                    // MONITOREXIT : epList
                }
                List<String> rrList = rrPolicy.getNextRotation();
                SerialInitContextFactory.fineLog("getInitialContext: rrPolicy = {0}", rrPolicy);
                String corbalocURL = this.getCorbalocURL(rrList);
                myEnv.put(IIOP_URL_PROPERTY, corbalocURL);
            }
            myEnv.put("java.naming.corba.orb", (String)this.getORB());
            return this.createInitialContext(myEnv);
        }
        if (defaultHost != null) {
            myEnv.put("org.omg.CORBA.ORBInitialHost", defaultHost);
        }
        if (defaultPort == null) return this.createInitialContext(myEnv);
        myEnv.put("org.omg.CORBA.ORBInitialPort", defaultPort);
        return this.createInitialContext(myEnv);
    }

    private Context createInitialContext(Hashtable env) throws NamingException {
        SerialContext serialContext = new SerialContext(env, this.habitat);
        if (NamingManager.hasInitialContextFactoryBuilder()) {
            return new WrappedSerialContext(env, serialContext);
        }
        return serialContext;
    }

    static {
        _logger = LogDomains.getLogger(SerialInitContextFactory.class, (String)"javax.enterprise.system.core.naming");
        defaultHost = null;
        defaultPort = null;
        defaultHabitat = null;
    }
}

