/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.NamedDescriptor;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EjbAbstractDescriptor
extends Descriptor
implements NamedDescriptor {
    private String homeClassName;
    private String remoteClassName;
    private String localHomeClassName;
    private String localClassName;
    private Set<String> remoteBusinessClassNames = new HashSet<String>();
    private Set<String> localBusinessClassNames = new HashSet<String>();
    private Set<String> noInterfaceLocalBeanClassNames = new HashSet<String>();
    private String webServiceEndpointInterfaceName;
    private String jndiName = "";
    private String mappedName = "";
    private boolean localBean = false;

    public EjbAbstractDescriptor() {
    }

    protected EjbAbstractDescriptor(EjbAbstractDescriptor other) {
        super(other);
        this.homeClassName = other.homeClassName;
        this.remoteClassName = other.remoteClassName;
        this.remoteBusinessClassNames = new HashSet<String>(other.remoteBusinessClassNames);
        this.localHomeClassName = other.localHomeClassName;
        this.localClassName = other.localClassName;
        this.localBusinessClassNames = new HashSet<String>(other.localBusinessClassNames);
        this.webServiceEndpointInterfaceName = other.webServiceEndpointInterfaceName;
        this.localBean = other.localBean;
        this.jndiName = other.jndiName;
    }

    public abstract String getType();

    public abstract void setType(String var1);

    public String getHomeClassName() {
        return this.homeClassName;
    }

    public void setHomeClassName(String homeClassName) {
        this.homeClassName = homeClassName;
    }

    public void setRemoteClassName(String remoteClassName) {
        this.remoteClassName = remoteClassName;
    }

    public String getRemoteClassName() {
        return this.remoteClassName;
    }

    public void setLocalHomeClassName(String localHomeClassName) {
        this.localHomeClassName = localHomeClassName;
    }

    public String getLocalHomeClassName() {
        return this.localHomeClassName;
    }

    public void setLocalClassName(String localClassName) {
        this.localClassName = localClassName;
    }

    public String getLocalClassName() {
        return this.localClassName;
    }

    public void addNoInterfaceLocalBeanClass(String className) {
        this.noInterfaceLocalBeanClassNames.add(className);
    }

    public Set<String> getNoInterfaceLocalBeanClasses() {
        return this.noInterfaceLocalBeanClassNames;
    }

    public void addRemoteBusinessClassName(String className) {
        this.remoteBusinessClassNames.add(className);
    }

    public void addLocalBusinessClassName(String className) {
        this.localBusinessClassNames.add(className);
    }

    public Set<String> getRemoteBusinessClassNames() {
        return new HashSet<String>(this.remoteBusinessClassNames);
    }

    public Set<String> getLocalBusinessClassNames() {
        return new HashSet<String>(this.localBusinessClassNames);
    }

    public void setWebServiceEndpointInterfaceName(String name) {
        this.webServiceEndpointInterfaceName = name;
    }

    public String getWebServiceEndpointInterfaceName() {
        return this.webServiceEndpointInterfaceName;
    }

    @Override
    public String getJndiName() {
        if (this.jndiName == null) {
            this.jndiName = "";
        }
        return this.jndiName != null && this.jndiName.length() > 0 ? this.jndiName : this.getMappedName();
    }

    @Override
    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
        if (this.getName().equals("")) {
            super.setName(jndiName);
        }
    }

    public String getMappedName() {
        return this.mappedName != null ? this.mappedName : "";
    }

    public void setMappedName(String mappedName) {
        this.mappedName = mappedName;
    }

    public void setLocalBean(boolean localBean) {
        this.localBean = localBean;
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        super.print(toStringBuffer);
        toStringBuffer.append("\n homeClassName ").append(this.homeClassName);
        toStringBuffer.append("\n remoteClassName ").append(this.remoteClassName);
        toStringBuffer.append("\n remoteBusinessIntfs ").append(this.remoteBusinessClassNames).append("\n");
        toStringBuffer.append("\n localhomeClassName ").append(this.localHomeClassName);
        toStringBuffer.append("\n localClassName ").append(this.localClassName);
        toStringBuffer.append("\n localBusinessIntfs ").append(this.localBusinessClassNames);
        toStringBuffer.append("\n isLocalBean ").append(this.isLocalBean()).append("\n");
        toStringBuffer.append("\n jndiName ").append(this.jndiName).append("\n");
    }

    public boolean isLocalInterfacesSupported() {
        return this.getLocalHomeClassName() != null;
    }

    public boolean isLocalBusinessInterfacesSupported() {
        return this.localBusinessClassNames.size() > 0;
    }

    public boolean isRemoteInterfacesSupported() {
        return this.getHomeClassName() != null;
    }

    public boolean isRemoteBusinessInterfacesSupported() {
        return this.remoteBusinessClassNames.size() > 0;
    }

    public boolean hasWebServiceEndpointInterface() {
        return this.getWebServiceEndpointInterfaceName() != null;
    }

    public boolean isLocalBean() {
        return this.localBean;
    }
}

