/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.security.SecurityConfigListener;
import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.RelativePathResolver;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="create-auth-realm")
@Scoped(value=PerLookup.class)
@I18n(value="create.auth.realm")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateAuthRealm
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateAuthRealm.class);
    @Param(name="classname")
    private String className;
    @Param(name="authrealmname", primary=true)
    private String authRealmName;
    @Param(optional=true, name="property", separator=58)
    private Properties properties;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    @Inject(name="default-instance-name")
    private Config config;
    @Inject
    private Configs configs;
    @Inject
    private Domain domain;
    @Inject
    private SecurityConfigListener securityListener;
    @Inject
    private Util util;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Config tmp = null;
        try {
            tmp = this.configs.getConfigByName(this.target);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (tmp != null) {
            this.config = tmp;
        }
        if (tmp == null) {
            Cluster cluster;
            Server targetServer = this.domain.getServerNamed(this.target);
            if (targetServer != null) {
                this.config = this.domain.getConfigNamed(targetServer.getConfigRef());
            }
            if ((cluster = this.domain.getClusterNamed(this.target)) != null) {
                this.config = this.domain.getConfigNamed(cluster.getConfigRef());
            }
        }
        SecurityService securityService = this.config.getSecurityService();
        List authrealms = securityService.getAuthRealm();
        for (AuthRealm authrealm : authrealms) {
            if (!authrealm.getName().equals(this.authRealmName)) continue;
            report.setMessage(localStrings.getLocalString("create.auth.realm.duplicatefound", "Authrealm named {0} exists. Cannot add duplicate AuthRealm.", new Object[]{this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<SecurityService>(){

                public Object run(SecurityService param) throws PropertyVetoException, TransactionFailure {
                    AuthRealm newAuthRealm = (AuthRealm)param.createChild(AuthRealm.class);
                    CreateAuthRealm.this.populateAuthRealmElement(newAuthRealm);
                    param.getAuthRealm().add(newAuthRealm);
                    SecurityConfigListener.authRealmCreated(CreateAuthRealm.this.config, newAuthRealm);
                    return newAuthRealm;
                }
            }, (ConfigBeanProxy)securityService);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("create.auth.realm.fail", "Creation of Authrealm {0} failed", new Object[]{this.authRealmName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void populateAuthRealmElement(AuthRealm newAuthRealm) throws PropertyVetoException, TransactionFailure {
        newAuthRealm.setName(this.authRealmName);
        newAuthRealm.setClassname(this.className);
        if (this.properties != null) {
            for (Object propname : this.properties.keySet()) {
                Property newprop = (Property)newAuthRealm.createChild(Property.class);
                newprop.setName((String)propname);
                String propValue = this.properties.getProperty((String)propname);
                if (propValue != null && propValue.contains("$")) {
                    propValue = RelativePathResolver.resolvePath((String)propValue);
                }
                newprop.setValue(propValue);
                newAuthRealm.getProperty().add(newprop);
            }
        }
    }
}

