/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util.logging;

import com.sun.mail.util.logging.LogManagerProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Properties;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileTypeMap;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParameterList;
import javax.mail.util.ByteArrayDataSource;

public class MailHandler
extends Handler {
    private static final int offValue;
    private volatile boolean sealed;
    private boolean isWriting;
    private Properties mailProps;
    private Authenticator auth;
    private Session session;
    private LogRecord[] data;
    private int size;
    private int capacity;
    private Comparator comparator;
    private Formatter subjectFormatter;
    private Level pushLevel;
    private Filter pushFilter;
    private Filter[] attachmentFilters;
    private Formatter[] attachmentFormatters;
    private Formatter[] attachmentNames;
    private FileTypeMap contentTypes;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MailHandler() {
        this.init();
        this.sealed = true;
    }

    public MailHandler(int capacity) {
        this.init();
        this.sealed = true;
        this.setCapacity0(capacity);
    }

    public MailHandler(Properties props) {
        this.init();
        this.sealed = true;
        this.setMailProperties0(props);
    }

    public boolean isLoggable(LogRecord record) {
        int levelValue = this.getLevel().intValue();
        if (record.getLevel().intValue() < levelValue || levelValue == offValue) {
            return false;
        }
        Filter body = this.getFilter();
        if (body == null || body.isLoggable(record)) {
            return true;
        }
        return this.isAttachmentLoggable(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord record) {
        if (this.isLoggable(record)) {
            MessageContext ctx;
            boolean priority;
            record.getSourceMethodName();
            MailHandler mailHandler = this;
            synchronized (mailHandler) {
                this.data[this.size] = record;
                ++this.size;
                priority = this.isPushable(record);
                if (priority || this.size >= this.capacity) {
                    ctx = this.writeLogRecords(1);
                } else {
                    ctx = null;
                    if (this.data.length == this.size) {
                        this.grow();
                    }
                }
            }
            if (ctx != null) {
                this.send(ctx, priority, 1);
            }
        }
    }

    public void push() {
        this.push(true, 2);
    }

    public void flush() {
        this.push(false, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MessageContext ctx = null;
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            block10: {
                super.setLevel(Level.OFF);
                try {
                    if (this.size > 0) {
                        ctx = this.writeLogRecords(3);
                    }
                    Object var4_3 = null;
                    if (this.capacity <= 0) break block10;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (this.capacity > 0) {
                        this.capacity = -this.capacity;
                    }
                    if (this.size == 0 && this.data.length != 1) {
                        this.data = new LogRecord[1];
                    }
                    throw throwable;
                }
                this.capacity = -this.capacity;
            }
            if (this.size == 0 && this.data.length != 1) {
                this.data = new LogRecord[1];
            }
        }
        if (ctx != null) {
            this.send(ctx, false, 3);
        }
    }

    public synchronized void setLevel(Level newLevel) {
        if (this.capacity > 0) {
            super.setLevel(newLevel);
        } else {
            if (newLevel == null) {
                throw new NullPointerException();
            }
            this.checkAccess();
        }
    }

    public final synchronized Level getPushLevel() {
        return this.pushLevel;
    }

    public final synchronized void setPushLevel(Level level) {
        this.checkAccess();
        if (level == null) {
            throw new NullPointerException();
        }
        if (this.isWriting) {
            throw new IllegalStateException();
        }
        this.pushLevel = level;
    }

    public final synchronized Filter getPushFilter() {
        return this.pushFilter;
    }

    public final synchronized void setPushFilter(Filter filter) {
        this.checkAccess();
        if (this.isWriting) {
            throw new IllegalStateException();
        }
        this.pushFilter = filter;
    }

    public final synchronized Comparator getComparator() {
        return this.comparator;
    }

    public final synchronized void setComparator(Comparator c) {
        this.checkAccess();
        if (this.isWriting) {
            throw new IllegalStateException();
        }
        this.comparator = c;
    }

    public final synchronized int getCapacity() {
        if (!($assertionsDisabled || this.capacity != Integer.MIN_VALUE && this.capacity != 0)) {
            throw new AssertionError(this.capacity);
        }
        return Math.abs(this.capacity);
    }

    public final synchronized Authenticator getAuthenticator() {
        this.checkAccess();
        return this.auth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAuthenticator(Authenticator auth) {
        Session settings;
        this.checkAccess();
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            if (this.isWriting) {
                throw new IllegalStateException();
            }
            this.auth = auth;
            settings = this.fixUpSession();
        }
        this.verifySettings(settings);
    }

    public final void setMailProperties(Properties props) {
        this.setMailProperties0(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMailProperties0(Properties props) {
        Session settings;
        this.checkAccess();
        props = (Properties)props.clone();
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            if (this.isWriting) {
                throw new IllegalStateException();
            }
            this.mailProps = props;
            settings = this.fixUpSession();
        }
        this.verifySettings(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Properties getMailProperties() {
        Properties props;
        this.checkAccess();
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            props = this.mailProps;
        }
        return (Properties)props.clone();
    }

    public final Filter[] getAttachmentFilters() {
        return (Filter[])this.readOnlyAttachmentFilters().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAttachmentFilters(Filter[] filters) {
        this.checkAccess();
        filters = (Filter[])filters.clone();
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            if (this.attachmentFormatters.length != filters.length) {
                throw MailHandler.attachmentMismatch(this.attachmentFormatters.length, filters.length);
            }
            if (this.isWriting) {
                throw new IllegalStateException();
            }
            this.attachmentFilters = filters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Formatter[] getAttachmentFormatters() {
        Formatter[] formatters;
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            formatters = this.attachmentFormatters;
        }
        return (Formatter[])formatters.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAttachmentFormatters(Formatter[] formatters) {
        this.checkAccess();
        formatters = (Formatter[])formatters.clone();
        for (int i = 0; i < formatters.length; ++i) {
            if (formatters[i] != null) continue;
            throw new NullPointerException(MailHandler.atIndexMsg(i));
        }
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            if (this.isWriting) {
                throw new IllegalStateException();
            }
            this.attachmentFormatters = formatters;
            this.fixUpAttachmentFilters();
            this.fixUpAttachmentNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Formatter[] getAttachmentNames() {
        Formatter[] formatters;
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            formatters = this.attachmentNames;
        }
        return (Formatter[])formatters.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAttachmentNames(String[] names) {
        this.checkAccess();
        Formatter[] formatters = new Formatter[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (name != null) {
                if (name.length() <= 0) {
                    throw new IllegalArgumentException(MailHandler.atIndexMsg(i));
                }
            } else {
                throw new NullPointerException(MailHandler.atIndexMsg(i));
            }
            formatters[i] = new TailNameFormatter(name);
        }
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            if (this.attachmentFormatters.length != names.length) {
                throw MailHandler.attachmentMismatch(this.attachmentFormatters.length, names.length);
            }
            if (this.isWriting) {
                throw new IllegalStateException();
            }
            this.attachmentNames = formatters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAttachmentNames(Formatter[] formatters) {
        this.checkAccess();
        formatters = (Formatter[])formatters.clone();
        for (int i = 0; i < formatters.length; ++i) {
            if (formatters[i] != null) continue;
            throw new NullPointerException(MailHandler.atIndexMsg(i));
        }
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            if (this.attachmentFormatters.length != formatters.length) {
                throw MailHandler.attachmentMismatch(this.attachmentFormatters.length, formatters.length);
            }
            if (this.isWriting) {
                throw new IllegalStateException();
            }
            this.attachmentNames = formatters;
        }
    }

    public final synchronized Formatter getSubject() {
        return this.subjectFormatter;
    }

    public final void setSubject(String subject) {
        if (subject == null) {
            this.checkAccess();
            throw new NullPointerException();
        }
        this.setSubject(new TailNameFormatter(subject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSubject(Formatter format) {
        this.checkAccess();
        if (format == null) {
            throw new NullPointerException();
        }
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            if (this.isWriting) {
                throw new IllegalStateException();
            }
            this.subjectFormatter = format;
        }
    }

    protected void reportError(String msg, Exception ex, int code) {
        if (msg != null) {
            super.reportError(Level.SEVERE.getName() + ": " + msg, ex, code);
        } else {
            super.reportError(null, ex, code);
        }
    }

    final void checkAccess() {
        if (this.sealed) {
            LogManagerProperties.manager.checkAccess();
        }
    }

    final String contentTypeOf(String head) {
        if (head != null && head.length() > 0) {
            int MAX_CHARS = 15;
            if (head.length() > 15) {
                head = head.substring(0, 15);
            }
            try {
                String encoding = this.getEncoding();
                ByteArrayInputStream in = encoding == null ? new ByteArrayInputStream(head.getBytes()) : new ByteArrayInputStream(head.getBytes(encoding));
                if (!$assertionsDisabled && !in.markSupported()) {
                    throw new AssertionError((Object)in.getClass().getName());
                }
                return URLConnection.guessContentTypeFromStream(in);
            }
            catch (IOException IOE) {
                this.reportError(IOE.getMessage(), IOE, 5);
            }
        }
        return null;
    }

    private String getContentType(String name) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        String type = this.contentTypes.getContentType(name);
        if ("application/octet-stream".equalsIgnoreCase(type)) {
            return null;
        }
        return type;
    }

    private void setContent(MimeBodyPart part, StringBuffer buf, String type) throws MessagingException {
        String encoding = this.getEncoding();
        if (type != null && !"text/plain".equals(type)) {
            type = encoding == null ? this.contentWithDefault(type) : this.contentWithEncoding(type, encoding);
            try {
                ByteArrayDataSource source = new ByteArrayDataSource(buf.toString(), type);
                part.setDataHandler(new DataHandler((DataSource)source));
            }
            catch (IOException IOE) {
                this.reportError(IOE.getMessage(), IOE, 5);
                part.setText(buf.toString(), encoding);
            }
        } else {
            part.setText(buf.toString(), encoding);
        }
    }

    private String contentWithEncoding(String type, String encoding) {
        try {
            ContentType ct = new ContentType(type);
            ct.setParameter("charset", encoding);
            encoding = ct.toString();
            if (encoding != null) {
                type = encoding;
            }
        }
        catch (MessagingException ME) {
            this.reportError(type, ME, 5);
        }
        return type;
    }

    private String contentWithDefault(String type) {
        try {
            ContentType ct = new ContentType(type);
            if (ct.getParameter("charset") != null) {
                ParameterList list = ct.getParameterList();
                list.remove("charset");
                ct.setParameterList(list);
                String newType = ct.toString();
                if (newType != null) {
                    type = newType;
                }
            }
        }
        catch (MessagingException ME) {
            this.reportError(type, ME, 5);
        }
        return type;
    }

    private synchronized void setCapacity0(int newCapacity) {
        if (newCapacity <= 0) {
            throw new IllegalArgumentException("Capacity must be greater than zero.");
        }
        if (this.isWriting) {
            throw new IllegalStateException();
        }
        this.capacity = this.capacity < 0 ? -newCapacity : newCapacity;
    }

    private synchronized Filter[] readOnlyAttachmentFilters() {
        return this.attachmentFilters;
    }

    private void fixUpAttachmentFormatters() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        int attachments = this.attachmentFormatters.length;
        for (int i = 0; i < attachments; ++i) {
            if (this.attachmentFormatters[i] == null) {
                NullPointerException NPE = new NullPointerException(MailHandler.atIndexMsg(i));
                this.attachmentFormatters[i] = new SimpleFormatter();
                this.reportError("attachment formatter.", NPE, 4);
                continue;
            }
            if (!(this.attachmentFormatters[i] instanceof TailNameFormatter)) continue;
            ClassNotFoundException CNFE = new ClassNotFoundException(this.attachmentFormatters[i].toString());
            this.attachmentFormatters[i] = new SimpleFormatter();
            this.reportError("attachment formatter.", CNFE, 4);
        }
    }

    private boolean fixUpAttachmentNames() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        boolean fixed = false;
        int current = this.attachmentNames.length;
        int expect = this.attachmentFormatters.length;
        if (current != expect) {
            this.attachmentNames = (Formatter[])MailHandler.copyOf(this.attachmentNames, expect);
            fixed = current != 0;
        }
        for (int i = 0; i < expect; ++i) {
            if (this.attachmentNames[i] != null) continue;
            this.attachmentNames[i] = new TailNameFormatter(this.toString(this.attachmentFormatters[i]));
        }
        return fixed;
    }

    private boolean fixUpAttachmentFilters() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        int current = this.attachmentFilters.length;
        int expect = this.attachmentFormatters.length;
        if (current != expect) {
            this.attachmentFilters = (Filter[])MailHandler.copyOf(this.attachmentFilters, expect);
            return current != 0;
        }
        return false;
    }

    private static Object[] copyOf(Object[] a, int size) {
        Object[] copy = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        System.arraycopy(a, 0, copy, 0, Math.min(a.length, size));
        return copy;
    }

    private void reset() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        Arrays.fill(this.data, 0, this.size, null);
        this.size = 0;
    }

    private void grow() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        int len = this.data.length;
        int newCapacity = len + (len >> 1) + 1;
        if (newCapacity > this.capacity || newCapacity < len) {
            newCapacity = this.capacity;
        }
        if (!$assertionsDisabled && len == this.capacity) {
            throw new AssertionError(len);
        }
        this.data = (LogRecord[])MailHandler.copyOf(this.data, newCapacity);
    }

    private synchronized void init() {
        LogManager manager = LogManagerProperties.manager;
        String p = this.getClass().getName();
        this.mailProps = new Properties();
        this.contentTypes = FileTypeMap.getDefaultFileTypeMap();
        ErrorManager em = (ErrorManager)this.initObject(p.concat(".errorManager"), ErrorManager.class);
        if (em != null) {
            this.setErrorManager(em);
        }
        this.initLevel(manager, p);
        this.initFilter(p);
        this.initCapacity(manager, p);
        this.auth = (Authenticator)this.initObject(p.concat(".authenticator"), Authenticator.class);
        Session settings = this.fixUpSession();
        this.initEncoding(manager, p);
        this.initFormatter(p);
        this.initComparator(p);
        this.initPushLevel(manager, p);
        this.pushFilter = (Filter)this.initObject(p.concat(".pushFilter"), Filter.class);
        this.initSubject(p);
        this.attachmentFormatters = (Formatter[])this.initArray(p.concat(".attachment.formatters"), Formatter.class);
        this.attachmentFilters = (Filter[])this.initArray(p.concat(".attachment.filters"), Filter.class);
        this.attachmentNames = (Formatter[])this.initArray(p.concat(".attachment.names"), Formatter.class);
        this.fixUpAttachmentFormatters();
        if (this.fixUpAttachmentFilters()) {
            this.reportError("attachment filters.", MailHandler.attachmentMismatch("length mismatch"), 4);
        }
        if (this.fixUpAttachmentNames()) {
            this.reportError("attachment names.", MailHandler.attachmentMismatch("length mismatch"), 4);
        }
        this.verifySettings(settings);
    }

    private Object objectFromNew(String name, Class type) throws NoSuchMethodException {
        Object obj = null;
        try {
            try {
                try {
                    Class clazz = LogManagerProperties.findClass(name);
                    if (type.isAssignableFrom(clazz)) {
                        return clazz.getConstructor(null).newInstance(null);
                    }
                    throw new ClassCastException(clazz.getName() + " cannot be cast to " + type.getName());
                }
                catch (NoClassDefFoundError NCDFE) {
                    throw (ClassNotFoundException)new ClassNotFoundException(NCDFE.getMessage()).initCause(NCDFE);
                }
            }
            catch (ClassNotFoundException CNFE) {
                if (type == Formatter.class) {
                    return new TailNameFormatter(name);
                }
                throw CNFE;
            }
            catch (ClassCastException CCE) {
                if (type == Formatter.class) {
                    return new TailNameFormatter(name);
                }
                throw CCE;
            }
        }
        catch (NoSuchMethodException NSME) {
            throw NSME;
        }
        catch (Exception E) {
            this.reportError(E.getMessage(), E, 4);
            return obj;
        }
    }

    private Object initObject(String key, Class type) {
        String name = LogManagerProperties.manager.getProperty(key);
        if (name != null && name.length() > 0 && !"null".equalsIgnoreCase(name)) {
            try {
                return this.objectFromNew(name, type);
            }
            catch (NoSuchMethodException E) {
                this.reportError(E.getMessage(), E, 4);
            }
        }
        return null;
    }

    private Object[] initArray(String key, Class type) {
        String list = LogManagerProperties.manager.getProperty(key);
        if (list != null && list.length() > 0) {
            String[] names = list.split(",");
            Object[] a = (Object[])Array.newInstance(type, names.length);
            for (int i = 0; i < a.length; ++i) {
                names[i] = names[i].trim();
                if ("null".equalsIgnoreCase(names[i])) continue;
                try {
                    a[i] = this.objectFromNew(names[i], type);
                    continue;
                }
                catch (NoSuchMethodException E) {
                    this.reportError(E.getMessage(), E, 4);
                }
            }
            return a;
        }
        return (Object[])Array.newInstance(type, 0);
    }

    private void initLevel(LogManager manager, String p) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        try {
            String val = manager.getProperty(p.concat(".level"));
            if (val != null) {
                super.setLevel(Level.parse(val));
            } else {
                super.setLevel(Level.WARNING);
            }
        }
        catch (SecurityException SE) {
            throw SE;
        }
        catch (RuntimeException RE) {
            this.reportError(RE.getMessage(), RE, 4);
            try {
                super.setLevel(Level.WARNING);
            }
            catch (RuntimeException fail) {
                this.reportError(fail.getMessage(), fail, 4);
            }
        }
    }

    private void initFilter(String p) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        try {
            super.setFilter((Filter)this.initObject(p.concat(".filter"), Filter.class));
        }
        catch (SecurityException SE) {
            throw SE;
        }
        catch (RuntimeException RE) {
            this.reportError(RE.getMessage(), RE, 4);
        }
    }

    private void initCapacity(LogManager manager, String p) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        int DEFAULT_CAPACITY = 1000;
        try {
            String value = manager.getProperty(p.concat(".capacity"));
            if (value != null) {
                this.setCapacity0(Integer.parseInt(value));
            } else {
                this.setCapacity0(1000);
            }
        }
        catch (RuntimeException RE) {
            this.reportError(RE.getMessage(), RE, 4);
        }
        if (this.capacity <= 0) {
            this.capacity = 1000;
        }
        this.data = new LogRecord[1];
    }

    private void initEncoding(LogManager manager, String p) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        try {
            super.setEncoding(manager.getProperty(p.concat(".encoding")));
        }
        catch (SecurityException SE) {
            throw SE;
        }
        catch (UnsupportedEncodingException UEE) {
            this.reportError(UEE.getMessage(), UEE, 4);
        }
        catch (RuntimeException RE) {
            this.reportError(RE.getMessage(), RE, 4);
        }
    }

    private void initFormatter(String p) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        try {
            Formatter formatter = (Formatter)this.initObject(p.concat(".formatter"), Formatter.class);
            if (formatter != null && !(formatter instanceof TailNameFormatter)) {
                super.setFormatter(formatter);
            } else {
                super.setFormatter(new SimpleFormatter());
            }
        }
        catch (SecurityException SE) {
            throw SE;
        }
        catch (RuntimeException RE) {
            this.reportError(RE.getMessage(), RE, 4);
            try {
                super.setFormatter(new SimpleFormatter());
            }
            catch (RuntimeException fail) {
                this.reportError(fail.getMessage(), fail, 4);
            }
        }
    }

    private void initComparator(String p) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        try {
            this.comparator = (Comparator)this.initObject(p.concat(".comparator"), Comparator.class);
        }
        catch (Exception RE) {
            this.reportError(RE.getMessage(), RE, 4);
        }
    }

    private void initPushLevel(LogManager manager, String p) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        try {
            String val = manager.getProperty(p.concat(".pushLevel"));
            if (val != null) {
                this.pushLevel = Level.parse(val);
            }
        }
        catch (RuntimeException RE) {
            this.reportError(RE.getMessage(), RE, 4);
        }
        if (this.pushLevel == null) {
            this.pushLevel = Level.OFF;
        }
    }

    private void initSubject(String p) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        this.subjectFormatter = (Formatter)this.initObject(p.concat(".subject"), Formatter.class);
        if (this.subjectFormatter == null) {
            this.subjectFormatter = new TailNameFormatter("");
        }
    }

    private boolean isAttachmentLoggable(LogRecord record) {
        Filter[] filters = this.readOnlyAttachmentFilters();
        for (int i = 0; i < filters.length; ++i) {
            Filter f = filters[i];
            if (f != null && !f.isLoggable(record)) continue;
            return true;
        }
        return false;
    }

    private boolean isPushable(LogRecord record) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        int value = this.getPushLevel().intValue();
        if (value == offValue || record.getLevel().intValue() < value) {
            return false;
        }
        Filter filter = this.getPushFilter();
        return filter == null || filter.isLoggable(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(boolean priority, int code) {
        MessageContext ctx = null;
        MailHandler mailHandler = this;
        synchronized (mailHandler) {
            if (this.size > 0) {
                ctx = this.writeLogRecords(code);
            }
        }
        if (ctx != null) {
            this.send(ctx, priority, code);
        }
    }

    private void send(MessageContext ctx, boolean priority, int code) {
        Message msg = ctx.getMessage();
        try {
            this.envelopeFor(ctx, priority);
            Transport.send(msg);
        }
        catch (Exception E) {
            try {
                super.reportError(this.toRawString(msg), E, code);
            }
            catch (MessagingException rawMe) {
                this.reportError(this.toMsgString(rawMe), E, code);
            }
            catch (IOException rawIo) {
                this.reportError(this.toMsgString(rawIo), E, code);
            }
        }
    }

    private void sort() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.comparator != null) {
            try {
                Arrays.sort(this.data, 0, this.size, this.comparator);
            }
            catch (RuntimeException RE) {
                this.reportError(RE.getMessage(), RE, 5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized MessageContext writeLogRecords(int code) {
        if (!$assertionsDisabled && this.size <= 0) {
            throw new AssertionError();
        }
        if (this.isWriting) {
            return null;
        }
        this.isWriting = true;
        try {
            MessageContext messageContext;
            try {
                MimeMessage msg = new MimeMessage(this.session);
                this.sort();
                MimeBodyPart[] parts = new MimeBodyPart[this.attachmentFormatters.length];
                StringBuffer[] buffers = new StringBuffer[parts.length];
                String contentType = null;
                StringBuffer buf = null;
                this.appendSubject(msg, this.head(this.subjectFormatter));
                Formatter bodyFormat = this.getFormatter();
                Filter bodyFilter = this.getFilter();
                for (int ix = 0; ix < this.size; ++ix) {
                    LogRecord r = this.data[ix];
                    this.data[ix] = null;
                    this.appendSubject(msg, this.format(this.subjectFormatter, r));
                    if (bodyFilter == null || bodyFilter.isLoggable(r)) {
                        if (buf == null) {
                            buf = new StringBuffer();
                            String head = this.head(bodyFormat);
                            buf.append(head);
                            contentType = this.contentTypeOf(head);
                        }
                        buf.append(this.format(bodyFormat, r));
                    }
                    for (int i = 0; i < parts.length; ++i) {
                        Filter af = this.attachmentFilters[i];
                        if (af != null && !af.isLoggable(r)) continue;
                        if (parts[i] == null) {
                            parts[i] = this.createBodyPart(i);
                            buffers[i] = new StringBuffer();
                            buffers[i].append(this.head(this.attachmentFormatters[i]));
                            this.appendFileName(parts[i], this.head(this.attachmentNames[i]));
                        }
                        this.appendFileName(parts[i], this.format(this.attachmentNames[i], r));
                        buffers[i].append(this.format(this.attachmentFormatters[i], r));
                    }
                }
                this.size = 0;
                for (int i = parts.length - 1; i >= 0; --i) {
                    if (parts[i] == null) continue;
                    this.appendFileName(parts[i], this.tail(this.attachmentNames[i], "err"));
                    buffers[i].append(this.tail(this.attachmentFormatters[i], ""));
                    if (buffers[i].length() > 0) {
                        String name = parts[i].getFileName();
                        if (name == null || name.length() == 0) {
                            name = this.toString(this.attachmentFormatters[i]);
                            parts[i].setFileName(name);
                        }
                        this.setContent(parts[i], buffers[i], this.getContentType(name));
                    } else {
                        parts[i] = null;
                    }
                    buffers[i] = null;
                }
                if (buf != null) {
                    buf.append(this.tail(bodyFormat, ""));
                } else {
                    buf = new StringBuffer(0);
                }
                this.appendSubject(msg, this.tail(this.subjectFormatter, ""));
                MimeMultipart multipart = new MimeMultipart();
                MimeBodyPart body = this.createBodyPart();
                String altType = this.getContentType(bodyFormat.getClass().getName());
                this.setContent(body, buf, altType == null ? contentType : altType);
                buf = null;
                multipart.addBodyPart(body);
                for (int i = 0; i < parts.length; ++i) {
                    if (parts[i] == null) continue;
                    multipart.addBodyPart(parts[i]);
                }
                parts = null;
                msg.setContent(multipart);
                messageContext = new MessageContext(msg);
                Object var14_20 = null;
                this.isWriting = false;
                if (this.size <= 0) return messageContext;
            }
            catch (RuntimeException re) {
                this.reportError(re.getMessage(), re, code);
                Object var14_21 = null;
                this.isWriting = false;
                if (this.size <= 0) return null;
                this.reset();
                return null;
            }
            catch (Exception e) {
                this.reportError(e.getMessage(), e, code);
                Object var14_22 = null;
                this.isWriting = false;
                if (this.size <= 0) return null;
                this.reset();
                return null;
            }
            this.reset();
            return messageContext;
        }
        catch (Throwable throwable) {
            Object var14_23 = null;
            this.isWriting = false;
            if (this.size <= 0) throw throwable;
            this.reset();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySettings(Session session) {
        String value;
        Properties props;
        String key = "verify";
        Properties properties = props = session.getProperties();
        synchronized (properties) {
            value = (String)props.get(key);
            if (value != null) {
                return;
            }
            value = props.getProperty(key);
            props.put(key, "");
        }
        if (value != null && value.length() > 0 && !value.equals("null")) {
            this.verifySettings0(session, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void verifySettings0(Session session, String verify) {
        if (!$assertionsDisabled && verify == null) {
            throw new AssertionError((Object)null);
        }
        if (!"local".equals(verify) && !"remote".equals(verify)) {
            this.reportError("Verify must be 'local' or 'remote'.", new IllegalArgumentException(verify), 4);
            return;
        }
        MimeMessage abort = new MimeMessage(session);
        this.envelopeFor(new MessageContext(abort), true);
        String msg = InternetAddress.getLocalAddress(session) == null ? "Local address is null." : "";
        try {
            int i;
            Address[] all;
            block23: {
                Transport t;
                all = abort.getAllRecipients();
                try {
                    if (all == null || all.length <= 0) {
                        MessagingException me = new MessagingException("No recipient addresses.");
                        this.reportError(msg, me, 4);
                        throw me;
                    }
                    t = session.getTransport(all[0]);
                    session.getProperty("mail.transport.protocol");
                }
                catch (MessagingException protocol) {
                    try {
                        t = session.getTransport();
                    }
                    catch (MessagingException fail) {
                        fail.setNextException(protocol);
                        throw fail;
                    }
                }
                if ("remote".equals(verify)) {
                    t.connect();
                    try {
                        Object var10_15;
                        try {
                            t.sendMessage(abort, all);
                            this.reportError(msg, new MessagingException("An empty message was sent."), 1);
                        }
                        catch (MessagingException expectNoContent) {
                            var10_15 = null;
                            t.close();
                            break block23;
                        }
                        var10_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_16 = null;
                        t.close();
                        throw throwable;
                    }
                    t.close();
                } else {
                    String protocol = t.getURLName().getProtocol();
                    session.getProperty("mail.host");
                    session.getProperty("mail.user");
                    session.getProperty("mail." + protocol + ".host");
                    session.getProperty("mail." + protocol + ".port");
                    session.getProperty("mail." + protocol + ".user");
                }
            }
            Address[] from = abort.getFrom();
            Address sender = abort.getSender();
            if (abort.getHeader("From", ",") != null) {
                if (!$assertionsDisabled && from == null) {
                    throw new AssertionError();
                }
                for (i = 0; i < from.length; ++i) {
                    if (!from[i].equals(sender)) continue;
                    this.reportError(msg, new MessagingException("Sender address equals from address."), 4);
                    break;
                }
            }
            if (all != null) {
                for (i = 0; i < all.length; ++i) {
                    Address a = all[i];
                    if (!(a instanceof InternetAddress)) continue;
                    ((InternetAddress)a).validate();
                }
            }
            if (!"local".equals(verify)) return;
            try {
                if (InetAddress.getLocalHost().getHostName().length() != 0) return;
                throw new UnknownHostException();
            }
            catch (IOException IOE) {
                this.reportError(msg, IOE, 4);
                return;
            }
        }
        catch (MessagingException ME) {
            this.reportError(msg, ME, 4);
            return;
        }
        catch (RuntimeException RE) {
            this.reportError(msg, RE, 4);
        }
    }

    private Session fixUpSession() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        String p = this.getClass().getName();
        LogManagerProperties proxy = new LogManagerProperties(this.mailProps, p);
        this.session = Session.getInstance(proxy, this.auth);
        return this.session;
    }

    private void envelopeFor(MessageContext ctx, boolean priority) {
        Message msg = ctx.getMessage();
        Properties proxyProps = ctx.getSession().getProperties();
        this.setFrom(msg, proxyProps);
        this.setRecipient(msg, proxyProps, "mail.to", Message.RecipientType.TO);
        this.setRecipient(msg, proxyProps, "mail.cc", Message.RecipientType.CC);
        this.setRecipient(msg, proxyProps, "mail.bcc", Message.RecipientType.BCC);
        this.setReplyTo(msg, proxyProps);
        this.setSender(msg, proxyProps);
        this.setMailer(msg);
        this.setPriority(msg, priority);
        try {
            msg.setSentDate(new Date());
            msg.saveChanges();
        }
        catch (MessagingException ME) {
            this.reportError(ME.getMessage(), ME, 5);
        }
    }

    private MimeBodyPart createBodyPart() throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        part.setDisposition("inline");
        part.setDescription(this.descriptionFrom(this.getFormatter(), this.getFilter()));
        return part;
    }

    private MimeBodyPart createBodyPart(int index) throws MessagingException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        MimeBodyPart part = new MimeBodyPart();
        part.setDisposition("attachment");
        part.setDescription(this.descriptionFrom(this.attachmentFormatters[index], this.attachmentFilters[index]));
        return part;
    }

    private String descriptionFrom(Formatter formatter, Filter filter) {
        return "Formatted using " + formatter.getClass().getName() + " and filtered with " + (filter == null ? "no filter" : filter.getClass().getName()) + '.';
    }

    private String toString(Formatter f) {
        String name = f.toString();
        if (name != null && name.length() > 0) {
            return name;
        }
        return f.getClass().getName();
    }

    private void appendFileName(Part part, String chunk) {
        if (chunk != null) {
            if (chunk.length() > 0) {
                this.appendFileName0(part, chunk);
            }
        } else {
            this.reportNullError(5);
        }
    }

    private void appendFileName0(Part part, String chunk) {
        try {
            String old = part.getFileName();
            part.setFileName(old != null ? old.concat(chunk) : chunk);
        }
        catch (MessagingException ME) {
            this.reportError(ME.getMessage(), ME, 5);
        }
    }

    private void appendSubject(Message msg, String chunk) {
        if (chunk != null) {
            if (chunk.length() > 0) {
                this.appendSubject0(msg, chunk);
            }
        } else {
            this.reportNullError(5);
        }
    }

    private void appendSubject0(Message msg, String chunk) {
        try {
            String old = msg.getSubject();
            if (!$assertionsDisabled && !(msg instanceof MimeMessage)) {
                throw new AssertionError();
            }
            ((MimeMessage)msg).setSubject(old != null ? old.concat(chunk) : chunk, this.getEncoding());
        }
        catch (MessagingException ME) {
            this.reportError(ME.getMessage(), ME, 5);
        }
    }

    private void reportNullError(int code) {
        this.reportError("null", new NullPointerException(), code);
    }

    private String head(Formatter f) {
        try {
            return f.getHead(this);
        }
        catch (RuntimeException RE) {
            this.reportError(RE.getMessage(), RE, 5);
            return "";
        }
    }

    private String format(Formatter f, LogRecord r) {
        try {
            return f.format(r);
        }
        catch (RuntimeException RE) {
            this.reportError(RE.getMessage(), RE, 5);
            return "";
        }
    }

    private String tail(Formatter f, String def) {
        try {
            return f.getTail(this);
        }
        catch (RuntimeException RE) {
            this.reportError(RE.getMessage(), RE, 5);
            return def;
        }
    }

    private void setMailer(Message msg) {
        try {
            Class mail = MailHandler.class;
            Class<?> k = this.getClass();
            String value = k == mail ? mail.getName() : mail.getName() + " using the " + k.getName() + " extension.";
            msg.setHeader("X-Mailer", value);
        }
        catch (MessagingException ME) {
            this.reportError(ME.getMessage(), ME, 5);
        }
    }

    private void setPriority(Message msg, boolean priority) {
        if (priority) {
            try {
                msg.setHeader("Importance", "High");
                msg.setHeader("Priority", "urgent");
                msg.setHeader("X-Priority", "2");
            }
            catch (MessagingException ME) {
                this.reportError(ME.getMessage(), ME, 5);
            }
        }
    }

    private void setFrom(Message msg, Properties props) {
        block6: {
            String from = props.getProperty("mail.from");
            if (from != null && from.length() > 0) {
                try {
                    Address[] address = InternetAddress.parse(from, false);
                    if (address == null || address.length == 0) {
                        this.setDefaultFrom(msg);
                        break block6;
                    }
                    if (address.length == 1) {
                        msg.setFrom(address[0]);
                        break block6;
                    }
                    msg.addFrom(address);
                }
                catch (MessagingException ME) {
                    this.reportError(ME.getMessage(), ME, 5);
                    this.setDefaultFrom(msg);
                }
            } else {
                this.setDefaultFrom(msg);
            }
        }
    }

    private void setDefaultFrom(Message msg) {
        try {
            msg.setFrom();
        }
        catch (MessagingException ME) {
            this.reportError(ME.getMessage(), ME, 5);
        }
    }

    private void setReplyTo(Message msg, Properties props) {
        String reply = props.getProperty("mail.reply.to");
        if (reply != null && reply.length() > 0) {
            try {
                Address[] address = InternetAddress.parse(reply, false);
                if (address != null && address.length > 0) {
                    msg.setReplyTo(address);
                }
            }
            catch (MessagingException ME) {
                this.reportError(ME.getMessage(), ME, 5);
            }
        }
    }

    private void setSender(Message msg, Properties props) {
        if (!$assertionsDisabled && !(msg instanceof MimeMessage)) {
            throw new AssertionError(msg);
        }
        String sender = props.getProperty("mail.sender");
        if (sender != null && sender.length() > 0) {
            try {
                Address[] address = InternetAddress.parse(sender, false);
                if (address != null && address.length > 0) {
                    ((MimeMessage)msg).setSender(address[0]);
                    if (address.length > 1) {
                        this.reportError("Ignoring other senders.", MailHandler.tooManyAddresses(address, 1), 5);
                    }
                }
            }
            catch (MessagingException ME) {
                this.reportError(ME.getMessage(), ME, 5);
            }
        }
    }

    private static AddressException tooManyAddresses(Address[] address, int offset) {
        String msg = Arrays.asList(address).subList(offset, address.length).toString();
        return new AddressException(msg);
    }

    private void setRecipient(Message msg, Properties props, String key, Message.RecipientType type) {
        String value = props.getProperty(key);
        if (value != null && value.length() > 0) {
            try {
                Address[] address = InternetAddress.parse(value, false);
                if (address != null && address.length > 0) {
                    msg.setRecipients(type, address);
                }
            }
            catch (MessagingException ME) {
                this.reportError(ME.getMessage(), ME, 5);
            }
        }
    }

    private String toRawString(Message msg) throws MessagingException, IOException {
        if (msg != null) {
            int nbytes = Math.max(msg.getSize() + 1024, 1024);
            ByteArrayOutputStream out = new ByteArrayOutputStream(nbytes);
            msg.writeTo(out);
            return out.toString("US-ASCII");
        }
        return null;
    }

    private String toMsgString(Throwable t) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        PrintStream ps = new PrintStream(out);
        ps.println(t.getMessage());
        t.printStackTrace(ps);
        ps.flush();
        return out.toString();
    }

    private static RuntimeException attachmentMismatch(String msg) {
        return new IndexOutOfBoundsException(msg);
    }

    private static RuntimeException attachmentMismatch(int expected, int found) {
        return MailHandler.attachmentMismatch("Attachments mismatched, expected " + expected + " but given " + found + '.');
    }

    private static String atIndexMsg(int i) {
        return "At index: " + i + '.';
    }

    static {
        $assertionsDisabled = !MailHandler.class.desiredAssertionStatus();
        offValue = Level.OFF.intValue();
    }

    private static final class TailNameFormatter
    extends Formatter {
        private final String name;
        static final /* synthetic */ boolean $assertionsDisabled;

        TailNameFormatter(String name) {
            if (!$assertionsDisabled && name == null) {
                throw new AssertionError();
            }
            this.name = name;
        }

        public final String format(LogRecord record) {
            return "";
        }

        public final String getTail(Handler h) {
            return this.name;
        }

        public final boolean equals(Object o) {
            if (o instanceof TailNameFormatter) {
                return this.name.equals(((TailNameFormatter)o).name);
            }
            return false;
        }

        public final int hashCode() {
            return this.getClass().hashCode() + this.name.hashCode();
        }

        public final String toString() {
            return this.name;
        }

        static {
            $assertionsDisabled = !(class$com$sun$mail$util$logging$MailHandler == null ? (class$com$sun$mail$util$logging$MailHandler = MailHandler.class$("com.sun.mail.util.logging.MailHandler")) : class$com$sun$mail$util$logging$MailHandler).desiredAssertionStatus();
        }
    }
}

