/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.annotation.context.AppClientContext;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Level;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceProperty;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class EntityManagerReferenceHandler
extends AbstractResourceHandler {
    public Class<? extends Annotation> getAnnotationType() {
        return PersistenceContext.class;
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        AnnotatedElementHandler aeHandler = ainfo.getProcessingContext().getHandler();
        if (aeHandler instanceof AppClientContext) {
            String msg = localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidaehandler", "Invalid annotation symbol found for this type of class.");
            this.log(Level.WARNING, ainfo, msg);
            return this.getDefaultProcessedResult();
        }
        PersistenceContext emRefAn = (PersistenceContext)ainfo.getAnnotation();
        return this.processEmRef(ainfo, rcContexts, emRefAn);
    }

    protected HandlerProcessingResult processEmRef(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts, PersistenceContext emRefAn) throws AnnotationProcessorException {
        block7: {
            EntityManagerReferenceDescriptor[] emRefs;
            block8: {
                block6: {
                    emRefs = null;
                    if (!ElementType.FIELD.equals((Object)ainfo.getElementType())) break block6;
                    Field f = (Field)ainfo.getAnnotatedElement();
                    String targetClassName = f.getDeclaringClass().getName();
                    String logicalName = emRefAn.name();
                    if (logicalName.equals("")) {
                        logicalName = targetClassName + "/" + f.getName();
                    }
                    emRefs = this.getEmReferenceDescriptors(logicalName, rcContexts);
                    InjectionTarget target = new InjectionTarget();
                    target.setFieldName(f.getName());
                    target.setClassName(targetClassName);
                    target.setMetadataSource(MetadataSource.ANNOTATION);
                    for (EntityManagerReferenceDescriptor emRef : emRefs) {
                        emRef.addInjectionTarget(target);
                        if (emRef.getName().length() != 0) continue;
                        this.processNewEmRefAnnotation(emRef, logicalName, emRefAn);
                    }
                    break block7;
                }
                if (!ElementType.METHOD.equals((Object)ainfo.getElementType())) break block8;
                Method m = (Method)ainfo.getAnnotatedElement();
                String targetClassName = m.getDeclaringClass().getName();
                String logicalName = emRefAn.name();
                if (logicalName.equals("")) {
                    String propertyName = this.getInjectionMethodPropertyName(m, ainfo);
                    logicalName = targetClassName + "/" + propertyName;
                }
                this.validateInjectionMethod(m, ainfo);
                emRefs = this.getEmReferenceDescriptors(logicalName, rcContexts);
                InjectionTarget target = new InjectionTarget();
                target.setMethodName(m.getName());
                target.setClassName(targetClassName);
                target.setMetadataSource(MetadataSource.ANNOTATION);
                for (EntityManagerReferenceDescriptor emRef : emRefs) {
                    emRef.addInjectionTarget(target);
                    if (emRef.getName().length() != 0) continue;
                    this.processNewEmRefAnnotation(emRef, logicalName, emRefAn);
                }
                break block7;
            }
            if (!ElementType.TYPE.equals((Object)ainfo.getElementType())) break block7;
            String logicalName = emRefAn.name();
            if ("".equals(logicalName)) {
                this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.nonametypelevel", "TYPE-Level annotation symbol on class must specify name."));
                return this.getDefaultFailedResult();
            }
            for (EntityManagerReferenceDescriptor emRef : emRefs = this.getEmReferenceDescriptors(logicalName, rcContexts)) {
                if (emRef.getName().length() != 0) continue;
                this.processNewEmRefAnnotation(emRef, logicalName, emRefAn);
            }
        }
        return this.getDefaultProcessedResult();
    }

    private EntityManagerReferenceDescriptor[] getEmReferenceDescriptors(String logicalName, ResourceContainerContext[] rcContexts) {
        EntityManagerReferenceDescriptor[] emRefs = new EntityManagerReferenceDescriptor[rcContexts.length];
        for (int i = 0; i < rcContexts.length; ++i) {
            EntityManagerReferenceDescriptor emRef = rcContexts[i].getEntityManagerReference(logicalName);
            if (emRef == null) {
                emRef = new EntityManagerReferenceDescriptor();
                rcContexts[i].addEntityManagerReferenceDescriptor(emRef);
            }
            emRefs[i] = emRef;
        }
        return emRefs;
    }

    private void processNewEmRefAnnotation(EntityManagerReferenceDescriptor emRef, String logicalName, PersistenceContext annotation) {
        emRef.setName(logicalName);
        if (!annotation.unitName().equals("")) {
            emRef.setUnitName(annotation.unitName());
        }
        emRef.setPersistenceContextType(annotation.type());
        Map<String, String> existingProperties = emRef.getProperties();
        for (PersistenceProperty next : annotation.properties()) {
            if (existingProperties.containsKey(next.name())) continue;
            emRef.addProperty(next.name(), next.value());
        }
    }
}

