/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime;

import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.DefaultResourcePrincipalNode;
import com.sun.enterprise.deployment.types.ResourceReferenceContainer;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Node;

public class ResourceRefNode
extends DeploymentDescriptorNode {
    ResourceReferenceDescriptor descriptor = null;

    public ResourceRefNode() {
        this.registerElementHandler(new XMLElement("default-resource-principal"), DefaultResourcePrincipalNode.class, "setResourcePrincipal");
    }

    public Object getDescriptor() {
        return this.descriptor;
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("jndi-name", "setJndiName");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("res-ref-name".equals(element.getQName())) {
            Object parentDesc = this.getParentNode().getDescriptor();
            if (parentDesc instanceof ResourceReferenceContainer) {
                try {
                    this.descriptor = ((ResourceReferenceContainer)parentDesc).getResourceReferenceByName(value);
                    DOLUtils.getDefaultLogger().fine("Applying res-ref " + value + " runtime settings to " + this.descriptor);
                }
                catch (IllegalArgumentException iae) {
                    DOLUtils.getDefaultLogger().warning(iae.getMessage());
                }
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    public void addDescriptor(Object newDescriptor) {
        if (this.descriptor == null) {
            DOLUtils.getDefaultLogger().log(Level.WARNING, "enterprise.deployment.backend.addDescriptorFailure", new Object[]{newDescriptor, this});
            return;
        }
        if (newDescriptor instanceof ResourcePrincipal) {
            this.descriptor.setResourcePrincipal((ResourcePrincipal)((Object)newDescriptor));
        } else if (newDescriptor instanceof MailConfiguration) {
            this.descriptor.setMailConfiguration((MailConfiguration)newDescriptor);
        } else {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.addDescriptorFailure", new Object[]{"In " + this + " do not know what to do with " + newDescriptor});
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, ResourceReferenceDescriptor rrDescriptor) {
        Node rrNode = super.writeDescriptor(parent, nodeName, this.descriptor);
        ResourceRefNode.appendTextChild(rrNode, "res-ref-name", rrDescriptor.getName());
        ResourceRefNode.appendTextChild(rrNode, "jndi-name", rrDescriptor.getJndiName());
        if (rrDescriptor.getResourcePrincipal() != null) {
            DefaultResourcePrincipalNode drpNode = new DefaultResourcePrincipalNode();
            drpNode.writeDescriptor(rrNode, "default-resource-principal", rrDescriptor.getResourcePrincipal());
        }
        return rrNode;
    }

    public static void writeResourceReferences(Node parent, ResourceReferenceContainer descriptor) {
        Iterator rrs = descriptor.getResourceReferenceDescriptors().iterator();
        if (rrs.hasNext()) {
            ResourceRefNode rrNode = new ResourceRefNode();
            while (rrs.hasNext()) {
                rrNode.writeDescriptor(parent, "resource-ref", (ResourceReferenceDescriptor)rrs.next());
            }
        }
    }
}

