/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.security.CertificateDialog;
import com.sun.enterprise.security.LoginDialog;
import com.sun.enterprise.security.PassphraseDialog;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.swing.JFrame;

public final class GUILoginDialog
implements LoginDialog {
    private static final Logger _logger = LogDomains.getLogger(GUILoginDialog.class, (String)"javax.enterprise.system.core.security");
    private String entity;
    private PassphraseDialog passphraseDialog;
    private CertificateDialog certDialog;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(GUILoginDialog.class);

    public GUILoginDialog() {
        this(localStrings.getLocalString("enterprise.security.defaultEntity", "user"));
    }

    public GUILoginDialog(String entity) {
        this.entity = entity;
        JFrame f = new JFrame();
        String phrase = localStrings.getLocalString("enterprise.security.loginPhrase", "Login for ");
        this.passphraseDialog = new PassphraseDialog(f, phrase + entity + ":");
        this.passphraseDialog.setVisible(true);
    }

    public GUILoginDialog(String entity, Callback[] callbacks) {
        this.entity = entity;
        String phrase = localStrings.getLocalString("enterprise.security.loginPhrase", "Login for ");
        JFrame f = new JFrame();
        this.passphraseDialog = new PassphraseDialog(f, phrase + entity + ":", callbacks);
        this.passphraseDialog.setVisible(true);
    }

    public String getUserName() {
        return this.passphraseDialog.username;
    }

    public final char[] getPassword() {
        char[] temp = this.passphraseDialog.passphrase;
        return temp == null ? null : Arrays.copyOf(temp, temp.length);
    }
}

