/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.apf.impl;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessor;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.ComponentInfo;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ProcessingContext;
import org.glassfish.apf.ProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.Scanner;
import org.glassfish.apf.impl.AnnotationUtils;
import org.glassfish.apf.impl.DefaultErrorHandler;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.glassfish.apf.impl.ProcessingContextImpl;
import org.glassfish.apf.impl.ProcessingResultImpl;
import org.glassfish.apf.impl.StackElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProcessorImpl
implements AnnotationProcessor {
    AnnotationProcessorImpl delegate;
    Map<Class<? extends Annotation>, List<AnnotationHandler>> handlers = new HashMap<Class<? extends Annotation>, List<AnnotationHandler>>();
    int errorCount;
    Logger logger;
    Stack<StackElement> annotatedElements = new Stack();
    Set<Package> visitedPackages = new HashSet<Package>();

    public AnnotationProcessorImpl() {
        this.logger = AnnotationUtils.getLogger();
    }

    public void setDelegate(AnnotationProcessorImpl delegate) {
        this.delegate = delegate;
    }

    @Override
    public ProcessingContext createContext() {
        ProcessingContextImpl ctx = new ProcessingContextImpl(this);
        ctx.setErrorHandler(new DefaultErrorHandler());
        return ctx;
    }

    @Override
    public void log(Level level, AnnotationInfo locator, String localizedMessage) {
        if (this.logger != null && this.logger.isLoggable(level)) {
            if (locator != null) {
                this.logger.log(level, AnnotationUtils.getLocalString("enterprise.deployment.annotation.error", "{2}\n symbol: {0}\n location: {1}", locator.getAnnotation().annotationType().getName(), locator.getAnnotatedElement(), localizedMessage));
            } else {
                this.logger.log(level, localizedMessage);
            }
        }
    }

    @Override
    public ProcessingResult process(ProcessingContext ctx) throws AnnotationProcessorException {
        Scanner scanner = ctx.getProcessingInput();
        ProcessingResultImpl result = new ProcessingResultImpl();
        this.errorCount = 0;
        for (Class c : scanner.getElements()) {
            result.add(this.process(ctx, c));
        }
        return result;
    }

    @Override
    public ProcessingResult process(ProcessingContext ctx, Class[] classes) throws AnnotationProcessorException {
        ProcessingResultImpl result = new ProcessingResultImpl();
        for (Class c : classes) {
            result.add(this.process(ctx, c));
        }
        return result;
    }

    private ProcessingResult process(ProcessingContext ctx, Class c) throws AnnotationProcessorException {
        Scanner scanner = ctx.getProcessingInput();
        ProcessingResultImpl result = new ProcessingResultImpl();
        Package classPackage = c.getPackage();
        if (classPackage != null && this.visitedPackages.add(classPackage)) {
            result.add(classPackage, this.processAnnotations(ctx, ElementType.PACKAGE, classPackage));
        }
        ComponentInfo info = null;
        try {
            info = scanner.getComponentInfo(c);
        }
        catch (NoClassDefFoundError err) {
            AnnotationProcessorException ape = new AnnotationProcessorException(AnnotationUtils.getLocalString("enterprise.deployment.annotation.classnotfounderror", "Class [ {0} ] not found. Error while loading [ {1} ]", err.getMessage(), c));
            ctx.getErrorHandler().error(ape);
            return result;
        }
        AnnotatedElementHandler handler = ctx.getHandler();
        this.logStart(handler, ElementType.TYPE, c);
        result.add(c, this.processAnnotations(ctx, c));
        for (Field field : info.getFields()) {
            result.add(field, this.processAnnotations(ctx, ElementType.FIELD, field));
        }
        for (AccessibleObject accessibleObject : info.getConstructors()) {
            this.logStart(ctx.getHandler(), ElementType.CONSTRUCTOR, accessibleObject);
            result.add(accessibleObject, this.processAnnotations(ctx, accessibleObject));
            this.processParameters(ctx, ((Constructor)accessibleObject).getParameterAnnotations());
            this.logEnd(ctx.getHandler(), ElementType.CONSTRUCTOR, accessibleObject);
        }
        for (AccessibleObject accessibleObject : info.getMethods()) {
            this.logStart(ctx.getHandler(), ElementType.METHOD, accessibleObject);
            result.add(accessibleObject, this.processAnnotations(ctx, accessibleObject));
            this.processParameters(ctx, ((Method)accessibleObject).getParameterAnnotations());
            this.logEnd(ctx.getHandler(), ElementType.METHOD, accessibleObject);
        }
        for (Class currentClass = c.getSuperclass(); currentClass != null && !currentClass.equals(Object.class); currentClass = currentClass.getSuperclass()) {
            result.add(c, this.processAnnotations(ctx, currentClass));
        }
        this.logEnd(ctx.getHandler(), ElementType.TYPE, c);
        return result;
    }

    private HandlerProcessingResult processParameters(ProcessingContext ctx, Annotation[][] parametersAnnotations) throws AnnotationProcessorException {
        HandlerProcessingResultImpl result = new HandlerProcessingResultImpl();
        for (Annotation[] parameterAnnotations : parametersAnnotations) {
            this.logStart(ctx.getHandler(), ElementType.PARAMETER, null);
            if (parameterAnnotations != null) {
                for (Annotation annotation : parameterAnnotations) {
                    AnnotationInfo info = new AnnotationInfo(ctx, null, annotation, ElementType.PARAMETER);
                    this.process(ctx, info, result);
                    this.dumpProcessingResult(result);
                }
            }
            this.logEnd(ctx.getHandler(), ElementType.PARAMETER, null);
        }
        return result;
    }

    private HandlerProcessingResult processAnnotations(ProcessingContext ctx, ElementType type, AnnotatedElement element) throws AnnotationProcessorException {
        AnnotatedElementHandler handler = ctx.getHandler();
        this.logStart(handler, type, element);
        HandlerProcessingResult result = this.processAnnotations(ctx, element);
        this.logEnd(handler, type, element);
        this.dumpProcessingResult(result);
        return result;
    }

    private HandlerProcessingResult processAnnotations(ProcessingContext ctx, AnnotatedElement element) throws AnnotationProcessorException {
        HandlerProcessingResultImpl result = new HandlerProcessingResultImpl();
        for (Annotation annotation : element.getAnnotations()) {
            AnnotationInfo subElement = new AnnotationInfo(ctx, element, annotation, this.getTopElementType());
            if (!result.processedAnnotations().containsKey(annotation.annotationType())) {
                this.process(ctx, subElement, result);
                continue;
            }
            if (!AnnotationUtils.shouldLog("annotation")) continue;
            this.logger.finer("Annotation " + annotation.annotationType() + " already processed");
        }
        return result;
    }

    private void process(ProcessingContext ctx, AnnotationInfo element, HandlerProcessingResultImpl result) throws AnnotationProcessorException {
        Annotation annotation = element.getAnnotation();
        if (AnnotationUtils.shouldLog("annotation")) {
            this.logger.finer("Annotation : " + annotation.annotationType().getName() + " delegate = " + this.delegate);
        }
        result.addResult(annotation.annotationType(), ResultType.UNPROCESSED);
        Package annPackage = annotation.annotationType().getPackage();
        if (annPackage != null && annPackage.getName().startsWith("java.lang")) {
            return;
        }
        List<AnnotationHandler> annotationHandlers = this.handlers.get(annotation.annotationType());
        if (annotationHandlers != null) {
            for (AnnotationHandler handler : annotationHandlers) {
                Class<? extends Annotation>[] dependencies = handler.getTypeDependencies();
                if (dependencies != null) {
                    AnnotatedElement ae = element.getAnnotatedElement();
                    for (Class<? extends Annotation> annotationType : dependencies) {
                        ResultType resultType;
                        Annotation depAnnotation = ae.getAnnotation(annotationType);
                        if (depAnnotation == null || (resultType = result.processedAnnotations().get(annotationType)) != null && resultType != ResultType.UNPROCESSED) continue;
                        AnnotationInfo info = new AnnotationInfo(ctx, ae, depAnnotation, this.getTopElementType());
                        this.process(ctx, info, result);
                    }
                }
                HandlerProcessingResult processingResult = null;
                try {
                    processingResult = handler.processAnnotation(element);
                }
                catch (AnnotationProcessorException ape) {
                    this.log(Level.SEVERE, ape.getLocator(), ape.getMessage());
                    if (ape.isFatal()) {
                        throw ape;
                    }
                    if (++this.errorCount > 100) {
                        throw new AnnotationProcessorException(AnnotationUtils.getLocalString("enterprise.deployment.annotation.toomanyerror", "Too many errors, annotation processing abandoned.", new Object[0]));
                    }
                    processingResult = HandlerProcessingResultImpl.getDefaultResult(annotation.annotationType(), ResultType.FAILED);
                }
                catch (Throwable e) {
                    AnnotationProcessorException ape = new AnnotationProcessorException(e.getMessage(), element);
                    ape.initCause(e);
                    throw ape;
                }
                result.addAll(processingResult);
            }
        } else if (this.delegate != null) {
            this.delegate.process(ctx, element, result);
        } else {
            ctx.getErrorHandler().fine(new AnnotationProcessorException("No handler defined for " + annotation.annotationType()));
        }
    }

    private void dumpProcessingResult(HandlerProcessingResult result) {
        if (result == null || !AnnotationUtils.shouldLog("annotation")) {
            return;
        }
        Map<Class<? extends Annotation>, ResultType> annotationResults = result.processedAnnotations();
        for (Map.Entry<Class<? extends Annotation>, ResultType> element : annotationResults.entrySet()) {
            this.logger.finer("Annotation " + element.getKey() + " : " + (Object)((Object)element.getValue()));
        }
    }

    @Override
    public void pushAnnotationHandler(AnnotationHandler handler) {
        Class<? extends Annotation> type = handler.getAnnotationType();
        List<AnnotationHandler> currentHandlers = this.handlers.get(type);
        if (currentHandlers == null) {
            currentHandlers = new ArrayList<AnnotationHandler>();
            this.handlers.put(type, currentHandlers);
        }
        currentHandlers.add(handler);
    }

    @Override
    public void popAnnotationHandler(Class<? extends Annotation> type) {
        List<AnnotationHandler> currentHandlers = this.handlers.get(type);
        if (currentHandlers != null) {
            currentHandlers.remove(currentHandlers.size());
        }
    }

    @Override
    public AnnotationHandler getAnnotationHandler(Class<? extends Annotation> type) {
        List<AnnotationHandler> currentHandlers = this.handlers.get(type);
        if (currentHandlers != null && currentHandlers.size() > 0) {
            return currentHandlers.get(0);
        }
        return null;
    }

    @Override
    public AnnotatedElement getLastAnnotatedElement(ElementType type) {
        for (int i = this.annotatedElements.size(); i != 0; --i) {
            StackElement e = (StackElement)this.annotatedElements.get(i - 1);
            if (!e.getElementType().equals((Object)type)) continue;
            return e.getAnnotatedElement();
        }
        return null;
    }

    public Stack<StackElement> getStack() {
        return this.annotatedElements;
    }

    private void logStart(AnnotatedElementHandler handler, ElementType type, AnnotatedElement c) throws AnnotationProcessorException {
        if (AnnotationUtils.shouldLog("types")) {
            AnnotationUtils.getLogger().finer((Object)((Object)type) + " START : " + c);
        }
        this.annotatedElements.push(new StackElement(type, c));
        if (this.delegate != null) {
            this.delegate.getStack().push(new StackElement(type, c));
        }
        if (handler != null) {
            handler.startElement(type, c);
        }
    }

    private void logEnd(AnnotatedElementHandler handler, ElementType type, AnnotatedElement c) throws AnnotationProcessorException {
        if (AnnotationUtils.shouldLog("types")) {
            AnnotationUtils.getLogger().finer((Object)((Object)type) + " END : " + c);
        }
        this.annotatedElements.pop();
        if (this.delegate != null) {
            this.delegate.getStack().pop();
        }
        if (handler != null) {
            handler.endElement(type, c);
        }
    }

    private ElementType getTopElementType() {
        try {
            StackElement top = this.annotatedElements.peek();
            return top.getElementType();
        }
        catch (EmptyStackException ex) {
            return null;
        }
    }
}

