/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.loader.util.ASClassLoaderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOLUtils {
    private static Logger logger = null;

    private DOLUtils() {
    }

    public static Logger getDefaultLogger() {
        if (logger == null) {
            logger = LogDomains.getLogger(DeploymentUtils.class, (String)"javax.enterprise.system.tools.deployment");
        }
        return logger;
    }

    public static boolean equals(Object a, Object b) {
        return a == null && b == null || a != null && a.equals(b);
    }

    public static List<URL> getLibraryJars(BundleDescriptor bundleDesc, ReadableArchive archive) throws IOException {
        ArrayList<URL> libraryURLs = new ArrayList<URL>();
        libraryURLs.addAll(DeploymentUtils.getManifestLibraries((ReadableArchive)archive));
        ReadableArchive parentArchive = archive.getParentArchive();
        if (parentArchive == null || bundleDesc == null) {
            return libraryURLs;
        }
        File appRoot = new File(parentArchive.getURI());
        ModuleDescriptor moduleDesc = bundleDesc.getModuleDescriptor();
        Application app = ((BundleDescriptor)moduleDesc.getDescriptor()).getApplication();
        libraryURLs.addAll(ASClassLoaderUtil.getAppLibDirLibrariesAsList((File)appRoot, (String)app.getLibraryDirectory(), null));
        return libraryURLs;
    }

    public static BundleDescriptor getCurrentBundleForContext(DeploymentContext context) {
        ExtendedDeploymentContext ctx = (ExtendedDeploymentContext)context;
        Application application = (Application)context.getModuleMetaData(Application.class);
        if (application == null) {
            return null;
        }
        if (ctx.getParentContext() == null) {
            if (application.isVirtual()) {
                return application.getStandaloneBundleDescriptor();
            }
            return application;
        }
        return application.getModuleByUri(ctx.getModuleUri());
    }
}

