/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.io;

import com.sun.corba.ee.impl.logging.OMGSystemException;
import com.sun.corba.ee.impl.logging.UtilSystemException;
import com.sun.corba.ee.impl.orbutil.DprintUtil;
import com.sun.corba.ee.spi.orb.ORBVersion;
import com.sun.corba.ee.spi.orb.ORBVersionFactory;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.ValueInputStream;
import org.omg.CORBA_2_3.portable.InputStream;

public abstract class InputStreamHook
extends ObjectInputStream {
    protected final DprintUtil dputil = new DprintUtil(this);
    private com.sun.corba.ee.spi.orb.ORB sunORB = null;
    private boolean sfvDebug = false;
    private boolean vhDebug = false;
    static final OMGSystemException omgWrapper = com.sun.corba.ee.spi.orb.ORB.getStaticLogWrapperTable().get_RPC_ENCODING_OMG();
    static final UtilSystemException utilWrapper = com.sun.corba.ee.spi.orb.ORB.getStaticLogWrapperTable().get_RPC_ENCODING_Util();
    protected ReadObjectState readObjectState = DEFAULT_STATE;
    protected static final ReadObjectState DEFAULT_STATE = new DefaultState();
    protected static final ReadObjectState IN_READ_OBJECT_OPT_DATA = new InReadObjectOptionalDataState();
    protected static final ReadObjectState IN_READ_OBJECT_NO_MORE_OPT_DATA = new InReadObjectNoMoreOptionalDataState();
    protected static final ReadObjectState IN_READ_OBJECT_DEFAULTS_SENT = new InReadObjectDefaultsSentState();
    protected static final ReadObjectState NO_READ_OBJECT_DEFAULTS_SENT = new NoReadObjectDefaultsSentState();
    protected static final ReadObjectState IN_READ_OBJECT_REMOTE_NOT_CUSTOM_MARSHALED = new InReadObjectRemoteDidNotUseWriteObjectState();
    protected static final ReadObjectState IN_READ_OBJECT_PAST_DEFAULTS_REMOTE_NOT_CUSTOM = new InReadObjectPastDefaultsRemoteDidNotUseWOState();

    protected void setORB(ORB orb) {
        if (orb instanceof com.sun.corba.ee.spi.orb.ORB) {
            this.sunORB = (com.sun.corba.ee.spi.orb.ORB)orb;
            this.sfvDebug = this.sunORB.streamFormatVersionDebugFlag;
            this.vhDebug = this.sunORB.valueHandlerDebugFlag;
        }
    }

    protected boolean streamFormatVersionDebug() {
        return this.sfvDebug;
    }

    protected boolean valueHandlerDebug() {
        return this.vhDebug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defaultReadObject() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.sunORB.streamFormatVersionDebugFlag) {
            this.dputil.enter("defaultReadObject", new Object[0]);
        }
        try {
            this.readObjectState.beginDefaultReadObject(this);
            this.defaultReadObjectDelegate();
            this.readObjectState.endDefaultReadObject(this);
        }
        finally {
            if (this.sunORB.streamFormatVersionDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    public abstract void defaultReadObjectDelegate();

    abstract void readFields(Map<String, Object> var1) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException;

    @Override
    public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException, NotActiveException {
        HashMap<String, Object> fieldValueMap = new HashMap<String, Object>();
        this.readFields(fieldValueMap);
        this.readObjectState.endDefaultReadObject(this);
        return new HookGetFields(fieldValueMap);
    }

    protected void setState(ReadObjectState newState) {
        if (this.sunORB.streamFormatVersionDebugFlag) {
            this.dputil.enter("setState", "newState" + newState);
        }
        this.readObjectState = newState;
        if (this.sunORB.streamFormatVersionDebugFlag) {
            this.dputil.exit();
        }
    }

    protected abstract byte getStreamFormatVersion();

    protected abstract InputStream getOrbStream();

    protected void throwOptionalDataIncompatibleException() {
        throw omgWrapper.rmiiiopOptionalDataIncompatible2();
    }

    protected static class DefaultState
    extends ReadObjectState {
        protected DefaultState() {
        }

        @Override
        public void beginUnmarshalCustomValueOverride(InputStreamHook stream, boolean calledDefaultWriteObject, boolean hasReadObject) throws IOException {
            if (hasReadObject) {
                if (calledDefaultWriteObject) {
                    stream.setState(IN_READ_OBJECT_DEFAULTS_SENT);
                } else {
                    try {
                        if (stream.getStreamFormatVersion() == 2) {
                            ((ValueInputStream)stream.getOrbStream()).start_value();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    stream.setState(IN_READ_OBJECT_OPT_DATA);
                }
            } else if (calledDefaultWriteObject) {
                stream.setState(NO_READ_OBJECT_DEFAULTS_SENT);
            } else {
                throw new StreamCorruptedException("No default data sent");
            }
        }
    }

    private class HookGetFields
    extends ObjectInputStream.GetField {
        private Map fields = null;

        HookGetFields(Map fields) {
            this.fields = fields;
        }

        @Override
        public ObjectStreamClass getObjectStreamClass() {
            return null;
        }

        @Override
        public boolean defaulted(String name) throws IOException, IllegalArgumentException {
            return !this.fields.containsKey(name);
        }

        @Override
        public boolean get(String name, boolean defvalue) throws IOException, IllegalArgumentException {
            if (this.defaulted(name)) {
                return defvalue;
            }
            return (Boolean)this.fields.get(name);
        }

        @Override
        public char get(String name, char defvalue) throws IOException, IllegalArgumentException {
            if (this.defaulted(name)) {
                return defvalue;
            }
            return ((Character)this.fields.get(name)).charValue();
        }

        @Override
        public byte get(String name, byte defvalue) throws IOException, IllegalArgumentException {
            if (this.defaulted(name)) {
                return defvalue;
            }
            return (Byte)this.fields.get(name);
        }

        @Override
        public short get(String name, short defvalue) throws IOException, IllegalArgumentException {
            if (this.defaulted(name)) {
                return defvalue;
            }
            return (Short)this.fields.get(name);
        }

        @Override
        public int get(String name, int defvalue) throws IOException, IllegalArgumentException {
            if (this.defaulted(name)) {
                return defvalue;
            }
            return (Integer)this.fields.get(name);
        }

        @Override
        public long get(String name, long defvalue) throws IOException, IllegalArgumentException {
            if (this.defaulted(name)) {
                return defvalue;
            }
            return (Long)this.fields.get(name);
        }

        @Override
        public float get(String name, float defvalue) throws IOException, IllegalArgumentException {
            if (this.defaulted(name)) {
                return defvalue;
            }
            return ((Float)this.fields.get(name)).floatValue();
        }

        @Override
        public double get(String name, double defvalue) throws IOException, IllegalArgumentException {
            if (this.defaulted(name)) {
                return defvalue;
            }
            return (Double)this.fields.get(name);
        }

        @Override
        public Object get(String name, Object defvalue) throws IOException, IllegalArgumentException {
            if (this.defaulted(name)) {
                return defvalue;
            }
            return this.fields.get(name);
        }

        public String toString() {
            return this.fields.toString();
        }
    }

    protected static class InReadObjectDefaultsSentState
    extends ReadObjectState {
        protected InReadObjectDefaultsSentState() {
        }

        @Override
        public void beginUnmarshalCustomValueOverride(InputStreamHook stream, boolean calledDefaultWriteObject, boolean hasReadObject) {
            throw utilWrapper.badBeginUnmarshalCustomValue();
        }

        @Override
        public void endUnmarshalCustomValueOverride(InputStreamHook stream) {
            if (stream.getStreamFormatVersion() == 2) {
                ((ValueInputStream)stream.getOrbStream()).start_value();
                ((ValueInputStream)stream.getOrbStream()).end_value();
            }
            stream.setState(DEFAULT_STATE);
        }

        @Override
        public void endDefaultReadObjectOverride(InputStreamHook stream) throws IOException {
            if (stream.getStreamFormatVersion() == 2) {
                ((ValueInputStream)stream.getOrbStream()).start_value();
            }
            stream.setState(IN_READ_OBJECT_OPT_DATA);
        }

        @Override
        public void readDataOverride(InputStreamHook stream) throws IOException {
            ORB orb = stream.getOrbStream().orb();
            if (orb == null || !(orb instanceof com.sun.corba.ee.spi.orb.ORB)) {
                throw new StreamCorruptedException("Default data must be read first");
            }
            ORBVersion clientOrbVersion = ((com.sun.corba.ee.spi.orb.ORB)orb).getORBVersion();
            if (ORBVersionFactory.getPEORB().compareTo(clientOrbVersion) <= 0 || clientOrbVersion.equals(ORBVersionFactory.getFOREIGN())) {
                throw new StreamCorruptedException("Default data must be read first");
            }
        }
    }

    protected static class InReadObjectNoMoreOptionalDataState
    extends InReadObjectOptionalDataState {
        protected InReadObjectNoMoreOptionalDataState() {
        }

        @Override
        public void readDataOverride(InputStreamHook stream) throws IOException {
            stream.throwOptionalDataIncompatibleException();
        }
    }

    protected static class InReadObjectOptionalDataState
    extends ReadObjectState {
        protected InReadObjectOptionalDataState() {
        }

        @Override
        public void beginUnmarshalCustomValueOverride(InputStreamHook stream, boolean calledDefaultWriteObject, boolean hasReadObject) {
            throw utilWrapper.badBeginUnmarshalCustomValue();
        }

        @Override
        public void endUnmarshalCustomValueOverride(InputStreamHook stream) throws IOException {
            if (stream.getStreamFormatVersion() == 2) {
                ((ValueInputStream)stream.getOrbStream()).end_value();
            }
            stream.setState(DEFAULT_STATE);
        }

        @Override
        public void beginDefaultReadObjectOverride(InputStreamHook stream) throws IOException {
            throw new StreamCorruptedException("Default data not sent or already read/passed");
        }
    }

    protected static class InReadObjectPastDefaultsRemoteDidNotUseWOState
    extends ReadObjectState {
        protected InReadObjectPastDefaultsRemoteDidNotUseWOState() {
        }

        @Override
        public void beginUnmarshalCustomValueOverride(InputStreamHook stream, boolean calledDefaultWriteObject, boolean hasReadObject) {
            throw utilWrapper.badBeginUnmarshalCustomValue();
        }

        @Override
        public void beginDefaultReadObjectOverride(InputStreamHook stream) throws IOException {
            throw new StreamCorruptedException("Default data already read");
        }

        @Override
        public void readDataOverride(InputStreamHook stream) {
            stream.throwOptionalDataIncompatibleException();
        }
    }

    protected static class InReadObjectRemoteDidNotUseWriteObjectState
    extends ReadObjectState {
        protected InReadObjectRemoteDidNotUseWriteObjectState() {
        }

        @Override
        public void beginUnmarshalCustomValueOverride(InputStreamHook stream, boolean calledDefaultWriteObject, boolean hasReadObject) {
            throw utilWrapper.badBeginUnmarshalCustomValue();
        }

        @Override
        public void endDefaultReadObjectOverride(InputStreamHook stream) {
            stream.setState(IN_READ_OBJECT_PAST_DEFAULTS_REMOTE_NOT_CUSTOM);
        }

        @Override
        public void readDataOverride(InputStreamHook stream) {
            stream.throwOptionalDataIncompatibleException();
        }
    }

    protected static class NoReadObjectDefaultsSentState
    extends ReadObjectState {
        protected NoReadObjectDefaultsSentState() {
        }

        @Override
        public void endUnmarshalCustomValueOverride(InputStreamHook stream) throws IOException {
            if (stream.getStreamFormatVersion() == 2) {
                ((ValueInputStream)stream.getOrbStream()).start_value();
                ((ValueInputStream)stream.getOrbStream()).end_value();
            }
            stream.setState(DEFAULT_STATE);
        }
    }

    protected static class ReadObjectState {
        private final DprintUtil dputil = new DprintUtil(this);
        private final String name;

        public ReadObjectState() {
            String className = this.getClass().getName();
            int index = className.indexOf(36);
            this.name = className.substring(index + 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void beginUnmarshalCustomValue(InputStreamHook stream, boolean calledDefaultWriteObject, boolean hasReadObject) throws IOException {
            if (stream.streamFormatVersionDebug()) {
                this.dputil.enter("beginUnmarshalCustomValue", "calledDefaultWriteObject", calledDefaultWriteObject, "hasReadObject", hasReadObject);
            }
            try {
                this.beginUnmarshalCustomValueOverride(stream, calledDefaultWriteObject, hasReadObject);
            }
            finally {
                if (stream.streamFormatVersionDebug()) {
                    this.dputil.exit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void endUnmarshalCustomValue(InputStreamHook stream) throws IOException {
            if (stream.streamFormatVersionDebug()) {
                this.dputil.enter("endUnmarshalCustomValue", new Object[0]);
            }
            try {
                this.endUnmarshalCustomValueOverride(stream);
            }
            finally {
                if (stream.streamFormatVersionDebug()) {
                    this.dputil.exit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void beginDefaultReadObject(InputStreamHook stream) throws IOException {
            if (stream.streamFormatVersionDebug()) {
                this.dputil.enter("beginDefaultReadObject", new Object[0]);
            }
            try {
                this.beginDefaultReadObjectOverride(stream);
            }
            finally {
                if (stream.streamFormatVersionDebug()) {
                    this.dputil.exit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void endDefaultReadObject(InputStreamHook stream) throws IOException {
            if (stream.streamFormatVersionDebug()) {
                this.dputil.enter("endDefaultReadObject", new Object[0]);
            }
            try {
                this.endDefaultReadObjectOverride(stream);
            }
            finally {
                if (stream.streamFormatVersionDebug()) {
                    this.dputil.exit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void readData(InputStreamHook stream) throws IOException {
            if (stream.streamFormatVersionDebug()) {
                this.dputil.enter("readData", new Object[0]);
            }
            try {
                this.readDataOverride(stream);
            }
            finally {
                if (stream.streamFormatVersionDebug()) {
                    this.dputil.exit();
                }
            }
        }

        public void beginUnmarshalCustomValueOverride(InputStreamHook stream, boolean calledDefaultWriteObject, boolean hasReadObject) throws IOException {
        }

        public void endUnmarshalCustomValueOverride(InputStreamHook stream) throws IOException {
        }

        public void beginDefaultReadObjectOverride(InputStreamHook stream) throws IOException {
        }

        public void endDefaultReadObjectOverride(InputStreamHook stream) throws IOException {
        }

        public void readDataOverride(InputStreamHook stream) throws IOException {
        }

        public String toString() {
            return this.name;
        }
    }
}

