/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.encoding.CDROutputObject;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.oa.poa.Policies;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.transport.EventHandlerBase;
import com.sun.corba.ee.impl.transport.SocketOrChannelConnectionImpl;
import com.sun.corba.ee.impl.transport.SocketOrChannelContactInfoImpl;
import com.sun.corba.ee.pept.broker.Broker;
import com.sun.corba.ee.pept.encoding.InputObject;
import com.sun.corba.ee.pept.encoding.OutputObject;
import com.sun.corba.ee.pept.protocol.MessageMediator;
import com.sun.corba.ee.pept.transport.Acceptor;
import com.sun.corba.ee.pept.transport.Connection;
import com.sun.corba.ee.pept.transport.EventHandler;
import com.sun.corba.ee.pept.transport.InboundConnectionCache;
import com.sun.corba.ee.pept.transport.Selector;
import com.sun.corba.ee.spi.extension.RequestPartitioningPolicy;
import com.sun.corba.ee.spi.ior.IORTemplate;
import com.sun.corba.ee.spi.ior.TaggedProfileTemplate;
import com.sun.corba.ee.spi.ior.iiop.AlternateIIOPAddressComponent;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.ior.iiop.IIOPAddress;
import com.sun.corba.ee.spi.ior.iiop.IIOPFactories;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.legacy.connection.LegacyServerSocketEndPointInfo;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.threadpool.Work;
import com.sun.corba.ee.spi.protocol.CorbaMessageMediator;
import com.sun.corba.ee.spi.transport.CorbaAcceptor;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import com.sun.corba.ee.spi.transport.SocketInfo;
import com.sun.corba.ee.spi.transport.SocketOrChannelAcceptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;

public class SocketOrChannelAcceptorImpl
extends EventHandlerBase
implements CorbaAcceptor,
SocketOrChannelAcceptor,
Work,
SocketInfo,
LegacyServerSocketEndPointInfo {
    protected ServerSocketChannel serverSocketChannel;
    protected ServerSocket serverSocket;
    protected int port;
    protected long enqueueTime;
    protected boolean initialized;
    protected ORBUtilSystemException wrapper;
    protected InboundConnectionCache connectionCache;
    private Class<?> lastExceptionClassSeen = null;
    protected String type = "";
    protected String name = "";
    protected String hostname;
    protected int locatorPort;

    public SocketOrChannelAcceptorImpl(ORB orb) {
        this.orb = orb;
        this.wrapper = orb.getLogWrapperTable().get_RPC_TRANSPORT_ORBUtil();
        this.setWork(this);
        this.initialized = false;
        this.hostname = orb.getORBData().getORBServerHost();
        this.name = "NO_NAME";
        this.locatorPort = -1;
    }

    public SocketOrChannelAcceptorImpl(ORB orb, int port) {
        this(orb);
        this.port = port;
    }

    public SocketOrChannelAcceptorImpl(ORB orb, int port, String name, String type) {
        this(orb, port);
        this.name = name;
        this.type = type;
    }

    @Override
    public synchronized boolean initialize() {
        if (this.initialized) {
            return false;
        }
        if (this.orb.transportDebugFlag) {
            this.dprint(".initialize: " + this);
        }
        InetSocketAddress inetSocketAddress = null;
        String host = "all interfaces";
        try {
            if (this.orb.getORBData().getListenOnAllInterfaces()) {
                inetSocketAddress = new InetSocketAddress(this.port);
            } else {
                host = this.orb.getORBData().getORBServerHost();
                inetSocketAddress = new InetSocketAddress(host, this.port);
            }
            this.serverSocket = this.orb.getORBData().getSocketFactory().createServerSocket(this.type, inetSocketAddress);
            this.internalInitialize();
            if (this.orb.getORBData().showInfoMessages()) {
                this.wrapper.infoCreateListenerSucceeded(host, Integer.toString(this.port));
            }
        }
        catch (Throwable t) {
            throw this.wrapper.createListenerFailed(t, (Object)host, (Object)Integer.toString(this.port));
        }
        this.initialized = true;
        return true;
    }

    protected void internalInitialize() throws Exception {
        this.port = this.serverSocket.getLocalPort();
        this.orb.getCorbaTransportManager().getInboundConnectionCache(this);
        this.serverSocketChannel = this.serverSocket.getChannel();
        if (this.serverSocketChannel != null) {
            this.setUseSelectThreadToWait(this.orb.getORBData().acceptorSocketUseSelectThreadToWait());
            this.serverSocketChannel.configureBlocking(!this.orb.getORBData().acceptorSocketUseSelectThreadToWait());
        } else {
            this.setUseSelectThreadToWait(false);
        }
        this.setUseWorkerThreadForEvent(this.orb.getORBData().acceptorSocketUseWorkerThreadForEvent());
    }

    @Override
    public synchronized boolean initialized() {
        return this.initialized;
    }

    @Override
    public String getConnectionCacheType() {
        return this.getClass().toString();
    }

    @Override
    public void setConnectionCache(InboundConnectionCache connectionCache) {
        this.connectionCache = connectionCache;
    }

    @Override
    public InboundConnectionCache getConnectionCache() {
        return this.connectionCache;
    }

    @Override
    public boolean shouldRegisterAcceptEvent() {
        return true;
    }

    @Override
    public void accept() {
        SocketChannel socketChannel = null;
        Socket socket = null;
        try {
            if (this.serverSocketChannel == null) {
                socket = this.serverSocket.accept();
            } else {
                socketChannel = this.serverSocketChannel.accept();
                socket = socketChannel.socket();
            }
            this.orb.getORBData().getSocketFactory().setAcceptedSocketOptions(this, this.serverSocket, socket);
            this.lastExceptionClassSeen = null;
        }
        catch (IOException e) {
            if (e.getClass() == this.lastExceptionClassSeen) {
                this.wrapper.ioexceptionInAcceptFine(e);
            } else {
                this.lastExceptionClassSeen = e.getClass();
                this.wrapper.ioexceptionInAccept(e);
            }
            this.orb.getTransportManager().getSelector(0).unregisterForEvent(this);
            this.orb.getTransportManager().getSelector(0).registerForEvent(this);
        }
        if (this.orb.transportDebugFlag) {
            this.dprint(".accept: " + (this.serverSocketChannel == null ? this.serverSocket.toString() : this.serverSocketChannel.toString()));
        }
        SocketOrChannelConnectionImpl connection = new SocketOrChannelConnectionImpl(this.orb, this, socket);
        if (this.orb.transportDebugFlag) {
            this.dprint(".accept: new: " + connection);
        }
        this.getConnectionCache().put(this, connection);
        if (connection.shouldRegisterServerReadEvent()) {
            Selector selector = this.orb.getTransportManager().getSelector(0);
            selector.registerForEvent(connection.getEventHandler());
        }
        this.getConnectionCache().reclaim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close->:");
            }
            Selector selector = this.orb.getTransportManager().getSelector(0);
            selector.unregisterForEvent(this);
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
            }
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close:", e);
            }
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close<-:");
            }
        }
    }

    @Override
    public EventHandler getEventHandler() {
        return this;
    }

    @Override
    public String getObjectAdapterId() {
        return null;
    }

    @Override
    public String getObjectAdapterManagerId() {
        return null;
    }

    @Override
    public void addToIORTemplate(IORTemplate iorTemplate, Policies policies, String codebase) {
        Iterator<TaggedProfileTemplate> iterator = iorTemplate.iteratorById(0);
        String hostname = this.orb.getORBData().getORBServerHost();
        if (iterator.hasNext()) {
            IIOPAddress iiopAddress = IIOPFactories.makeIIOPAddress(this.orb, hostname, this.port);
            AlternateIIOPAddressComponent iiopAddressComponent = IIOPFactories.makeAlternateIIOPAddressComponent(iiopAddress);
            while (iterator.hasNext()) {
                TaggedProfileTemplate taggedProfileTemplate = iterator.next();
                taggedProfileTemplate.add(iiopAddressComponent);
            }
        } else {
            IIOPProfileTemplate iiopProfile = this.makeIIOPProfileTemplate(policies, codebase);
            iorTemplate.add(iiopProfile);
        }
    }

    protected final IIOPProfileTemplate makeIIOPProfileTemplate(Policies policies, String codebase) {
        GIOPVersion version = this.orb.getORBData().getGIOPVersion();
        int templatePort = policies.forceZeroPort() ? 0 : (policies.isTransient() ? this.port : this.orb.getLegacyServerSocketManager().legacyGetPersistentServerPort("IIOP_CLEAR_TEXT"));
        IIOPAddress addr = IIOPFactories.makeIIOPAddress(this.orb, this.hostname, templatePort);
        IIOPProfileTemplate iiopProfile = IIOPFactories.makeIIOPProfileTemplate(this.orb, version, addr);
        if (version.supportsIORIIOPProfileComponents()) {
            iiopProfile.add(IIOPFactories.makeCodeSetsComponent(this.orb));
            iiopProfile.add(IIOPFactories.makeMaxStreamFormatVersionComponent());
            RequestPartitioningPolicy rpPolicy = (RequestPartitioningPolicy)policies.get_effective_policy(0x53550003);
            if (rpPolicy != null) {
                iiopProfile.add(IIOPFactories.makeRequestPartitioningComponent(rpPolicy.getValue()));
            }
            if (codebase != null && !codebase.equals("")) {
                iiopProfile.add(IIOPFactories.makeJavaCodebaseComponent(codebase));
            }
            if (this.orb.getORBData().isJavaSerializationEnabled()) {
                iiopProfile.add(IIOPFactories.makeJavaSerializationComponent());
            }
        }
        return iiopProfile;
    }

    @Override
    public String getMonitoringName() {
        return "AcceptedConnections";
    }

    @Override
    public SelectableChannel getChannel() {
        return this.serverSocketChannel;
    }

    @Override
    public int getInterestOps() {
        return 16;
    }

    @Override
    public Acceptor getAcceptor() {
        return this;
    }

    @Override
    public Connection getConnection() {
        throw new RuntimeException("Should not happen.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWork() {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork->: " + this);
            }
            if (this.selectionKey.isAcceptable()) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        SocketOrChannelAcceptorImpl.this.accept();
                        return null;
                    }
                });
            } else if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: ! selectionKey.isAcceptable: " + this);
            }
        }
        catch (SecurityException se) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: ignoring SecurityException: " + se + " " + this);
            }
            String permissionStr = ORBUtility.getClassSecurityInfo(this.getClass());
            this.wrapper.securityExceptionInAccept(se, (Object)permissionStr);
        }
        catch (Exception ex) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: ignoring Exception: " + ex + " " + this);
            }
            this.wrapper.exceptionInAccept(ex);
        }
        catch (Throwable t) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: ignoring Throwable: " + t + " " + this);
            }
        }
        finally {
            Selector selector = this.orb.getTransportManager().getSelector(0);
            selector.registerInterestOps(this);
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork<-:" + this);
            }
        }
    }

    @Override
    public void setEnqueueTime(long timeInMillis) {
        this.enqueueTime = timeInMillis;
    }

    @Override
    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    @Override
    public MessageMediator createMessageMediator(Broker broker, Connection connection) {
        SocketOrChannelContactInfoImpl contactInfo = new SocketOrChannelContactInfoImpl();
        return contactInfo.createMessageMediator(broker, connection);
    }

    @Override
    public InputObject createInputObject(Broker broker, MessageMediator messageMediator) {
        CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
        return new CDRInputObject((ORB)broker, (CorbaConnection)messageMediator.getConnection(), corbaMessageMediator.getDispatchBuffer(), corbaMessageMediator.getDispatchHeader());
    }

    @Override
    public OutputObject createOutputObject(Broker broker, MessageMediator messageMediator) {
        CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
        return new CDROutputObject((ORB)broker, corbaMessageMediator, corbaMessageMediator.getReplyHeader(), corbaMessageMediator.getStreamFormatVersion());
    }

    @Override
    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public String toString() {
        String sock = this.serverSocketChannel == null ? (this.serverSocket == null ? "(not initialized)" : this.serverSocket.toString()) : this.serverSocketChannel.toString();
        return this.toStringName() + "[" + sock + " " + this.type + " " + this.shouldUseSelectThreadToWait() + " " + this.shouldUseWorkerThreadForEvent() + "]";
    }

    protected String toStringName() {
        return "SocketOrChannelAcceptorImpl";
    }

    protected void dprint(String msg) {
        ORBUtility.dprint(this.toStringName(), msg);
    }

    protected void dprint(String msg, Throwable t) {
        this.dprint(msg);
        t.printStackTrace(System.out);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getHostName() {
        return this.hostname;
    }

    @Override
    public String getHost() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public int getLocatorPort() {
        return this.locatorPort;
    }

    @Override
    public void setLocatorPort(int port) {
        this.locatorPort = port;
    }

    @Override
    public String getName() {
        String result = this.name.equals("NO_NAME") ? this.toString() : this.name;
        return result;
    }
}

