/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.newtimer;

import com.sun.corba.ee.impl.orbutil.newtimer.TimerFactoryImpl;
import com.sun.corba.ee.spi.orbutil.jmx.ManagedAttribute;
import com.sun.corba.ee.spi.orbutil.jmx.ManagedOperation;
import com.sun.corba.ee.spi.orbutil.newtimer.NamedBase;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerEvent;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerEventHandler;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class TimerEventControllerBase
extends NamedBase {
    private Set<TimerEventHandler> handlers = new HashSet<TimerEventHandler>();
    private Set<TimerEventHandler> roHandlers = Collections.unmodifiableSet(this.handlers);

    public TimerEventControllerBase(TimerFactory factory, String name) {
        super(factory, name);
        TimerFactoryImpl tfi = (TimerFactoryImpl)TimerFactoryImpl.class.cast(factory);
        tfi.saveTimerEventController(this);
    }

    @ManagedOperation(description="Register a TimerEventHandler with this TimerEventController")
    public void register(TimerEventHandler handler) {
        this.handlers.add(handler);
    }

    @ManagedOperation(description="Deregister a TimerEventHandler from this TimerEventController")
    public void deregister(TimerEventHandler handler) {
        this.handlers.remove(handler);
    }

    @ManagedAttribute(description="TimerEventHandlers registered with this TimerEventController")
    public Set<TimerEventHandler> handlers() {
        return this.roHandlers;
    }

    protected void propagate(TimerEvent ev) {
        for (TimerEventHandler handler : this.handlers) {
            handler.notify(ev);
        }
    }
}

