/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.orbutil.newtimer.generated.TimingPoints;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.LocateReplyOrReplyMessage;
import com.sun.corba.ee.pept.encoding.InputObject;
import com.sun.corba.ee.pept.protocol.MessageMediator;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.protocol.CorbaMessageMediator;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import com.sun.corba.ee.spi.transport.CorbaResponseWaitingRoom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;

public class CorbaResponseWaitingRoomImpl
implements CorbaResponseWaitingRoom {
    private TimingPoints tp;
    private final Map<Integer, OutCallDesc> out_calls;
    private final ORB orb;
    private final CorbaConnection connection;
    private final ORBUtilSystemException wrapper;

    public CorbaResponseWaitingRoomImpl(ORB orb, CorbaConnection connection) {
        this.orb = orb;
        this.tp = (TimingPoints)orb.getTimerManager().points();
        this.wrapper = orb.getLogWrapperTable().get_RPC_TRANSPORT_ORBUtil();
        this.connection = connection;
        this.out_calls = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public void registerWaiter(MessageMediator mediator) {
        CorbaMessageMediator messageMediator = (CorbaMessageMediator)mediator;
        if (this.orb.transportDebugFlag) {
            this.dprint(".registerWaiter: " + this.opAndId(messageMediator));
        }
        Integer requestId = messageMediator.getRequestIdInteger();
        OutCallDesc call = new OutCallDesc();
        call.messageMediator = messageMediator;
        OutCallDesc exists = this.out_calls.put(requestId, call);
        if (exists != null) {
            this.wrapper.duplicateRequestIdsInResponseWaitingRoom(this.opAndId((CorbaMessageMediator)exists.messageMediator), this.opAndId(messageMediator));
        }
    }

    @Override
    public void unregisterWaiter(MessageMediator mediator) {
        CorbaMessageMediator messageMediator = (CorbaMessageMediator)mediator;
        if (this.orb.transportDebugFlag) {
            this.dprint(".unregisterWaiter: " + this.opAndId(messageMediator));
        }
        Integer requestId = messageMediator.getRequestIdInteger();
        this.out_calls.remove(requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputObject waitForResponse(MessageMediator mediator) {
        CorbaMessageMediator messageMediator = (CorbaMessageMediator)mediator;
        try {
            this.tp.enter_waitForResponse();
            InputObject returnStream = null;
            if (this.orb.transportDebugFlag) {
                this.dprint(".waitForResponse->: " + this.opAndId(messageMediator));
            }
            Integer requestId = messageMediator.getRequestIdInteger();
            if (messageMediator.isOneWay()) {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".waitForResponse: one way - not waiting: " + this.opAndId(messageMediator));
                }
                InputObject inputObject = null;
                return inputObject;
            }
            OutCallDesc call = this.out_calls.get(requestId);
            if (call == null) {
                throw this.wrapper.nullOutCall(CompletionStatus.COMPLETED_MAYBE);
            }
            long waitForResponseTimeout = this.orb.getORBData().getWaitForResponseTimeout() * 1000L * 1000L;
            try {
                call.lock.lock();
                while (call.inputObject == null && call.exception == null) {
                    try {
                        if (this.orb.transportDebugFlag) {
                            this.dprint(".waitForResponse: waiting: " + this.opAndId(messageMediator));
                        }
                        waitForResponseTimeout = call.condition.awaitNanos(waitForResponseTimeout);
                        if (call.inputObject != null || call.exception != null) continue;
                        if (waitForResponseTimeout > 0L) {
                            if (!this.orb.transportDebugFlag) continue;
                            this.dprint(".waitForResponse: a 'spurious wait' detected: " + this.opAndId(messageMediator) + ", will continue to wait another " + waitForResponseTimeout / 1000000L + " ms.");
                            continue;
                        }
                        call.exception = this.wrapper.communicationsTimeoutWaitingForResponse(CompletionStatus.COMPLETED_MAYBE, (Object)this.orb.getORBData().getWaitForResponseTimeout());
                        ORBUtility.pushEncVersionToThreadLocalState((byte)1);
                    }
                    catch (InterruptedException ie) {}
                }
                if (call.exception != null) {
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".waitForResponse: exception: " + this.opAndId(messageMediator) + " " + (Object)((Object)call.exception));
                    }
                    throw call.exception;
                }
                returnStream = call.inputObject;
            }
            finally {
                call.lock.unlock();
            }
            if (returnStream != null) {
                ((CDRInputObject)returnStream).unmarshalHeader();
            }
            InputObject inputObject = returnStream;
            return inputObject;
        }
        finally {
            this.tp.exit_waitForResponse();
            if (this.orb.transportDebugFlag) {
                this.dprint(".waitForResponse<-: " + this.opAndId(messageMediator));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void responseReceived(InputObject is) {
        OutCallDesc call;
        CDRInputObject inputObject = (CDRInputObject)is;
        LocateReplyOrReplyMessage header = (LocateReplyOrReplyMessage)inputObject.getMessageHeader();
        if (this.orb.transportDebugFlag) {
            this.dprint(".responseReceived: id/" + header.getRequestId() + ": " + header);
        }
        if ((call = this.out_calls.get(header.getRequestId())) == null) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".responseReceived: id/" + header.getRequestId() + ": no waiter: " + header);
            }
            return;
        }
        try {
            call.lock.lock();
            CorbaMessageMediator messageMediator = (CorbaMessageMediator)call.messageMediator;
            if (this.orb.transportDebugFlag) {
                this.dprint(".responseReceived: " + this.opAndId(messageMediator) + ": notifying waiters");
            }
            messageMediator.setReplyHeader(header);
            messageMediator.setInputObject(is);
            inputObject.setMessageMediator(messageMediator);
            call.inputObject = is;
            call.condition.signal();
        }
        finally {
            call.lock.unlock();
        }
    }

    @Override
    public int numberRegistered() {
        return this.out_calls.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalExceptionToAllWaiters(SystemException systemException) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".signalExceptionToAllWaiters: " + (Object)((Object)systemException));
        }
        Map<Integer, OutCallDesc> map = this.out_calls;
        synchronized (map) {
            for (OutCallDesc call : this.out_calls.values()) {
                try {
                    call.lock.lock();
                    ((CorbaMessageMediator)call.messageMediator).cancelRequest();
                    call.inputObject = null;
                    call.exception = systemException;
                    call.condition.signal();
                }
                finally {
                    call.lock.unlock();
                }
            }
        }
    }

    @Override
    public MessageMediator getMessageMediator(int requestId) {
        OutCallDesc call = this.out_calls.get(requestId);
        if (call == null) {
            return null;
        }
        return call.messageMediator;
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("CorbaResponseWaitingRoomImpl", msg);
    }

    protected String opAndId(CorbaMessageMediator mediator) {
        return ORBUtility.operationNameAndRequestId(mediator);
    }

    static final class OutCallDesc {
        MessageMediator messageMediator;
        SystemException exception;
        InputObject inputObject;
        ReentrantLock lock = new ReentrantLock();
        Condition condition = this.lock.newCondition();

        OutCallDesc() {
        }
    }
}

