/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.interceptors;

import com.sun.corba.ee.impl.interceptors.RequestInfoImpl;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.ReplyMessage;
import com.sun.corba.ee.spi.ior.ObjectAdapterId;
import com.sun.corba.ee.spi.ior.ObjectKeyTemplate;
import com.sun.corba.ee.spi.legacy.connection.Connection;
import com.sun.corba.ee.spi.oa.ObjectAdapter;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.presentation.rmi.StubAdapter;
import com.sun.corba.ee.spi.protocol.CorbaMessageMediator;
import com.sun.corba.ee.spi.servicecontext.ServiceContexts;
import java.util.ArrayList;
import java.util.HashMap;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.NVList;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.TypeCode;
import org.omg.Dynamic.Parameter;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableServer.DynamicImplementation;
import org.omg.PortableServer.Servant;

public final class ServerRequestInfoImpl
extends RequestInfoImpl
implements ServerRequestInfo {
    static final int CALL_RECEIVE_REQUEST_SERVICE_CONTEXT = 0;
    static final int CALL_RECEIVE_REQUEST = 0;
    static final int CALL_INTERMEDIATE_NONE = 1;
    static final int CALL_SEND_REPLY = 0;
    static final int CALL_SEND_EXCEPTION = 1;
    static final int CALL_SEND_OTHER = 2;
    private boolean forwardRequestRaisedInEnding;
    private CorbaMessageMediator request;
    private java.lang.Object servant;
    private byte[] objectId;
    private ObjectKeyTemplate oktemp;
    private byte[] adapterId;
    private String[] adapterName;
    private ArrayList<AddReplyServiceContextCommand> addReplyServiceContextQueue;
    private ReplyMessage replyMessage;
    private String targetMostDerivedInterface;
    private NVList dsiArguments;
    private Any dsiResult;
    private Any dsiException;
    private boolean isDynamic;
    private ObjectAdapter objectAdapter;
    private int serverRequestId;
    private Parameter[] cachedArguments;
    private Any cachedSendingException;
    private HashMap<Integer, ServiceContext> cachedRequestServiceContexts;
    private HashMap<Integer, ServiceContext> cachedReplyServiceContexts;
    private static final int MID_SENDING_EXCEPTION = 14;
    private static final int MID_OBJECT_ID = 15;
    private static final int MID_ADAPTER_ID = 16;
    private static final int MID_TARGET_MOST_DERIVED_INTERFACE = 17;
    private static final int MID_GET_SERVER_POLICY = 18;
    private static final int MID_SET_SLOT = 19;
    private static final int MID_TARGET_IS_A = 20;
    private static final int MID_ADD_REPLY_SERVICE_CONTEXT = 21;
    private static final int MID_SERVER_ID = 22;
    private static final int MID_ORB_ID = 23;
    private static final int MID_ADAPTER_NAME = 24;
    private static final boolean[][] validCall = new boolean[][]{{true, true, true, true, true}, {true, true, true, true, true}, {false, true, true, false, false}, {false, true, true, true, true}, {false, true, true, true, true}, {false, true, true, false, false}, {false, false, true, false, false}, {true, true, true, true, true}, {true, true, true, true, true}, {false, false, true, true, true}, {false, false, false, false, true}, {true, true, true, true, true}, {true, true, true, true, true}, {false, false, true, true, true}, {false, false, false, true, false}, {false, true, true, true, true}, {false, true, true, true, true}, {false, true, false, false, false}, {true, true, true, true, true}, {true, true, true, true, true}, {false, true, false, false, false}, {true, true, true, true, true}, {false, true, true, true, true}, {false, true, true, true, true}, {false, true, true, true, true}};

    @Override
    void reset() {
        super.reset();
        this.forwardRequestRaisedInEnding = false;
        this.request = null;
        this.servant = null;
        this.objectId = null;
        this.oktemp = null;
        this.adapterId = null;
        this.adapterName = null;
        this.addReplyServiceContextQueue = null;
        this.replyMessage = null;
        this.targetMostDerivedInterface = null;
        this.dsiArguments = null;
        this.dsiResult = null;
        this.dsiException = null;
        this.isDynamic = false;
        this.objectAdapter = null;
        this.serverRequestId = this.myORB.getPIHandler().allocateServerRequestId();
        this.cachedArguments = null;
        this.cachedSendingException = null;
        this.cachedRequestServiceContexts = null;
        this.cachedReplyServiceContexts = null;
        this.startingPointCall = 0;
        this.intermediatePointCall = 0;
        this.endingPointCall = 0;
    }

    ServerRequestInfoImpl(ORB myORB) {
        super(myORB);
        this.startingPointCall = 0;
        this.intermediatePointCall = 0;
        this.endingPointCall = 0;
        this.serverRequestId = myORB.getPIHandler().allocateServerRequestId();
    }

    public Any sending_exception() {
        this.checkAccess(14);
        if (this.cachedSendingException == null) {
            Any result = null;
            if (this.dsiException != null) {
                result = this.dsiException;
            } else if (this.exception != null) {
                result = this.exceptionToAny(this.exception);
            } else {
                throw this.wrapper.exceptionUnavailable();
            }
            this.cachedSendingException = result;
        }
        return this.cachedSendingException;
    }

    public byte[] object_id() {
        this.checkAccess(15);
        if (this.objectId == null) {
            throw this.stdWrapper.piOperationNotSupported6();
        }
        return this.objectId;
    }

    private void checkForNullTemplate() {
        if (this.oktemp == null) {
            throw this.stdWrapper.piOperationNotSupported7();
        }
    }

    public String server_id() {
        this.checkAccess(22);
        this.checkForNullTemplate();
        return Integer.toString(this.oktemp.getServerId());
    }

    public String orb_id() {
        this.checkAccess(23);
        return this.myORB.getORBData().getORBId();
    }

    public synchronized String[] adapter_name() {
        this.checkAccess(24);
        if (this.adapterName == null) {
            this.checkForNullTemplate();
            ObjectAdapterId oaid = this.oktemp.getObjectAdapterId();
            this.adapterName = oaid.getAdapterName();
        }
        return this.adapterName;
    }

    public synchronized byte[] adapter_id() {
        this.checkAccess(16);
        if (this.adapterId == null) {
            this.checkForNullTemplate();
            this.adapterId = this.oktemp.getAdapterId();
        }
        return this.adapterId;
    }

    public String target_most_derived_interface() {
        this.checkAccess(17);
        return this.targetMostDerivedInterface;
    }

    public Policy get_server_policy(int type) {
        Policy result = null;
        if (this.objectAdapter != null) {
            result = this.objectAdapter.getEffectivePolicy(type);
        }
        return result;
    }

    public void set_slot(int id, Any data) throws InvalidSlot {
        this.slotTable.set_slot(id, data);
    }

    public boolean target_is_a(String id) {
        this.checkAccess(20);
        boolean result = false;
        if (this.servant instanceof Servant) {
            result = ((Servant)this.servant)._is_a(id);
        } else if (StubAdapter.isStub(this.servant)) {
            result = ((Object)this.servant)._is_a(id);
        } else {
            throw this.wrapper.servantInvalid();
        }
        return result;
    }

    public void add_reply_service_context(ServiceContext service_context, boolean replace) {
        if (this.currentExecutionPoint == 2) {
            ServiceContexts scs = this.replyMessage.getServiceContexts();
            if (this.cachedReplyServiceContexts == null) {
                this.cachedReplyServiceContexts = new HashMap();
            }
            this.addServiceContext(this.cachedReplyServiceContexts, scs, service_context, replace);
        }
        AddReplyServiceContextCommand addReply = new AddReplyServiceContextCommand();
        addReply.service_context = service_context;
        addReply.replace = replace;
        if (this.addReplyServiceContextQueue == null) {
            this.addReplyServiceContextQueue = new ArrayList();
        }
        this.enqueue(addReply);
    }

    @Override
    public int request_id() {
        return this.serverRequestId;
    }

    @Override
    public String operation() {
        return this.request.getOperationName();
    }

    public String toString() {
        return "ServerRequestInfoImpl[operation=" + this.operation() + "]";
    }

    @Override
    public Parameter[] arguments() {
        this.checkAccess(2);
        if (this.cachedArguments == null) {
            if (!this.isDynamic) {
                throw this.stdWrapper.piOperationNotSupported1();
            }
            if (this.dsiArguments == null) {
                throw this.stdWrapper.piOperationNotSupported8();
            }
            this.cachedArguments = this.nvListToParameterArray(this.dsiArguments);
        }
        return this.cachedArguments;
    }

    @Override
    public TypeCode[] exceptions() {
        this.checkAccess(3);
        throw this.stdWrapper.piOperationNotSupported2();
    }

    @Override
    public String[] contexts() {
        this.checkAccess(4);
        throw this.stdWrapper.piOperationNotSupported3();
    }

    @Override
    public String[] operation_context() {
        this.checkAccess(5);
        throw this.stdWrapper.piOperationNotSupported4();
    }

    @Override
    public Any result() {
        this.checkAccess(6);
        if (!this.isDynamic) {
            throw this.stdWrapper.piOperationNotSupported5();
        }
        if (this.dsiResult == null) {
            throw this.wrapper.piDsiResultIsNull();
        }
        return this.dsiResult;
    }

    @Override
    public boolean response_expected() {
        return !this.request.isOneWay();
    }

    @Override
    public Object forward_reference() {
        this.checkAccess(10);
        if (this.replyStatus != 3) {
            throw this.stdWrapper.invalidPiCall1();
        }
        return this.getForwardRequestException().forward;
    }

    @Override
    public ServiceContext get_request_service_context(int id) {
        this.checkAccess(12);
        if (this.cachedRequestServiceContexts == null) {
            this.cachedRequestServiceContexts = new HashMap();
        }
        return this.getServiceContext(this.cachedRequestServiceContexts, this.request.getRequestServiceContexts(), id);
    }

    @Override
    public ServiceContext get_reply_service_context(int id) {
        this.checkAccess(13);
        if (this.cachedReplyServiceContexts == null) {
            this.cachedReplyServiceContexts = new HashMap();
        }
        return this.getServiceContext(this.cachedReplyServiceContexts, this.replyMessage.getServiceContexts(), id);
    }

    private void enqueue(AddReplyServiceContextCommand addReply) {
        int size = this.addReplyServiceContextQueue.size();
        boolean found = false;
        for (int i = 0; i < size; ++i) {
            AddReplyServiceContextCommand cmd = this.addReplyServiceContextQueue.get(i);
            if (cmd.service_context.context_id != addReply.service_context.context_id) continue;
            found = true;
            if (addReply.replace) {
                this.addReplyServiceContextQueue.set(i, addReply);
                break;
            }
            throw this.stdWrapper.serviceContextAddFailed(cmd.service_context.context_id);
        }
        if (!found) {
            this.addReplyServiceContextQueue.add(addReply);
        }
    }

    @Override
    protected void setCurrentExecutionPoint(int executionPoint) {
        super.setCurrentExecutionPoint(executionPoint);
        if (executionPoint == 2 && this.addReplyServiceContextQueue != null) {
            int size = this.addReplyServiceContextQueue.size();
            for (int i = 0; i < size; ++i) {
                AddReplyServiceContextCommand addReply = this.addReplyServiceContextQueue.get(i);
                try {
                    this.add_reply_service_context(addReply.service_context, addReply.replace);
                    continue;
                }
                catch (BAD_INV_ORDER e) {
                    // empty catch block
                }
            }
        }
    }

    protected void setInfo(CorbaMessageMediator request, ObjectAdapter oa, byte[] objectId, ObjectKeyTemplate oktemp) {
        this.request = request;
        this.objectId = objectId;
        this.oktemp = oktemp;
        this.objectAdapter = oa;
        this.connection = (Connection)((java.lang.Object)request.getConnection());
    }

    protected void setDSIArguments(NVList arguments) {
        this.dsiArguments = arguments;
    }

    protected void setDSIException(Any exception) {
        this.dsiException = exception;
        this.cachedSendingException = null;
    }

    protected void setDSIResult(Any result) {
        this.dsiResult = result;
    }

    @Override
    protected void setException(Exception exception) {
        super.setException(exception);
        this.dsiException = null;
        this.cachedSendingException = null;
    }

    protected void setInfo(java.lang.Object servant, String targetMostDerivedInterface) {
        this.servant = servant;
        this.targetMostDerivedInterface = targetMostDerivedInterface;
        this.isDynamic = servant instanceof DynamicImplementation || servant instanceof org.omg.CORBA.DynamicImplementation;
    }

    void setReplyMessage(ReplyMessage replyMessage) {
        this.replyMessage = replyMessage;
    }

    @Override
    protected void setReplyStatus(short replyStatus) {
        super.setReplyStatus(replyStatus);
        switch (replyStatus) {
            case 0: {
                this.endingPointCall = 0;
                break;
            }
            case 1: 
            case 2: {
                this.endingPointCall = 1;
                break;
            }
            case 3: 
            case 4: {
                this.endingPointCall = 2;
            }
        }
    }

    void releaseServant() {
        this.servant = null;
    }

    void setForwardRequestRaisedInEnding() {
        this.forwardRequestRaisedInEnding = true;
    }

    boolean isForwardRequestRaisedInEnding() {
        return this.forwardRequestRaisedInEnding;
    }

    boolean isDynamic() {
        return this.isDynamic;
    }

    @Override
    protected void checkAccess(int methodID) {
        int validCallIndex = 0;
        block0 : switch (this.currentExecutionPoint) {
            case 0: {
                validCallIndex = 0;
                break;
            }
            case 1: {
                validCallIndex = 1;
                break;
            }
            case 2: {
                switch (this.endingPointCall) {
                    case 0: {
                        validCallIndex = 2;
                        break block0;
                    }
                    case 1: {
                        validCallIndex = 3;
                        break block0;
                    }
                    case 2: {
                        validCallIndex = 4;
                    }
                }
            }
        }
        if (!validCall[methodID][validCallIndex]) {
            throw this.stdWrapper.invalidPiCall2();
        }
    }

    private class AddReplyServiceContextCommand {
        ServiceContext service_context;
        boolean replace;

        private AddReplyServiceContextCommand() {
        }
    }
}

