/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.newtimer;

import com.sun.corba.ee.spi.orbutil.newtimer.TimerEventController;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerFactory;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerFactoryBuilder;

public class TimerManager<T> {
    private TimerFactory tf;
    private T tp;
    private volatile TimerEventController controller;
    private boolean isInitialized = false;

    public TimerManager(String name) {
        this.tf = TimerFactoryBuilder.make(name, name);
        this.controller = this.tf.makeController(name);
    }

    public void destroy() {
        TimerFactoryBuilder.destroy(this.tf);
    }

    private void checkInitialized() {
        if (!this.isInitialized) {
            throw new IllegalStateException("TimerManager is not initialized");
        }
    }

    public void initialize(T tp) {
        if (this.isInitialized) {
            throw new IllegalStateException("TimerManager is already initialized");
        }
        this.tp = tp;
        this.isInitialized = true;
    }

    public T points() {
        this.checkInitialized();
        return this.tp;
    }

    public TimerFactory factory() {
        return this.tf;
    }

    public TimerEventController controller() {
        return this.controller;
    }
}

