/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.pept.transport.Connection;
import com.sun.corba.ee.pept.transport.ReaderThread;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.threadpool.Work;

public class ReaderThreadImpl
implements ReaderThread,
Work {
    private ORB orb;
    private Connection connection;
    private boolean keepRunning;
    private long enqueueTime;
    private ORBUtilSystemException wrapper;

    public ReaderThreadImpl(ORB orb, Connection connection) {
        this.orb = orb;
        this.connection = connection;
        this.keepRunning = true;
        this.wrapper = orb.getLogWrapperTable().get_RPC_TRANSPORT_ORBUtil();
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public synchronized void close() {
        if (this.orb.transportDebugFlag) {
            this.dprint(".close: " + this.connection);
        }
        this.keepRunning = false;
        this.connection.close();
    }

    private synchronized boolean isRunning() {
        return this.keepRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWork() {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: Start ReaderThread: " + this.connection);
            }
            while (this.isRunning()) {
                block14: {
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".doWork: Start ReaderThread cycle: " + this.connection);
                    }
                    if (!this.connection.read()) break block14;
                    return;
                }
                try {
                    if (!this.orb.transportDebugFlag) continue;
                    this.dprint(".doWork: End ReaderThread cycle: " + this.connection);
                }
                catch (Throwable t) {
                    this.wrapper.exceptionInReaderThread(t);
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".doWork: exception in read: " + this.connection, t);
                    }
                    this.orb.getTransportManager().getSelector(0).unregisterForEvent(this.getConnection().getEventHandler());
                    try {
                        if (!this.isRunning()) continue;
                        this.getConnection().close();
                    }
                    catch (Exception exc) {
                        this.wrapper.ioExceptionOnClose(exc);
                    }
                }
            }
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: Terminated ReaderThread: " + this.connection);
            }
        }
    }

    @Override
    public void setEnqueueTime(long timeInMillis) {
        this.enqueueTime = timeInMillis;
    }

    @Override
    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    @Override
    public String getName() {
        return "ReaderThread";
    }

    private void dprint(String msg) {
        ORBUtility.dprint("ReaderThreadImpl", msg);
    }

    protected void dprint(String msg, Throwable t) {
        this.dprint(msg);
        t.printStackTrace(System.out);
    }
}

