/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.encoding.BufferManagerWrite;
import com.sun.corba.ee.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.ee.impl.encoding.CDROutputObject;
import com.sun.corba.ee.impl.protocol.CorbaInvocationInfo;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.FragmentMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.ee.pept.encoding.OutputObject;
import com.sun.corba.ee.pept.transport.Connection;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.CorbaContactInfoListIterator;
import java.util.EmptyStackException;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.RemarshalException;
import sun.corba.Bridge;

public class BufferManagerWriteStream
extends BufferManagerWrite {
    private int fragmentCount = 0;

    BufferManagerWriteStream(ORB orb) {
        super(orb);
    }

    @Override
    public boolean sentFragment() {
        return this.fragmentCount > 0;
    }

    @Override
    public int getBufferSize() {
        return this.orb.getORBData().getGIOPFragmentSize();
    }

    @Override
    public void overflow(ByteBufferWithInfo bbwi) {
        MessageBase.setFlag(bbwi.getByteBuffer(), 2);
        try {
            this.sendFragment(false);
        }
        catch (SystemException se) {
            CorbaContactInfoListIterator itr;
            try {
                itr = this.getContactInfoListIterator();
            }
            catch (EmptyStackException ese) {
                throw se;
            }
            this.orb.getPIHandler().invokeClientPIEndingPoint(2, (Exception)((Object)se));
            boolean retry = itr.reportException(null, (RuntimeException)((Object)se));
            if (retry) {
                Bridge bridge = Bridge.get();
                bridge.throwException((Throwable)new RemarshalException());
            }
            throw se;
        }
        bbwi.position(0);
        bbwi.setLength(bbwi.getCapacity());
        bbwi.setFragmented(true);
        FragmentMessage header = ((CDROutputObject)this.outputObject).getMessageHeader().createFragmentMessage();
        header.write((OutputStream)((CDROutputObject)this.outputObject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFragment(boolean isLastFragment) {
        Connection conn = ((OutputObject)this.outputObject).getMessageMediator().getConnection();
        conn.writeLock();
        try {
            conn.sendWithoutLock((OutputObject)this.outputObject);
            ++this.fragmentCount;
        }
        finally {
            conn.writeUnlock();
        }
    }

    @Override
    public void sendMessage() {
        this.sendFragment(true);
        this.sentFullMessage = true;
    }

    @Override
    public void close() {
    }

    protected CorbaContactInfoListIterator getContactInfoListIterator() {
        return (CorbaContactInfoListIterator)((CorbaInvocationInfo)this.orb.getInvocationInfo()).getContactInfoListIterator();
    }
}

