/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.encoding.BufferManagerFactory;
import com.sun.corba.ee.impl.encoding.BufferManagerWrite;
import com.sun.corba.ee.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.ee.impl.encoding.CodeSetComponentInfo;
import com.sun.corba.ee.impl.encoding.CodeSetConversion;
import com.sun.corba.ee.impl.encoding.OSFCodeSetRegistry;
import com.sun.corba.ee.impl.logging.OMGSystemException;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.ee.impl.transport.MessageTraceManagerImpl;
import com.sun.corba.ee.pept.protocol.MessageMediator;
import com.sun.corba.ee.spi.encoding.CorbaOutputObject;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.protocol.CorbaMessageMediator;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import com.sun.corba.ee.spi.transport.CorbaTransportManager;
import java.io.IOException;
import org.omg.CORBA.portable.InputStream;

public class CDROutputObject
extends CorbaOutputObject {
    private Message header;
    private ORB orb;
    private ORBUtilSystemException wrapper;
    private OMGSystemException omgWrapper;
    private CorbaConnection connection;

    private CDROutputObject(ORB orb, GIOPVersion giopVersion, Message header, BufferManagerWrite manager, byte streamFormatVersion, CorbaMessageMediator mediator) {
        super(orb, giopVersion, header.getEncodingVersion(), false, manager, streamFormatVersion, mediator != null && mediator.getConnection() != null ? ((CorbaConnection)mediator.getConnection()).shouldUseDirectByteBuffers() : false);
        this.header = header;
        this.orb = orb;
        this.wrapper = orb.getLogWrapperTable().get_RPC_ENCODING_ORBUtil();
        this.omgWrapper = orb.getLogWrapperTable().get_RPC_ENCODING_OMG();
        this.getBufferManager().setOutputObject(this);
        this.corbaMessageMediator = mediator;
    }

    public CDROutputObject(ORB orb, MessageMediator messageMediator, Message header, byte streamFormatVersion) {
        this(orb, ((CorbaMessageMediator)messageMediator).getGIOPVersion(), header, BufferManagerFactory.newBufferManagerWrite(((CorbaMessageMediator)messageMediator).getGIOPVersion(), header.getEncodingVersion(), orb), streamFormatVersion, (CorbaMessageMediator)messageMediator);
    }

    public CDROutputObject(ORB orb, MessageMediator messageMediator, Message header, byte streamFormatVersion, int strategy) {
        this(orb, ((CorbaMessageMediator)messageMediator).getGIOPVersion(), header, BufferManagerFactory.newBufferManagerWrite(strategy, header.getEncodingVersion(), orb), streamFormatVersion, (CorbaMessageMediator)messageMediator);
    }

    public CDROutputObject(ORB orb, CorbaMessageMediator mediator, GIOPVersion giopVersion, CorbaConnection connection, Message header, byte streamFormatVersion) {
        this(orb, giopVersion, header, BufferManagerFactory.newBufferManagerWrite(giopVersion, header.getEncodingVersion(), orb), streamFormatVersion, mediator);
        this.connection = connection;
    }

    public Message getMessageHeader() {
        return this.header;
    }

    public final void finishSendingMessage() {
        this.getBufferManager().sendMessage();
    }

    @Override
    public void writeTo(CorbaConnection connection) throws IOException {
        ByteBufferWithInfo bbwi = this.getByteBufferWithInfo();
        this.getMessageHeader().setSize(bbwi.getByteBuffer(), bbwi.getSize());
        ORB orb = (ORB)this.orb();
        if (orb != null) {
            CorbaTransportManager ctm;
            MessageTraceManagerImpl mtm;
            if (orb.transportDebugFlag) {
                this.dprint(".writeTo: " + connection);
            }
            if (orb.giopDebugFlag) {
                ORBUtility.printBuffer("CDROutputObject Buffer", bbwi.getByteBuffer(), System.out);
            }
            if ((mtm = (MessageTraceManagerImpl)(ctm = (CorbaTransportManager)orb.getTransportManager()).getMessageTraceManager()).isEnabled()) {
                mtm.recordDataSent(bbwi.getByteBuffer());
            }
        }
        bbwi.flip();
        connection.write(bbwi.getByteBuffer());
    }

    @Override
    public InputStream create_input_stream() {
        return null;
    }

    public CorbaConnection getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        return (CorbaConnection)this.corbaMessageMediator.getConnection();
    }

    @Override
    public final ByteBufferWithInfo getByteBufferWithInfo() {
        return super.getByteBufferWithInfo();
    }

    @Override
    public final void setByteBufferWithInfo(ByteBufferWithInfo bbwi) {
        super.setByteBufferWithInfo(bbwi);
    }

    @Override
    protected CodeSetConversion.CTBConverter createCharCTBConverter() {
        CodeSetComponentInfo.CodeSetContext codesets = this.getCodeSets();
        if (codesets == null) {
            return super.createCharCTBConverter();
        }
        OSFCodeSetRegistry.Entry charSet = OSFCodeSetRegistry.lookupEntry(codesets.getCharCodeSet());
        if (charSet == null) {
            throw this.wrapper.unknownCodeset(charSet);
        }
        return CodeSetConversion.impl().getCTBConverter(charSet, this.isLittleEndian(), false);
    }

    @Override
    protected CodeSetConversion.CTBConverter createWCharCTBConverter() {
        CodeSetComponentInfo.CodeSetContext codesets = this.getCodeSets();
        if (codesets == null) {
            if (this.getConnection().isServer()) {
                throw this.omgWrapper.noClientWcharCodesetCtx();
            }
            throw this.omgWrapper.noServerWcharCodesetCmp();
        }
        OSFCodeSetRegistry.Entry wcharSet = OSFCodeSetRegistry.lookupEntry(codesets.getWCharCodeSet());
        if (wcharSet == null) {
            throw this.wrapper.unknownCodeset(wcharSet);
        }
        boolean useByteOrderMarkers = ((ORB)this.orb()).getORBData().useByteOrderMarkers();
        if (wcharSet == OSFCodeSetRegistry.UTF_16) {
            if (this.getGIOPVersion().equals(GIOPVersion.V1_2)) {
                return CodeSetConversion.impl().getCTBConverter(wcharSet, false, useByteOrderMarkers);
            }
            if (this.getGIOPVersion().equals(GIOPVersion.V1_1)) {
                return CodeSetConversion.impl().getCTBConverter(wcharSet, this.isLittleEndian(), false);
            }
        }
        return CodeSetConversion.impl().getCTBConverter(wcharSet, this.isLittleEndian(), useByteOrderMarkers);
    }

    private CodeSetComponentInfo.CodeSetContext getCodeSets() {
        if (this.getConnection() == null) {
            return CodeSetComponentInfo.LOCAL_CODE_SETS;
        }
        return this.getConnection().getCodeSetContext();
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("CDROutputObject", msg);
    }
}

