/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.oa.rfm;

import com.sun.corba.ee.impl.logging.POASystemException;
import com.sun.corba.ee.impl.oa.rfm.ReferenceFactoryImpl;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.spi.oa.ObjectAdapter;
import com.sun.corba.ee.spi.oa.rfm.ReferenceFactory;
import com.sun.corba.ee.spi.oa.rfm.ReferenceFactoryManager;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.generic.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.AdapterActivator;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantManager;
import org.omg.PortableServer.ServantRetentionPolicyValue;

public class ReferenceFactoryManagerImpl
extends LocalObject
implements ReferenceFactoryManager {
    private static final String PARENT_POA_NAME = "#INTERNAL#ReferenceFactoryManagerBase#INTERNAL#";
    private RFMState state;
    private ReentrantLock lock = new ReentrantLock();
    private Condition suspendCondition = this.lock.newCondition();
    private ORB orb;
    private POASystemException wrapper;
    private Map<String, Pair<ServantLocator, List<Policy>>> poatable;
    private Map<String, ReferenceFactory> factories;
    private volatile boolean isActive;
    private POA rootPOA;
    private List<Policy> standardPolicies;
    private POA parentPOA;
    private String[] parentPOAAdapterName;
    private POAManager manager;
    private AdapterActivator activator;

    public ReferenceFactoryManagerImpl(ORB orb) {
        this.state = RFMState.READY;
        this.orb = orb;
        this.wrapper = orb.getLogWrapperTable().get_OA_LIFECYCLE_POA();
        this.poatable = new HashMap<String, Pair<ServantLocator, List<Policy>>>();
        this.factories = new HashMap<String, ReferenceFactory>();
        this.isActive = false;
    }

    @Override
    public State getState() {
        return this.manager.get_state();
    }

    @Override
    public void activate() {
        this.dprint(".activate->:");
        this.lock.lock();
        try {
            if (this.isActive) {
                throw this.wrapper.rfmNotActive();
            }
            this.rootPOA = (POA)this.orb.resolve_initial_references("RootPOA");
            this.standardPolicies = Arrays.asList(ReferenceManagerPolicy.getPolicy(), this.rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), this.rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER), this.rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT));
            Policy[] policies = new Policy[]{ReferenceManagerPolicy.getPolicy()};
            this.parentPOA = this.rootPOA.create_POA(PARENT_POA_NAME, null, policies);
            this.parentPOAAdapterName = ((ObjectAdapter)ObjectAdapter.class.cast(this.parentPOA)).getIORTemplate().getObjectKeyTemplate().getObjectAdapterId().getAdapterName();
            this.manager = this.parentPOA.the_POAManager();
            this.activator = new AdapterActivatorImpl();
            this.parentPOA.the_activator(this.activator);
            this.manager.activate();
            this.isActive = true;
        }
        catch (Exception exc) {
            throw this.wrapper.rfmActivateFailed(exc);
        }
        finally {
            this.lock.unlock();
            this.dprint(".activate<-:");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceFactory create(String name, String repositoryId, List<Policy> policies, ServantLocator manager) {
        this.dprint(".create->:");
        this.lock.lock();
        try {
            if (this.state == RFMState.SUSPENDED) {
                throw this.wrapper.rfmMightDeadlock();
            }
            if (!this.isActive) {
                throw this.wrapper.rfmNotActive();
            }
            ArrayList<Policy> newPolicies = null;
            if (policies != null) {
                newPolicies = new ArrayList<Policy>(policies);
            }
            Map<String, Pair<ServantLocator, List<Policy>>> map = this.poatable;
            synchronized (map) {
                this.poatable.put(name, (Pair<ServantLocator, List<Policy>>)new Pair((java.lang.Object)manager, newPolicies));
            }
            ReferenceFactoryImpl factory = new ReferenceFactoryImpl(this, name, repositoryId);
            this.factories.put(name, factory);
            ReferenceFactoryImpl referenceFactoryImpl = factory;
            return referenceFactoryImpl;
        }
        finally {
            this.lock.unlock();
            this.dprint(".create<-:");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceFactory find(String[] adapterName) {
        this.dprint(".find->:");
        this.lock.lock();
        try {
            if (this.state == RFMState.SUSPENDED) {
                throw this.wrapper.rfmMightDeadlock();
            }
            if (!this.isActive) {
                ReferenceFactory referenceFactory = null;
                return referenceFactory;
            }
            int expectedLength = this.parentPOAAdapterName.length + 1;
            if (expectedLength != adapterName.length) {
                ReferenceFactory referenceFactory = null;
                return referenceFactory;
            }
            for (int ctr = 0; ctr < expectedLength - 1; ++ctr) {
                if (adapterName[ctr].equals(this.parentPOAAdapterName[ctr])) continue;
                ReferenceFactory referenceFactory = null;
                return referenceFactory;
            }
            ReferenceFactory referenceFactory = this.factories.get(adapterName[expectedLength - 1]);
            return referenceFactory;
        }
        finally {
            this.lock.unlock();
            this.dprint(".find<-:");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceFactory find(String name) {
        this.lock.lock();
        try {
            if (this.state == RFMState.SUSPENDED) {
                throw this.wrapper.rfmMightDeadlock();
            }
            if (!this.isActive) {
                ReferenceFactory referenceFactory = null;
                return referenceFactory;
            }
            ReferenceFactory referenceFactory = this.factories.get(name);
            return referenceFactory;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend() {
        try {
            this.dprint(".suspend->:");
            this.lock.lock();
            try {
                if (!this.isActive) {
                    throw this.wrapper.rfmNotActive();
                }
                while (this.state == RFMState.SUSPENDED) {
                    try {
                        this.suspendCondition.await();
                    }
                    catch (InterruptedException exc) {
                        throw this.wrapper.rfmSuspendConditionWaitInterrupted();
                    }
                }
                this.state = RFMState.SUSPENDED;
            }
            finally {
                this.lock.unlock();
            }
            try {
                this.manager.hold_requests(true);
            }
            catch (AdapterInactive ai) {
                throw this.wrapper.rfmManagerInactive(ai);
            }
        }
        finally {
            this.dprint(".suspend<-:");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        try {
            this.dprint(".resume->:");
            this.lock.lock();
            try {
                if (!this.isActive) {
                    throw this.wrapper.rfmNotActive();
                }
                this.state = RFMState.READY;
                this.suspendCondition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
            try {
                this.manager.activate();
            }
            catch (AdapterInactive ai) {
                throw this.wrapper.rfmManagerInactive(ai);
            }
        }
        finally {
            this.dprint(".resume<-:");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartFactories(Map<String, Pair<ServantLocator, List<Policy>>> updates) {
        this.lock.lock();
        try {
            if (!this.isActive) {
                throw this.wrapper.rfmNotActive();
            }
            if (this.state != RFMState.SUSPENDED) {
                throw this.wrapper.rfmMethodRequiresSuspendedState("restartFactories");
            }
        }
        finally {
            this.lock.unlock();
        }
        try {
            this.dprint(".restartFactories->:");
            if (updates == null) {
                throw this.wrapper.rfmNullArgRestart();
            }
            Map<String, Pair<ServantLocator, List<Policy>>> map = this.poatable;
            synchronized (map) {
                this.poatable.putAll(updates);
            }
            try {
                for (POA poa : this.parentPOA.the_children()) {
                    poa.destroy(false, true);
                }
            }
            catch (Exception exc) {
                throw this.wrapper.rfmRestartFailed(exc);
            }
        }
        finally {
            this.dprint(".restartFactories<-:");
        }
    }

    @Override
    public void restartFactories() {
        this.restartFactories(new HashMap<String, Pair<ServantLocator, List<Policy>>>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restart(Map<String, Pair<ServantLocator, List<Policy>>> updates) {
        try {
            this.dprint(".restart->:");
            this.suspend();
            try {
                this.restartFactories(updates);
            }
            finally {
                this.resume();
            }
        }
        finally {
            this.dprint(".restart<-:");
        }
    }

    @Override
    public void restart() {
        this.restart(new HashMap<String, Pair<ServantLocator, List<Policy>>>());
    }

    Object createReference(String name, byte[] key, String repositoryId) {
        this.dprint(".createReference->: " + name);
        try {
            POA child = this.parentPOA.find_POA(name, true);
            Object object = child.create_reference_with_id(key, repositoryId);
            return object;
        }
        catch (Exception exc) {
            throw this.wrapper.rfmCreateReferenceFailed(exc);
        }
        finally {
            this.dprint(".createReference<-: " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy(String name) {
        this.dprint(".destroy->: " + name);
        try {
            try {
                POA child = this.parentPOA.find_POA(name, true);
                Map<String, Pair<ServantLocator, List<Policy>>> map = this.poatable;
                synchronized (map) {
                    this.poatable.remove(name);
                }
                this.lock.lock();
                try {
                    this.factories.remove(name);
                }
                finally {
                    this.lock.unlock();
                }
                child.destroy(false, true);
            }
            catch (Exception exc) {
                throw this.wrapper.rfmDestroyFailed(exc);
            }
        }
        finally {
            this.dprint(".destroy<-: " + name);
        }
    }

    void validatePOACreation(POA poa) {
        if (!this.isActive) {
            return;
        }
        Policy policy = ((ObjectAdapter)ObjectAdapter.class.cast(poa)).getEffectivePolicy(1398079492);
        if (policy != null) {
            return;
        }
        POA parent = poa.the_parent();
        Policy parentPolicy = ((ObjectAdapter)ObjectAdapter.class.cast(parent)).getEffectivePolicy(1398079492);
        if (parentPolicy != null) {
            throw this.wrapper.rfmIllegalParentPoaUsage();
        }
        if (poa.the_POAManager() == this.manager) {
            throw this.wrapper.rfmIllegalPoaManagerUsage();
        }
    }

    private void dprint(String msg) {
        if (this.orb.poaDebugFlag) {
            ORBUtility.dprint("ReferenceFactoryManagerImpl", msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRfmName(String[] adapterName) {
        try {
            this.dprint(".isRfmName->:");
            if (!this.isActive) {
                boolean bl = false;
                return bl;
            }
            int expectedLength = this.parentPOAAdapterName.length + 1;
            if (expectedLength != adapterName.length) {
                boolean bl = false;
                return bl;
            }
            for (int ctr = 0; ctr < expectedLength - 1; ++ctr) {
                if (adapterName[ctr].equals(this.parentPOAAdapterName[ctr])) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.dprint(".isRfmName<-:");
        }
    }

    static /* synthetic */ POASystemException access$500(ReferenceFactoryManagerImpl x0) {
        return x0.wrapper;
    }

    private static class ReferenceManagerPolicy
    extends LocalObject
    implements Policy {
        private static Policy thisPolicy = new ReferenceManagerPolicy();

        public static Policy getPolicy() {
            return thisPolicy;
        }

        private ReferenceManagerPolicy() {
        }

        public int policy_type() {
            return 1398079492;
        }

        public Policy copy() {
            return this;
        }

        public void destroy() {
        }
    }

    private class AdapterActivatorImpl
    extends LocalObject
    implements AdapterActivator {
        private AdapterActivatorImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean unknown_adapter(POA parent, String name) {
            ReferenceFactoryManagerImpl.this.dprint(".unknown_adapter->: " + parent + " " + name);
            try {
                Pair data = null;
                Map map = ReferenceFactoryManagerImpl.this.poatable;
                synchronized (map) {
                    data = (Pair)ReferenceFactoryManagerImpl.this.poatable.get(name);
                }
                if (data == null) {
                    boolean bl = false;
                    return bl;
                }
                ArrayList policies = new ArrayList();
                if (data.second() != null) {
                    policies.addAll((Collection)data.second());
                }
                policies.addAll(ReferenceFactoryManagerImpl.this.standardPolicies);
                Policy[] arr = policies.toArray(new Policy[policies.size()]);
                POA child = ReferenceFactoryManagerImpl.this.parentPOA.create_POA(name, ReferenceFactoryManagerImpl.this.manager, arr);
                child.set_servant_manager((ServantManager)data.first());
                boolean bl = true;
                return bl;
            }
            finally {
                ReferenceFactoryManagerImpl.this.dprint(".unknown_adapter<-: " + parent + " " + name);
            }
        }
    }

    private static enum RFMState {
        READY,
        SUSPENDED;

    }
}

