/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.transport.CorbaConnectionCacheBase;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.CorbaAcceptor;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import com.sun.corba.ee.spi.transport.CorbaInboundConnectionCache;
import java.util.ArrayList;
import java.util.Collection;
import org.glassfish.external.probe.provider.annotations.Probe;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.probe.provider.annotations.ProbeProvider;

@ProbeProvider(providerName="glassfish", moduleName="orb")
public class CorbaInboundConnectionCacheImpl
extends CorbaConnectionCacheBase
implements CorbaInboundConnectionCache {
    protected Collection<CorbaConnection> connectionCache = new ArrayList<CorbaConnection>();

    @Probe(providerName="inboundConnectionOpened")
    public void connectionOpenedEvent(@ProbeParam(value="acceptor") String acceptor, @ProbeParam(value="connection") String connection) {
    }

    @Probe(providerName="inboundConnectionClosed")
    public void connectionClosedEvent(@ProbeParam(value="connection") String connection) {
    }

    public CorbaInboundConnectionCacheImpl(ORB orb, CorbaAcceptor acceptor) {
        super(orb, acceptor.getConnectionCacheType(), acceptor.getMonitoringName());
    }

    @Override
    public CorbaConnection get(CorbaAcceptor acceptor) {
        throw this.wrapper.methodShouldNotBeCalled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(CorbaAcceptor acceptor, CorbaConnection connection) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".put: " + acceptor + " " + connection);
        }
        Object object = this.backingStore();
        synchronized (object) {
            this.connectionCache.add(connection);
            connection.setConnectionCache(this);
            this.dprintStatistics();
            this.connectionOpenedEvent(acceptor.toString(), connection.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(CorbaConnection connection) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".remove: " + connection);
        }
        Object object = this.backingStore();
        synchronized (object) {
            this.connectionCache.remove(connection);
            this.dprintStatistics();
            this.connectionClosedEvent(connection.toString());
        }
    }

    @Override
    public Collection values() {
        return this.connectionCache;
    }

    @Override
    protected Object backingStore() {
        return this.connectionCache;
    }

    @Override
    protected void dprint(String msg) {
        ORBUtility.dprint("CorbaInboundConnectionCacheImpl", msg);
    }
}

