/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.threadpool.NoSuchThreadPoolException;
import com.sun.corba.ee.spi.orbutil.threadpool.NoSuchWorkQueueException;
import com.sun.corba.ee.spi.orbutil.threadpool.Work;
import com.sun.corba.ee.spi.transport.EventHandler;
import java.nio.channels.SelectionKey;

public abstract class EventHandlerBase
implements EventHandler {
    protected ORB orb;
    protected Work work;
    protected boolean useWorkerThreadForEvent;
    protected boolean useSelectThreadToWait;
    protected SelectionKey selectionKey;

    @Override
    public void setUseSelectThreadToWait(boolean x) {
        this.useSelectThreadToWait = x;
    }

    @Override
    public boolean shouldUseSelectThreadToWait() {
        return this.useSelectThreadToWait;
    }

    @Override
    public void setSelectionKey(SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
    }

    @Override
    public SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    @Override
    public void handleEvent() {
        if (this.orb.transportDebugFlag) {
            this.dprint(".handleEvent->: " + this);
        }
        this.getSelectionKey().interestOps(this.getSelectionKey().interestOps() & ~this.getInterestOps());
        if (this.shouldUseWorkerThreadForEvent()) {
            Exception throwable = null;
            try {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".handleEvent: addWork to pool: 0");
                }
                this.orb.getThreadPoolManager().getThreadPool(0).getWorkQueue(0).addWork(this.getWork());
            }
            catch (NoSuchThreadPoolException e) {
                throwable = e;
            }
            catch (NoSuchWorkQueueException e) {
                throwable = e;
            }
            if (throwable != null) {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".handleEvent: " + throwable);
                }
                throw this.orb.getLogWrapperTable().get_RPC_TRANSPORT_ORBUtil().noSuchThreadpoolOrQueue(throwable);
            }
        } else {
            if (this.orb.transportDebugFlag) {
                this.dprint(".handleEvent: doWork");
            }
            this.getWork().doWork();
        }
        if (this.orb.transportDebugFlag) {
            this.dprint(".handleEvent<-: " + this);
        }
    }

    @Override
    public boolean shouldUseWorkerThreadForEvent() {
        return this.useWorkerThreadForEvent;
    }

    @Override
    public void setUseWorkerThreadForEvent(boolean x) {
        this.useWorkerThreadForEvent = x;
    }

    @Override
    public void setWork(Work work) {
        this.work = work;
    }

    @Override
    public Work getWork() {
        return this.work;
    }

    private void dprint(String msg) {
        ORBUtility.dprint("EventHandlerBase", msg);
    }
}

