/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orb;

import com.sun.corba.ee.impl.dynamicany.DynAnyFactoryImpl;
import com.sun.corba.ee.impl.legacy.connection.SocketFactoryAcceptorImpl;
import com.sun.corba.ee.impl.legacy.connection.SocketFactoryContactInfoListImpl;
import com.sun.corba.ee.impl.legacy.connection.USLPort;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.transport.SocketOrChannelAcceptorImpl;
import com.sun.corba.ee.spi.activation.Activator;
import com.sun.corba.ee.spi.activation.ActivatorHelper;
import com.sun.corba.ee.spi.activation.EndPointInfo;
import com.sun.corba.ee.spi.activation.Locator;
import com.sun.corba.ee.spi.activation.LocatorHelper;
import com.sun.corba.ee.spi.copyobject.CopierManager;
import com.sun.corba.ee.spi.copyobject.CopyobjectDefaults;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.IORFactories;
import com.sun.corba.ee.spi.ior.IdentifiableFactoryFinder;
import com.sun.corba.ee.spi.ior.TaggedComponentFactoryFinder;
import com.sun.corba.ee.spi.ior.TaggedProfile;
import com.sun.corba.ee.spi.ior.TaggedProfileTemplate;
import com.sun.corba.ee.spi.ior.iiop.IIOPFactories;
import com.sun.corba.ee.spi.legacy.connection.LegacyServerSocketEndPointInfo;
import com.sun.corba.ee.spi.legacy.connection.ORBSocketFactory;
import com.sun.corba.ee.spi.oa.OADefault;
import com.sun.corba.ee.spi.oa.ObjectAdapterFactory;
import com.sun.corba.ee.spi.orb.DataCollector;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBConfigurator;
import com.sun.corba.ee.spi.orb.ORBData;
import com.sun.corba.ee.spi.orb.Operation;
import com.sun.corba.ee.spi.orb.OperationFactory;
import com.sun.corba.ee.spi.orb.ParserImplBase;
import com.sun.corba.ee.spi.orb.PropertyParser;
import com.sun.corba.ee.spi.orbutil.ORBConstants;
import com.sun.corba.ee.spi.orbutil.closure.Closure;
import com.sun.corba.ee.spi.orbutil.closure.ClosureFactory;
import com.sun.corba.ee.spi.orbutil.copyobject.ObjectCopierFactory;
import com.sun.corba.ee.spi.presentation.rmi.PresentationDefaults;
import com.sun.corba.ee.spi.protocol.CorbaClientRequestDispatcher;
import com.sun.corba.ee.spi.protocol.CorbaServerRequestDispatcher;
import com.sun.corba.ee.spi.protocol.LocalClientRequestDispatcherFactory;
import com.sun.corba.ee.spi.protocol.RequestDispatcherDefault;
import com.sun.corba.ee.spi.protocol.RequestDispatcherRegistry;
import com.sun.corba.ee.spi.resolver.LocalResolver;
import com.sun.corba.ee.spi.resolver.Resolver;
import com.sun.corba.ee.spi.resolver.ResolverDefault;
import com.sun.corba.ee.spi.servicecontext.ServiceContextDefaults;
import com.sun.corba.ee.spi.servicecontext.ServiceContextFactoryRegistry;
import com.sun.corba.ee.spi.transport.CorbaAcceptor;
import com.sun.corba.ee.spi.transport.CorbaContactInfoList;
import com.sun.corba.ee.spi.transport.CorbaContactInfoListFactory;
import com.sun.corba.ee.spi.transport.TransportDefault;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Iterator;
import org.omg.CORBA.CompletionStatus;

public class ORBConfiguratorImpl
implements ORBConfigurator {
    private ORBUtilSystemException wrapper;
    private static final int ORB_STREAM = 0;

    @Override
    public void configure(DataCollector collector, ORB orb) {
        ORB theOrb = orb;
        this.wrapper = orb.getLogWrapperTable().get_ORB_LIFECYCLE_ORBUtil();
        this.initObjectCopiers(theOrb);
        this.initIORFinders(theOrb);
        theOrb.setClientDelegateFactory(TransportDefault.makeClientDelegateFactory(theOrb));
        this.initializeTransport(theOrb);
        this.initializeNaming(theOrb);
        this.initServiceContextRegistry(theOrb);
        this.initRequestDispatcherRegistry(theOrb);
        this.registerInitialReferences(theOrb);
        this.persistentServerInitialization(theOrb);
        theOrb.setInvocationInterceptor(PresentationDefaults.getNullInvocationInterceptor());
        this.runUserConfigurators(collector, theOrb);
    }

    private void runUserConfigurators(DataCollector collector, ORB orb) {
        ConfigParser parser = new ConfigParser(orb);
        parser.init(collector);
        if (parser.userConfigurators != null) {
            for (int ctr = 0; ctr < parser.userConfigurators.length; ++ctr) {
                Class cls = parser.userConfigurators[ctr];
                try {
                    ORBConfigurator config = (ORBConfigurator)cls.newInstance();
                    config.configure(collector, orb);
                    continue;
                }
                catch (Exception exc) {
                    this.wrapper.userConfiguratorException(exc);
                }
            }
        }
    }

    private void persistentServerInitialization(ORB orb) {
        ORBData data = orb.getORBData();
        if (data.getServerIsORBActivated()) {
            try {
                Locator locator = LocatorHelper.narrow(orb.resolve_initial_references("ServerLocator"));
                Activator activator = ActivatorHelper.narrow(orb.resolve_initial_references("ServerActivator"));
                Collection<CorbaAcceptor> serverEndpoints = orb.getCorbaTransportManager().getAcceptors(null, null);
                EndPointInfo[] endpointList = new EndPointInfo[serverEndpoints.size()];
                Iterator<CorbaAcceptor> iterator = serverEndpoints.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    CorbaAcceptor n = iterator.next();
                    if (!(n instanceof LegacyServerSocketEndPointInfo)) continue;
                    LegacyServerSocketEndPointInfo ep = (LegacyServerSocketEndPointInfo)((Object)n);
                    int port = locator.getEndpoint(ep.getType());
                    if (port == -1 && (port = locator.getEndpoint("IIOP_CLEAR_TEXT")) == -1) {
                        throw new Exception("ORBD must support IIOP_CLEAR_TEXT");
                    }
                    ep.setLocatorPort(port);
                    endpointList[i++] = new EndPointInfo(ep.getType(), ep.getPort());
                }
                activator.registerEndpoints(data.getPersistentServerId(), data.getORBId(), endpointList);
            }
            catch (Exception ex) {
                throw this.wrapper.persistentServerInitError(CompletionStatus.COMPLETED_MAYBE, ex);
            }
        }
    }

    private void initializeTransport(final ORB orb) {
        ORBData od = orb.getORBData();
        CorbaContactInfoListFactory contactInfoListFactory = od.getCorbaContactInfoListFactory();
        CorbaAcceptor[] acceptors = od.getAcceptors();
        ORBSocketFactory legacySocketFactory = od.getLegacySocketFactory();
        USLPort[] uslPorts = od.getUserSpecifiedListenPorts();
        this.setLegacySocketFactoryORB(orb, legacySocketFactory);
        if (legacySocketFactory != null && contactInfoListFactory != null) {
            throw this.wrapper.socketFactoryAndContactInfoListAtSameTime();
        }
        if (acceptors.length != 0 && legacySocketFactory != null) {
            throw this.wrapper.acceptorsAndLegacySocketFactoryAtSameTime();
        }
        od.getSocketFactory().setORB(orb);
        if (legacySocketFactory != null) {
            contactInfoListFactory = new CorbaContactInfoListFactory(){

                @Override
                public void setORB(ORB orb2) {
                }

                @Override
                public CorbaContactInfoList create(IOR ior) {
                    return new SocketFactoryContactInfoListImpl(orb, ior);
                }
            };
        } else if (contactInfoListFactory != null) {
            contactInfoListFactory.setORB(orb);
        } else {
            contactInfoListFactory = TransportDefault.makeCorbaContactInfoListFactory(orb);
        }
        orb.setCorbaContactInfoListFactory(contactInfoListFactory);
        int port = -1;
        if (od.getORBServerPort() != 0) {
            port = od.getORBServerPort();
        } else if (od.getPersistentPortInitialized()) {
            port = od.getPersistentServerPort();
        } else if (acceptors.length == 0 && !od.noDefaultAcceptors()) {
            port = 0;
        }
        if (port != -1) {
            this.createAndRegisterAcceptor(orb, legacySocketFactory, port, "DEFAULT_ENDPOINT", "IIOP_CLEAR_TEXT");
        }
        for (int i = 0; i < acceptors.length; ++i) {
            orb.getCorbaTransportManager().registerAcceptor(acceptors[i]);
        }
        USLPort[] ports = od.getUserSpecifiedListenPorts();
        if (ports != null) {
            for (int i = 0; i < ports.length; ++i) {
                this.createAndRegisterAcceptor(orb, legacySocketFactory, ports[i].getPort(), "NO_NAME", ports[i].getType());
            }
        }
    }

    private void createAndRegisterAcceptor(ORB orb, ORBSocketFactory legacySocketFactory, int port, String name, String type) {
        SocketOrChannelAcceptorImpl acceptor = legacySocketFactory == null ? new SocketOrChannelAcceptorImpl(orb, port, name, type) : new SocketFactoryAcceptorImpl(orb, port, name, type);
        orb.getCorbaTransportManager().registerAcceptor(acceptor);
    }

    private void setLegacySocketFactoryORB(final ORB orb, final ORBSocketFactory legacySocketFactory) {
        if (legacySocketFactory == null) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstantiationException, IllegalAccessException {
                    try {
                        Method method = legacySocketFactory.getClass().getMethod("setORB", ORB.class);
                        method.invoke((Object)legacySocketFactory, orb);
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (IllegalAccessException e) {
                        RuntimeException rte = new RuntimeException();
                        rte.initCause(e);
                        throw rte;
                    }
                    catch (InvocationTargetException e) {
                        RuntimeException rte = new RuntimeException();
                        rte.initCause(e);
                        throw rte;
                    }
                    return null;
                }
            });
        }
        catch (Throwable t) {
            throw this.wrapper.unableToSetSocketFactoryOrb(t);
        }
    }

    private void initializeNaming(ORB orb) {
        LocalResolver localResolver = ResolverDefault.makeLocalResolver();
        orb.setLocalResolver(localResolver);
        Resolver bootResolver = ResolverDefault.makeBootstrapResolver(orb, orb.getORBData().getORBInitialHost(), orb.getORBData().getORBInitialPort());
        Operation urlOperation = ResolverDefault.makeINSURLOperation(orb, bootResolver);
        orb.setURLOperation(urlOperation);
        Resolver irResolver = ResolverDefault.makeORBInitRefResolver(urlOperation, orb.getORBData().getORBInitialReferences());
        Resolver dirResolver = ResolverDefault.makeORBDefaultInitRefResolver(urlOperation, orb.getORBData().getORBDefaultInitialReference());
        Resolver resolver = ResolverDefault.makeCompositeResolver(localResolver, ResolverDefault.makeCompositeResolver(irResolver, ResolverDefault.makeCompositeResolver(dirResolver, bootResolver)));
        orb.setResolver(resolver);
    }

    private void initServiceContextRegistry(ORB orb) {
        ServiceContextFactoryRegistry scr = orb.getServiceContextFactoryRegistry();
        scr.register(ServiceContextDefaults.makeUEInfoServiceContextFactory());
        scr.register(ServiceContextDefaults.makeCodeSetServiceContextFactory());
        scr.register(ServiceContextDefaults.makeSendingContextServiceContextFactory());
        scr.register(ServiceContextDefaults.makeORBVersionServiceContextFactory());
        scr.register(ServiceContextDefaults.makeMaxStreamFormatVersionServiceContextFactory());
    }

    private void registerInitialReferences(final ORB orb) {
        Closure closure = new Closure(){

            public Object evaluate() {
                return new DynAnyFactoryImpl(orb);
            }
        };
        Closure future = ClosureFactory.makeFuture((Closure)closure);
        orb.getLocalResolver().register("DynAnyFactory", future);
    }

    private void initObjectCopiers(ORB orb) {
        ObjectCopierFactory orbStream = CopyobjectDefaults.makeORBStreamObjectCopierFactory(orb);
        CopierManager cm = orb.getCopierManager();
        cm.setDefaultId(0);
        cm.registerObjectCopierFactory(orbStream, 0);
    }

    private void initIORFinders(ORB orb) {
        IdentifiableFactoryFinder<TaggedProfile> profFinder = orb.getTaggedProfileFactoryFinder();
        profFinder.registerFactory(IIOPFactories.makeIIOPProfileFactory());
        IdentifiableFactoryFinder<TaggedProfileTemplate> profTempFinder = orb.getTaggedProfileTemplateFactoryFinder();
        profTempFinder.registerFactory(IIOPFactories.makeIIOPProfileTemplateFactory());
        TaggedComponentFactoryFinder compFinder = orb.getTaggedComponentFactoryFinder();
        compFinder.registerFactory(IIOPFactories.makeCodeSetsComponentFactory());
        compFinder.registerFactory(IIOPFactories.makeJavaCodebaseComponentFactory());
        compFinder.registerFactory(IIOPFactories.makeORBTypeComponentFactory());
        compFinder.registerFactory(IIOPFactories.makeMaxStreamFormatVersionComponentFactory());
        compFinder.registerFactory(IIOPFactories.makeAlternateIIOPAddressComponentFactory());
        compFinder.registerFactory(IIOPFactories.makeRequestPartitioningComponentFactory());
        compFinder.registerFactory(IIOPFactories.makeJavaSerializationComponentFactory());
        compFinder.registerFactory(IIOPFactories.makeLoadBalancingComponentFactory());
        IORFactories.registerValueFactories(orb);
        orb.setObjectKeyFactory(IORFactories.makeObjectKeyFactory(orb));
    }

    private void initRequestDispatcherRegistry(ORB orb) {
        RequestDispatcherRegistry scr = orb.getRequestDispatcherRegistry();
        CorbaClientRequestDispatcher csub = RequestDispatcherDefault.makeClientRequestDispatcher();
        scr.registerClientRequestDispatcher(csub, 2);
        scr.registerClientRequestDispatcher(csub, 32);
        scr.registerClientRequestDispatcher(csub, ORBConstants.PERSISTENT_SCID);
        scr.registerClientRequestDispatcher(csub, 36);
        scr.registerClientRequestDispatcher(csub, ORBConstants.SC_PERSISTENT_SCID);
        scr.registerClientRequestDispatcher(csub, 40);
        scr.registerClientRequestDispatcher(csub, ORBConstants.IISC_PERSISTENT_SCID);
        scr.registerClientRequestDispatcher(csub, 44);
        scr.registerClientRequestDispatcher(csub, ORBConstants.MINSC_PERSISTENT_SCID);
        CorbaServerRequestDispatcher sd = RequestDispatcherDefault.makeServerRequestDispatcher(orb);
        scr.registerServerRequestDispatcher(sd, 2);
        scr.registerServerRequestDispatcher(sd, 32);
        scr.registerServerRequestDispatcher(sd, ORBConstants.PERSISTENT_SCID);
        scr.registerServerRequestDispatcher(sd, 36);
        scr.registerServerRequestDispatcher(sd, ORBConstants.SC_PERSISTENT_SCID);
        scr.registerServerRequestDispatcher(sd, 40);
        scr.registerServerRequestDispatcher(sd, ORBConstants.IISC_PERSISTENT_SCID);
        scr.registerServerRequestDispatcher(sd, 44);
        scr.registerServerRequestDispatcher(sd, ORBConstants.MINSC_PERSISTENT_SCID);
        orb.setINSDelegate(RequestDispatcherDefault.makeINSServerRequestDispatcher(orb));
        LocalClientRequestDispatcherFactory lcsf = RequestDispatcherDefault.makeJIDLLocalClientRequestDispatcherFactory(orb);
        scr.registerLocalClientRequestDispatcherFactory(lcsf, 2);
        lcsf = RequestDispatcherDefault.makePOALocalClientRequestDispatcherFactory(orb);
        scr.registerLocalClientRequestDispatcherFactory(lcsf, 32);
        scr.registerLocalClientRequestDispatcherFactory(lcsf, ORBConstants.PERSISTENT_SCID);
        lcsf = RequestDispatcherDefault.makeFullServantCacheLocalClientRequestDispatcherFactory(orb);
        scr.registerLocalClientRequestDispatcherFactory(lcsf, 36);
        scr.registerLocalClientRequestDispatcherFactory(lcsf, ORBConstants.SC_PERSISTENT_SCID);
        lcsf = RequestDispatcherDefault.makeInfoOnlyServantCacheLocalClientRequestDispatcherFactory(orb);
        scr.registerLocalClientRequestDispatcherFactory(lcsf, 40);
        scr.registerLocalClientRequestDispatcherFactory(lcsf, ORBConstants.IISC_PERSISTENT_SCID);
        lcsf = RequestDispatcherDefault.makeMinimalServantCacheLocalClientRequestDispatcherFactory(orb);
        scr.registerLocalClientRequestDispatcherFactory(lcsf, 44);
        scr.registerLocalClientRequestDispatcherFactory(lcsf, ORBConstants.MINSC_PERSISTENT_SCID);
        CorbaServerRequestDispatcher bootsd = RequestDispatcherDefault.makeBootstrapServerRequestDispatcher(orb);
        scr.registerServerRequestDispatcher(bootsd, "INIT");
        scr.registerServerRequestDispatcher(bootsd, "TINI");
        ObjectAdapterFactory oaf = OADefault.makeTOAFactory(orb);
        scr.registerObjectAdapterFactory(oaf, 2);
        oaf = OADefault.makePOAFactory(orb);
        scr.registerObjectAdapterFactory(oaf, 32);
        scr.registerObjectAdapterFactory(oaf, ORBConstants.PERSISTENT_SCID);
        scr.registerObjectAdapterFactory(oaf, 36);
        scr.registerObjectAdapterFactory(oaf, ORBConstants.SC_PERSISTENT_SCID);
        scr.registerObjectAdapterFactory(oaf, 40);
        scr.registerObjectAdapterFactory(oaf, ORBConstants.IISC_PERSISTENT_SCID);
        scr.registerObjectAdapterFactory(oaf, 44);
        scr.registerObjectAdapterFactory(oaf, ORBConstants.MINSC_PERSISTENT_SCID);
    }

    public static class ConfigParser
    extends ParserImplBase {
        private ORB orb;
        public Class[] userConfigurators = null;

        public ConfigParser(ORB orb) {
            this.orb = orb;
        }

        @Override
        public PropertyParser makeParser() {
            PropertyParser parser = new PropertyParser();
            Operation action = OperationFactory.compose(OperationFactory.suffixAction(), OperationFactory.classAction(this.orb.classNameResolver()));
            parser.addPrefix("com.sun.corba.ee.ORBUserConfigurators.", action, "userConfigurators", Class.class);
            return parser;
        }
    }
}

