/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import com.sun.corba.ee.spi.transport.CorbaConnectionCache;
import java.util.Collection;
import java.util.Iterator;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;

public abstract class CorbaConnectionCacheBase
implements CorbaConnectionCache {
    protected ORB orb;
    protected long timestamp = 0L;
    protected String cacheType;
    protected String monitoringName;
    protected ORBUtilSystemException wrapper;

    protected CorbaConnectionCacheBase(ORB orb, String cacheType, String monitoringName) {
        this.orb = orb;
        this.cacheType = cacheType;
        this.monitoringName = monitoringName;
        this.wrapper = orb.getLogWrapperTable().get_RPC_TRANSPORT_ORBUtil();
        this.dprintCreation();
    }

    @Override
    public String getCacheType() {
        return this.cacheType;
    }

    @Override
    public synchronized void stampTime(CorbaConnection c) {
        c.setTimeStamp(this.timestamp++);
    }

    private CountStatistic makeCountStat(String name, String desc, long value) {
        CountStatisticImpl result = new CountStatisticImpl(name, "count", desc);
        result.setCount(value);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CountStatistic numberOfConnections() {
        long count = 0L;
        Object object = this.backingStore();
        synchronized (object) {
            count = this.values().size();
        }
        return this.makeCountStat("TotalConnections".toLowerCase(), "Total number of connections in the connection cache", count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.backingStore();
        synchronized (object) {
            for (Object obj : this.values()) {
                ((CorbaConnection)obj).closeConnectionResources();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CountStatistic numberOfIdleConnections() {
        long count = 0L;
        Object object = this.backingStore();
        synchronized (object) {
            Iterator connections = this.values().iterator();
            while (connections.hasNext()) {
                if (((CorbaConnection)connections.next()).isBusy()) continue;
                ++count;
            }
        }
        return this.makeCountStat("ConnectionsIdle".toLowerCase(), "Number of connections in the connection cache that are idle", count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CountStatistic numberOfBusyConnections() {
        long count = 0L;
        Object object = this.backingStore();
        synchronized (object) {
            Iterator connections = this.values().iterator();
            while (connections.hasNext()) {
                if (!((CorbaConnection)connections.next()).isBusy()) continue;
                ++count;
            }
        }
        return this.makeCountStat("ConnectionsBusy".toLowerCase(), "Number of connections in the connection cache that are in use", count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean reclaim() {
        try {
            Object backingStore;
            long numberOfConnections = this.numberOfConnections().getCount();
            if (this.orb.transportDebugFlag) {
                this.dprint(".reclaim->: " + numberOfConnections + " (" + this.orb.getORBData().getHighWaterMark() + "/" + this.orb.getORBData().getNumberToReclaim() + ")");
            }
            if (numberOfConnections <= (long)this.orb.getORBData().getHighWaterMark()) {
                boolean bl = false;
                return bl;
            }
            Object object = backingStore = this.backingStore();
            synchronized (object) {
                for (int i = 0; i < this.orb.getORBData().getNumberToReclaim(); ++i) {
                    CorbaConnection toClose = null;
                    long lru = Long.MAX_VALUE;
                    for (CorbaConnection c : this.values()) {
                        if (c.isBusy() || c.getTimeStamp() >= lru) continue;
                        toClose = c;
                        lru = c.getTimeStamp();
                    }
                    if (toClose == null) {
                        boolean c = false;
                        return c;
                    }
                    try {
                        if (this.orb.transportDebugFlag) {
                            this.dprint(".reclaim: closing: " + toClose);
                        }
                        toClose.close();
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (this.orb.transportDebugFlag) {
                    this.dprint(".reclaim: connections reclaimed (" + (numberOfConnections - this.numberOfConnections().getCount()) + ")");
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".reclaim<-: " + this.numberOfConnections());
            }
        }
    }

    @Override
    public String getMonitoringName() {
        return this.monitoringName;
    }

    public abstract Collection values();

    protected abstract Object backingStore();

    protected void dprintCreation() {
        if (this.orb.transportDebugFlag) {
            this.dprint(".constructor: cacheType: " + this.getCacheType() + " monitoringName: " + this.getMonitoringName());
        }
    }

    protected void dprintStatistics() {
        if (this.orb.transportDebugFlag) {
            this.dprint(".stats: " + this.numberOfConnections() + "/total " + this.numberOfBusyConnections() + "/busy " + this.numberOfIdleConnections() + "/idle" + " (" + this.orb.getORBData().getHighWaterMark() + "/" + this.orb.getORBData().getNumberToReclaim() + ")");
        }
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("CorbaConnectionCacheBase", msg);
    }
}

