/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.codegen;

import com.sun.corba.ee.spi.orbutil.codegen.ImportList;
import com.sun.corba.ee.spi.orbutil.codegen.Type;
import com.sun.corba.ee.spi.orbutil.generic.Pair;
import com.sun.corba.ee.spi.orbutil.generic.UnaryVoidFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImportListImpl
implements ImportList {
    private Map<String, Type> imports = new HashMap<String, Type>();
    private Node root;
    private List<Pair<String, String>> sortedImports;

    public ImportListImpl() {
        this.clearRoot();
    }

    @Override
    public ImportList copy() {
        ImportListImpl result = new ImportListImpl();
        result.imports = new HashMap<String, Type>(this.imports);
        return result;
    }

    private void clearRoot() {
        this.root = null;
        this.sortedImports = null;
    }

    @Override
    public Type addImport(String name) {
        Type result = Type._class(name);
        this.addImport(result);
        return result;
    }

    @Override
    public void addImport(Type type) {
        String key = type.className();
        if (!this.imports.entrySet().contains(key)) {
            this.imports.put(key, type);
            this.clearRoot();
        }
    }

    @Override
    public boolean contains(String name) {
        Type type = Type._class(name);
        return this.contains(type);
    }

    @Override
    public boolean contains(Type type) {
        String key = type.className();
        Type importType = this.imports.get(key);
        if (importType == null) {
            return false;
        }
        return importType.equals(type);
    }

    @Override
    public Type lookup(String className) {
        return this.imports.get(className);
    }

    private void insertType(Type type) {
        String packageName = type.packageName();
        String[] packages = packageName.split("[.]");
        String className = type.className();
        Node current = this.root;
        for (String pkg : packages) {
            if (current.children() == null) {
                return;
            }
            Node next = current.find(pkg);
            if (next == null) {
                next = Node.makeListNode(pkg);
                current.add(next);
            }
            current = next;
        }
        Node classNode = current.find(className);
        if (classNode == null) {
            classNode = Node.makeTypeNode(className, type);
            current.add(classNode);
        }
    }

    private void updateRoot() {
        if (this.root != null) {
            return;
        }
        this.root = Node.makeListNode("");
        for (Type type : this.imports.values()) {
            this.insertType(type);
        }
        this.root.sort();
    }

    @Override
    public List<Pair<String, String>> getInOrderList() {
        if (this.sortedImports != null) {
            return this.sortedImports;
        }
        this.updateRoot();
        this.sortedImports = new ArrayList<Pair<String, String>>();
        UnaryVoidFunction<Node> fn = new UnaryVoidFunction<Node>(){

            public void evaluate(Node node) {
                Type type = node.type();
                if (type == null) {
                    return;
                }
                Pair pair = new Pair((Object)type.packageName(), (Object)type.className());
                ImportListImpl.this.sortedImports.add(pair);
            }
        };
        this.root.depthFirst(fn);
        return this.sortedImports;
    }

    private static abstract class Node
    implements Comparable<Node> {
        private final String name;

        private Node(String name) {
            this.name = name;
        }

        public final String name() {
            return this.name;
        }

        @Override
        public final int compareTo(Node node) {
            return this.name.compareTo(node.name());
        }

        public Type type() {
            return null;
        }

        public List<Node> children() {
            return null;
        }

        public void sort() {
        }

        public Node find(String name) {
            return null;
        }

        public void add(Node node) {
        }

        public void depthFirst(UnaryVoidFunction<Node> fn) {
            fn.evaluate((Object)this);
        }

        public static Node makeTypeNode(String name, final Type type) {
            return new Node(name){

                @Override
                public Type type() {
                    return type;
                }
            };
        }

        public static Node makeListNode(String name) {
            return new Node(name){
                final List<Node> children = new ArrayList<Node>();

                @Override
                public List<Node> children() {
                    return this.children;
                }

                @Override
                public void sort() {
                    Collections.sort(this.children);
                    for (Node node : this.children) {
                        node.sort();
                    }
                }

                @Override
                public Node find(String name) {
                    for (Node n : this.children) {
                        if (!n.name().equals(name)) continue;
                        return n;
                    }
                    return null;
                }

                @Override
                public void add(Node node) {
                    this.children.add(node);
                }

                @Override
                public void depthFirst(UnaryVoidFunction<Node> fn) {
                    for (Node node : this.children) {
                        node.depthFirst(fn);
                    }
                }
            };
        }
    }
}

