/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.interceptors;

import com.sun.corba.ee.impl.corba.RequestImpl;
import com.sun.corba.ee.impl.interceptors.ClientRequestInfoImpl;
import com.sun.corba.ee.impl.interceptors.CodecFactoryImpl;
import com.sun.corba.ee.impl.interceptors.InterceptorInvoker;
import com.sun.corba.ee.impl.interceptors.InterceptorList;
import com.sun.corba.ee.impl.interceptors.ORBInitInfoImpl;
import com.sun.corba.ee.impl.interceptors.PICurrent;
import com.sun.corba.ee.impl.interceptors.RequestInfoImpl;
import com.sun.corba.ee.impl.interceptors.ServerRequestInfoImpl;
import com.sun.corba.ee.impl.logging.InterceptorsSystemException;
import com.sun.corba.ee.impl.logging.OMGSystemException;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.DprintUtil;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.ReplyMessage;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.ObjectKeyTemplate;
import com.sun.corba.ee.spi.oa.ObjectAdapter;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.closure.ClosureFactory;
import com.sun.corba.ee.spi.protocol.CorbaMessageMediator;
import com.sun.corba.ee.spi.protocol.ForwardException;
import com.sun.corba.ee.spi.protocol.PIHandler;
import com.sun.corba.ee.spi.protocol.RetryType;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NVList;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.IOP.CodecFactory;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ObjectReferenceTemplate;
import org.omg.PortableInterceptor.PolicyFactory;

public class PIHandlerImpl
implements PIHandler {
    private ORB orb;
    private DprintUtil dputil = new DprintUtil(this);
    InterceptorsSystemException wrapper;
    ORBUtilSystemException orbutilWrapper;
    OMGSystemException omgWrapper;
    private int serverRequestIdCounter = 0;
    CodecFactory codecFactory = null;
    String[] arguments = null;
    private InterceptorList interceptorList;
    private boolean hasIORInterceptors;
    private boolean hasClientInterceptors;
    private boolean hasServerInterceptors;
    private InterceptorInvoker interceptorInvoker;
    private PICurrent current;
    private Map<Integer, PolicyFactory> policyFactoryTable;
    private static final short[] REPLY_MESSAGE_TO_PI_REPLY_STATUS = new short[]{0, 2, 1, 3, 3, 4};
    private ThreadLocal<RequestInfoStack<ClientRequestInfoImpl>> threadLocalClientRequestInfoStack = new ThreadLocal<RequestInfoStack<ClientRequestInfoImpl>>(){

        @Override
        protected RequestInfoStack<ClientRequestInfoImpl> initialValue() {
            return new RequestInfoStack<ClientRequestInfoImpl>();
        }
    };
    private ThreadLocal<RequestInfoStack<ServerRequestInfoImpl>> threadLocalServerRequestInfoStack = new ThreadLocal<RequestInfoStack<ServerRequestInfoImpl>>(){

        @Override
        protected RequestInfoStack<ServerRequestInfoImpl> initialValue() {
            return new RequestInfoStack<ServerRequestInfoImpl>();
        }
    };

    static String getReplyStatus(int piReplyStatus) {
        switch (piReplyStatus) {
            case 0: {
                return "SUCCESSFUL";
            }
            case 2: {
                return "USER_EXCEPTION";
            }
            case 1: {
                return "SYSTEM_EXCEPTION";
            }
            case 3: {
                return "LOCATION_FORWARD";
            }
            case 4: {
                return "TRANSPORT_RETRY";
            }
        }
        return "UNINITIALIZED";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        boolean debug = this.orb.interceptorDebugFlag;
        if (debug) {
            this.dputil.enter("close", new Object[0]);
        }
        try {
            this.orb = null;
            this.wrapper = null;
            this.orbutilWrapper = null;
            this.omgWrapper = null;
            this.codecFactory = null;
            this.arguments = null;
            this.interceptorList = null;
            this.interceptorInvoker = null;
            this.current = null;
            this.policyFactoryTable = null;
            this.threadLocalClientRequestInfoStack = null;
            this.threadLocalServerRequestInfoStack = null;
        }
        finally {
            if (debug) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PIHandlerImpl(ORB orb, String[] args) {
        if (orb.interceptorDebugFlag) {
            this.dputil.enter("<init>(ORB,String[])", new Object[0]);
        }
        try {
            this.orb = orb;
            this.wrapper = orb.getLogWrapperTable().get_RPC_PROTOCOL_Interceptors();
            this.orbutilWrapper = orb.getLogWrapperTable().get_RPC_PROTOCOL_ORBUtil();
            this.omgWrapper = orb.getLogWrapperTable().get_RPC_PROTOCOL_OMG();
            this.arguments = args;
            this.codecFactory = new CodecFactoryImpl((org.omg.CORBA.ORB)orb);
            this.interceptorList = new InterceptorList(this.wrapper);
            this.current = new PICurrent(orb);
            this.interceptorInvoker = new InterceptorInvoker(orb, this.interceptorList, this.current);
            orb.getLocalResolver().register("PICurrent", ClosureFactory.makeConstant((Object)((Object)this.current)));
            orb.getLocalResolver().register("CodecFactory", ClosureFactory.makeConstant((Object)this.codecFactory));
            this.hasClientInterceptors = true;
            this.hasServerInterceptors = true;
        }
        finally {
            if (orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("initialize", new Object[0]);
        }
        try {
            if (this.orb.getORBData().getORBInitializers() != null) {
                ORBInitInfoImpl orbInitInfo = this.createORBInitInfo();
                this.current.setORBInitializing(true);
                this.preInitORBInitializers(orbInitInfo);
                this.postInitORBInitializers(orbInitInfo);
                this.interceptorList.sortInterceptors();
                this.current.setORBInitializing(false);
                orbInitInfo.setStage(2);
                this.hasIORInterceptors = this.interceptorList.hasInterceptorsOfType(2);
                this.interceptorInvoker.setEnabled(true);
            }
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyInterceptors() {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("destroyInterceptors", new Object[0]);
        }
        try {
            this.interceptorList.destroyAll();
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void objectAdapterCreated(ObjectAdapter oa) {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("objectAdapterCreated", new Object[0]);
        }
        try {
            if (!this.hasIORInterceptors) {
                return;
            }
            this.interceptorInvoker.objectAdapterCreated(oa);
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adapterManagerStateChanged(int managerId, short newState) {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("adapterManagerStateChanged", new Object[0]);
        }
        try {
            if (!this.hasIORInterceptors) {
                return;
            }
            this.interceptorInvoker.adapterManagerStateChanged(managerId, newState);
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adapterStateChanged(ObjectReferenceTemplate[] templates, short newState) {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("adapterStateChanged", new Object[0]);
        }
        try {
            if (!this.hasIORInterceptors) {
                return;
            }
            this.interceptorInvoker.adapterStateChanged(templates, newState);
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableInterceptorsThisThread() {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("disableInterceptorsThisThread", new Object[0]);
        }
        try {
            if (!this.hasClientInterceptors) {
                return;
            }
            RequestInfoStack<ClientRequestInfoImpl> infoStack = this.threadLocalClientRequestInfoStack.get();
            ++infoStack.disableCount;
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableInterceptorsThisThread() {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("enableInterceptorsThisThread", new Object[0]);
        }
        try {
            if (!this.hasClientInterceptors) {
                return;
            }
            RequestInfoStack<ClientRequestInfoImpl> infoStack = this.threadLocalClientRequestInfoStack.get();
            --infoStack.disableCount;
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeClientPIStartingPoint() throws RemarshalException {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("invokeClientPIStartingPoint", new Object[0]);
        }
        try {
            if (!this.hasClientInterceptors) {
                return;
            }
            if (!this.isClientPIEnabledForThisThread()) {
                return;
            }
            ClientRequestInfoImpl info = this.peekClientRequestInfoImplStack();
            this.interceptorInvoker.invokeClientInterceptorStartingPoint(info);
            short replyStatus = info.getReplyStatus();
            if (replyStatus == 1 || replyStatus == 3) {
                Exception exception = this.invokeClientPIEndingPoint(this.convertPIReplyStatusToReplyMessage(replyStatus), info.getException());
                if (exception == null) {
                    // empty if block
                }
                if (exception instanceof SystemException) {
                    throw (SystemException)((Object)exception);
                }
                if (exception instanceof RemarshalException) {
                    throw (RemarshalException)((Object)exception);
                }
                if (exception instanceof UserException || exception instanceof ApplicationException) {
                    throw this.wrapper.exceptionInvalid();
                }
            } else if (replyStatus != -1) {
                throw this.wrapper.replyStatusNotInit();
            }
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    @Override
    public Exception makeCompletedClientRequest(int replyStatus, Exception exception) {
        return this.handleClientPIEndingPoint(replyStatus, exception, false);
    }

    @Override
    public Exception invokeClientPIEndingPoint(int replyStatus, Exception exception) {
        return this.handleClientPIEndingPoint(replyStatus, exception, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception handleClientPIEndingPoint(int replyStatus, Exception exception, boolean invokeEndingPoint) {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("handleClientPIEndingPoint", "replyStatus", PIHandlerImpl.getReplyStatus(replyStatus), "exception", exception, "invokeEndingPoint", invokeEndingPoint);
        }
        try {
            if (!this.hasClientInterceptors) {
                Exception exception2 = exception;
                return exception2;
            }
            if (!this.isClientPIEnabledForThisThread()) {
                Exception exception3 = exception;
                return exception3;
            }
            short piReplyStatus = REPLY_MESSAGE_TO_PI_REPLY_STATUS[replyStatus];
            ClientRequestInfoImpl info = this.peekClientRequestInfoImplStack();
            info.setReplyStatus(piReplyStatus);
            info.setException((Exception)exception);
            if (invokeEndingPoint) {
                this.interceptorInvoker.invokeClientInterceptorEndingPoint(info);
                piReplyStatus = info.getReplyStatus();
            }
            if (piReplyStatus == 3 || piReplyStatus == 4) {
                info.reset();
                if (invokeEndingPoint) {
                    info.setRetryRequest(RetryType.AFTER_RESPONSE);
                } else {
                    info.setRetryRequest(RetryType.BEFORE_RESPONSE);
                }
                exception = new RemarshalException();
            } else if (piReplyStatus == 1 || piReplyStatus == 2) {
                exception = info.getException();
            }
            Exception exception4 = exception;
            return exception4;
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initiateClientPIRequest(boolean diiRequest) {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("initiateClientPIRequest", new Object[0]);
        }
        try {
            if (!this.hasClientInterceptors) {
                return;
            }
            if (!this.isClientPIEnabledForThisThread()) {
                return;
            }
            RequestInfoStack<ClientRequestInfoImpl> infoStack = this.threadLocalClientRequestInfoStack.get();
            ClientRequestInfoImpl info = null;
            if (!infoStack.empty()) {
                info = (ClientRequestInfoImpl)infoStack.peek();
            }
            if (!diiRequest && info != null && info.isDIIInitiate()) {
                if (this.orb.interceptorDebugFlag) {
                    this.dputil.info("second call for a DII request");
                }
                info.setDIIInitiate(false);
            } else {
                if (this.orb.interceptorDebugFlag) {
                    this.dputil.info("normal call");
                }
                if (info == null || !info.getRetryRequest().isRetry()) {
                    info = new ClientRequestInfoImpl(this.orb);
                    infoStack.push(info);
                    if (this.orb.interceptorDebugFlag) {
                        this.dputil.info("client infoStack was pushed");
                    }
                }
                info.setRetryRequest(RetryType.NONE);
                info.incrementEntryCount();
                info.setReplyStatus((short)-1);
                if (diiRequest) {
                    info.setDIIInitiate(true);
                }
            }
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupClientPIRequest() {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("cleanupClientPIRequest", new Object[0]);
        }
        try {
            if (!this.hasClientInterceptors) {
                return;
            }
            if (!this.isClientPIEnabledForThisThread()) {
                return;
            }
            ClientRequestInfoImpl info = this.peekClientRequestInfoImplStack();
            RetryType rt = info.getRetryRequest();
            if (!rt.equals((Object)RetryType.BEFORE_RESPONSE)) {
                short replyStatus = info.getReplyStatus();
                if (replyStatus == -1) {
                    this.invokeClientPIEndingPoint(2, (Exception)this.wrapper.unknownRequestInvoke(CompletionStatus.COMPLETED_MAYBE));
                }
            }
            info.decrementEntryCount();
            if (info.getEntryCount() == 0 && !info.getRetryRequest().isRetry()) {
                RequestInfoStack<ClientRequestInfoImpl> infoStack = this.threadLocalClientRequestInfoStack.get();
                infoStack.pop();
                if (this.orb.interceptorDebugFlag) {
                    this.dputil.info("client infoStack was popped");
                }
            }
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientPIInfo(CorbaMessageMediator messageMediator) {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("setClientPIInfo", new Object[0]);
        }
        try {
            if (!this.hasClientInterceptors) {
                return;
            }
            if (!this.isClientPIEnabledForThisThread()) {
                return;
            }
            this.peekClientRequestInfoImplStack().setInfo(messageMediator);
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientPIInfo(RequestImpl requestImpl) {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("setClientPIInfo", new Object[0]);
        }
        try {
            if (!this.hasClientInterceptors) {
                return;
            }
            if (!this.isClientPIEnabledForThisThread()) {
                return;
            }
            this.peekClientRequestInfoImplStack().setDIIRequest(requestImpl);
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeServerPIStartingPoint() {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("invokeServerPIStartingPoint", new Object[0]);
        }
        try {
            if (!this.hasServerInterceptors) {
                return;
            }
            ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
            this.interceptorInvoker.invokeServerInterceptorStartingPoint(info);
            this.serverPIHandleExceptions(info);
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeServerPIIntermediatePoint() {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("invokeServerPIIntermediatePoint", new Object[0]);
        }
        try {
            if (!this.hasServerInterceptors) {
                return;
            }
            ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
            this.interceptorInvoker.invokeServerInterceptorIntermediatePoint(info);
            info.releaseServant();
            this.serverPIHandleExceptions(info);
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeServerPIEndingPoint(ReplyMessage replyMessage) {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("invokerServerPIEndingPoint", new Object[0]);
        }
        try {
            if (!this.hasServerInterceptors) {
                return;
            }
            ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
            info.setReplyMessage(replyMessage);
            info.setCurrentExecutionPoint(2);
            if (!info.getAlreadyExecuted()) {
                int replyStatus = replyMessage.getReplyStatus();
                short piReplyStatus = REPLY_MESSAGE_TO_PI_REPLY_STATUS[replyStatus];
                if (piReplyStatus == 3 || piReplyStatus == 4) {
                    info.setForwardRequest(replyMessage.getIOR());
                }
                Exception prevException = info.getException();
                if (!info.isDynamic() && piReplyStatus == 2) {
                    info.setException((Exception)this.omgWrapper.unknownUserException(CompletionStatus.COMPLETED_MAYBE));
                }
                info.setReplyStatus(piReplyStatus);
                this.interceptorInvoker.invokeServerInterceptorEndingPoint(info);
                short newPIReplyStatus = info.getReplyStatus();
                Exception newException = info.getException();
                if (newPIReplyStatus == 1 && newException != prevException) {
                    throw (SystemException)((Object)newException);
                }
                if (newPIReplyStatus == 3) {
                    if (piReplyStatus != 3) {
                        IOR ior = info.getForwardRequestIOR();
                        throw new ForwardException(this.orb, ior);
                    }
                    if (info.isForwardRequestRaisedInEnding()) {
                        replyMessage.setIOR(info.getForwardRequestIOR());
                    }
                }
            }
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setServerPIInfo(Exception exception) {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("setServerPIInfo", new Object[0]);
        }
        try {
            if (!this.hasServerInterceptors) {
                return;
            }
            ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
            info.setException(exception);
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setServerPIInfo(NVList arguments) {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("setServerPIInfo", new Object[0]);
        }
        try {
            if (!this.hasServerInterceptors) {
                return;
            }
            ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
            info.setDSIArguments(arguments);
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setServerPIExceptionInfo(Any exception) {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("SetServerPIExceptionInfo", new Object[0]);
        }
        try {
            if (!this.hasServerInterceptors) {
                return;
            }
            ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
            info.setDSIException(exception);
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setServerPIInfo(Any result) {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("setServerPIInfo", new Object[0]);
        }
        try {
            if (!this.hasServerInterceptors) {
                return;
            }
            ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
            info.setDSIResult(result);
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeServerPIInfo(CorbaMessageMediator request, ObjectAdapter oa, byte[] objectId, ObjectKeyTemplate oktemp) {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("initializeServerPIInfo", new Object[0]);
        }
        try {
            if (!this.hasServerInterceptors) {
                return;
            }
            RequestInfoStack<ServerRequestInfoImpl> infoStack = this.threadLocalServerRequestInfoStack.get();
            ServerRequestInfoImpl info = new ServerRequestInfoImpl(this.orb);
            infoStack.push(info);
            if (this.orb.interceptorDebugFlag) {
                this.dputil.info("server infoStack was pushed");
            }
            request.setExecutePIInResponseConstructor(true);
            info.setInfo(request, oa, objectId, oktemp);
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setServerPIInfo(Object servant, String targetMostDerivedInterface) {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("setServerPIInfo", new Object[0]);
        }
        try {
            if (!this.hasServerInterceptors) {
                return;
            }
            ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
            info.setInfo(servant, targetMostDerivedInterface);
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupServerPIRequest() {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("cleanupServerPIRequest", new Object[0]);
        }
        try {
            if (!this.hasServerInterceptors) {
                return;
            }
            RequestInfoStack<ServerRequestInfoImpl> infoStack = this.threadLocalServerRequestInfoStack.get();
            infoStack.pop();
            if (this.orb.interceptorDebugFlag) {
                this.dputil.info("server infoStack was popped");
            }
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverPIHandleExceptions(ServerRequestInfoImpl info) {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("serverPIHandleExceptions", new Object[0]);
        }
        try {
            int endingPointCall = info.getEndingPointCall();
            if (endingPointCall == 1) {
                throw (SystemException)((Object)info.getException());
            }
            if (endingPointCall == 2 && info.getForwardRequestException() != null) {
                IOR ior = info.getForwardRequestIOR();
                throw new ForwardException(this.orb, ior);
            }
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int convertPIReplyStatusToReplyMessage(short replyStatus) {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("convertPIReplyStatusToReplyMessage", new Object[0]);
        }
        try {
            int result = 0;
            for (int i = 0; i < REPLY_MESSAGE_TO_PI_REPLY_STATUS.length; ++i) {
                if (REPLY_MESSAGE_TO_PI_REPLY_STATUS[i] != replyStatus) continue;
                result = i;
                break;
            }
            int n = result;
            return n;
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientRequestInfoImpl peekClientRequestInfoImplStack() {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("peekClientRequestInfoImplStack", new Object[0]);
        }
        try {
            RequestInfoStack<ClientRequestInfoImpl> infoStack = this.threadLocalClientRequestInfoStack.get();
            ClientRequestInfoImpl info = null;
            if (infoStack.empty()) {
                throw this.wrapper.clientInfoStackNull();
            }
            info = (ClientRequestInfoImpl)infoStack.peek();
            ClientRequestInfoImpl clientRequestInfoImpl = info;
            return clientRequestInfoImpl;
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerRequestInfoImpl peekServerRequestInfoImplStack() {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("peekServerRequestInfoImplStack", new Object[0]);
        }
        try {
            RequestInfoStack<ServerRequestInfoImpl> infoStack = this.threadLocalServerRequestInfoStack.get();
            ServerRequestInfoImpl info = null;
            if (infoStack.empty()) {
                throw this.wrapper.serverInfoStackNull();
            }
            info = (ServerRequestInfoImpl)infoStack.peek();
            ServerRequestInfoImpl serverRequestInfoImpl = info;
            return serverRequestInfoImpl;
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isClientPIEnabledForThisThread() {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("isClientPIEnabledForThisThread", new Object[0]);
        }
        try {
            RequestInfoStack<ClientRequestInfoImpl> infoStack = this.threadLocalClientRequestInfoStack.get();
            boolean bl = infoStack.disableCount == 0;
            return bl;
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preInitORBInitializers(ORBInitInfoImpl info) {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("perInitORBInitializers", new Object[0]);
        }
        try {
            info.setStage(0);
            for (int i = 0; i < this.orb.getORBData().getORBInitializers().length; ++i) {
                ORBInitializer init = this.orb.getORBData().getORBInitializers()[i];
                if (init == null) continue;
                try {
                    init.pre_init((ORBInitInfo)info);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postInitORBInitializers(ORBInitInfoImpl info) {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("postInitORBInitializers", new Object[0]);
        }
        try {
            info.setStage(1);
            for (int i = 0; i < this.orb.getORBData().getORBInitializers().length; ++i) {
                ORBInitializer init = this.orb.getORBData().getORBInitializers()[i];
                if (init == null) continue;
                try {
                    init.post_init((ORBInitInfo)info);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ORBInitInfoImpl createORBInitInfo() {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("createORBInitInfo", new Object[0]);
        }
        try {
            ORBInitInfoImpl result = null;
            String orbId = this.orb.getORBData().getORBId();
            ORBInitInfoImpl oRBInitInfoImpl = result = new ORBInitInfoImpl(this.orb, this.arguments, orbId, this.codecFactory);
            return oRBInitInfoImpl;
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register_interceptor(Interceptor interceptor, int type) throws DuplicateName {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("register_interceptor", new Object[0]);
        }
        try {
            if (type >= 3 || type < 0) {
                throw this.wrapper.typeOutOfRange(type);
            }
            String interceptorName = interceptor.name();
            if (interceptorName == null) {
                throw this.wrapper.nameNull();
            }
            this.interceptorList.register_interceptor(interceptor, type);
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    @Override
    public Current getPICurrent() {
        return this.current;
    }

    private void nullParam() throws BAD_PARAM {
        throw this.orbutilWrapper.nullParam();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Policy create_policy(int type, Any val) throws PolicyError {
        if (this.orb.interceptorDebugFlag) {
            this.dputil.enter("create_policy", new Object[0]);
        }
        try {
            Policy policy;
            if (val == null) {
                this.nullParam();
            }
            if (this.policyFactoryTable == null) {
                throw new PolicyError("There is no PolicyFactory Registered for type " + type, 0);
            }
            PolicyFactory factory = this.policyFactoryTable.get(type);
            if (factory == null) {
                throw new PolicyError(" Could Not Find PolicyFactory for the Type " + type, 0);
            }
            Policy policy2 = policy = factory.create_policy(type, val);
            return policy2;
        }
        finally {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerPolicyFactory(int type, PolicyFactory factory) {
        block7: {
            if (this.orb.interceptorDebugFlag) {
                this.dputil.enter("registerPolicyFactory", new Object[0]);
            }
            try {
                Integer key;
                PolicyFactory val;
                if (this.policyFactoryTable == null) {
                    this.policyFactoryTable = new HashMap<Integer, PolicyFactory>();
                }
                if ((val = this.policyFactoryTable.get(key = Integer.valueOf(type))) == null) {
                    this.policyFactoryTable.put(key, factory);
                    break block7;
                }
                throw this.omgWrapper.policyFactoryRegFailed(type);
            }
            finally {
                if (this.orb.interceptorDebugFlag) {
                    this.dputil.exit();
                }
            }
        }
    }

    @Override
    public synchronized int allocateServerRequestId() {
        return this.serverRequestIdCounter++;
    }

    private final class RequestInfoStack<C extends RequestInfoImpl>
    extends Stack<C> {
        public int disableCount = 0;

        private RequestInfoStack() {
        }
    }
}

