/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.threadpool.Work;
import com.sun.corba.ee.spi.transport.CorbaAcceptor;
import com.sun.corba.ee.spi.transport.ListenerThread;

public class ListenerThreadImpl
implements ListenerThread,
Work {
    private ORB orb;
    private CorbaAcceptor acceptor;
    private boolean keepRunning;
    private long enqueueTime;
    private ORBUtilSystemException wrapper;

    public ListenerThreadImpl(ORB orb, CorbaAcceptor acceptor) {
        this.orb = orb;
        this.acceptor = acceptor;
        this.keepRunning = true;
        this.wrapper = orb.getLogWrapperTable().get_RPC_TRANSPORT_ORBUtil();
    }

    @Override
    public CorbaAcceptor getAcceptor() {
        return this.acceptor;
    }

    @Override
    public synchronized void close() {
        if (this.orb.transportDebugFlag) {
            this.dprint(".close: " + this.acceptor);
        }
        this.keepRunning = false;
        this.acceptor.close();
    }

    public synchronized boolean isRunning() {
        return this.keepRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork() {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: Start ListenerThread: " + this.acceptor);
            }
            while (this.isRunning()) {
                try {
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".doWork: BEFORE ACCEPT CYCLE: " + this.acceptor);
                    }
                    this.acceptor.processSocket(this.acceptor.getAcceptedSocket());
                    if (!this.orb.transportDebugFlag) continue;
                    this.dprint(".doWork: AFTER ACCEPT CYCLE: " + this.acceptor);
                }
                catch (Throwable t) {
                    this.wrapper.exceptionInListenerThread(t);
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".doWork: Exception in accept: " + this.acceptor, t);
                    }
                    this.orb.getTransportManager().getSelector(0).unregisterForEvent(this.getAcceptor().getEventHandler());
                    try {
                        if (!this.isRunning()) continue;
                        this.getAcceptor().close();
                    }
                    catch (Exception exc) {
                        this.wrapper.ioExceptionOnClose(exc);
                    }
                }
            }
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: Terminated ListenerThread: " + this.acceptor);
            }
        }
    }

    public void setEnqueueTime(long timeInMillis) {
        this.enqueueTime = timeInMillis;
    }

    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    public String getName() {
        return "ListenerThread";
    }

    private void dprint(String msg) {
        ORBUtility.dprint("ListenerThreadImpl", msg);
    }

    private void dprint(String msg, Throwable t) {
        this.dprint(msg);
        t.printStackTrace(System.out);
    }
}

