/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.oa.toa;

import com.sun.corba.ee.impl.oa.toa.Element;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.spi.orb.ORB;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;

@ManagedData
@Description(value="Maintains mapping from Object ID to servant")
public final class TransientObjectManager {
    private ORB orb;
    private int maxSize = 128;
    private Element[] elementArray;
    private Element freeList;

    @ManagedAttribute
    @Description(value="The element array mapping indices into servants")
    private synchronized Element[] getElements() {
        return (Element[])this.elementArray.clone();
    }

    void dprint(String msg) {
        ORBUtility.dprint(this, msg);
    }

    public TransientObjectManager(ORB orb) {
        this.orb = orb;
        this.elementArray = new Element[this.maxSize];
        this.elementArray[this.maxSize - 1] = new Element(this.maxSize - 1, null);
        for (int i = this.maxSize - 2; i >= 0; --i) {
            this.elementArray[i] = new Element(i, this.elementArray[i + 1]);
        }
        this.freeList = this.elementArray[0];
    }

    public synchronized byte[] storeServant(Object servant, Object servantData) {
        if (this.freeList == null) {
            this.doubleSize();
        }
        Element elem = this.freeList;
        this.freeList = (Element)this.freeList.servant;
        byte[] result = elem.getKey(servant, servantData);
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("storeServant returns key for element " + elem);
        }
        return result;
    }

    public synchronized Object lookupServant(byte[] transientKey) {
        int index = ORBUtility.bytesToInt(transientKey, 0);
        int counter = ORBUtility.bytesToInt(transientKey, 4);
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("lookupServant called with index=" + index + ", counter=" + counter);
        }
        if (this.elementArray[index].counter == counter && this.elementArray[index].valid) {
            if (this.orb.transientObjectManagerDebugFlag) {
                this.dprint("\tcounter is valid");
            }
            return this.elementArray[index].servant;
        }
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("\tcounter is invalid");
        }
        return null;
    }

    public synchronized Object lookupServantData(byte[] transientKey) {
        int index = ORBUtility.bytesToInt(transientKey, 0);
        int counter = ORBUtility.bytesToInt(transientKey, 4);
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("lookupServantData called with index=" + index + ", counter=" + counter);
        }
        if (this.elementArray[index].counter == counter && this.elementArray[index].valid) {
            if (this.orb.transientObjectManagerDebugFlag) {
                this.dprint("\tcounter is valid");
            }
            return this.elementArray[index].servantData;
        }
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("\tcounter is invalid");
        }
        return null;
    }

    public synchronized void deleteServant(byte[] transientKey) {
        int index = ORBUtility.bytesToInt(transientKey, 0);
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("deleting servant at index=" + index);
        }
        this.elementArray[index].delete(this.freeList);
        this.freeList = this.elementArray[index];
    }

    public synchronized byte[] getKey(Object servant) {
        for (int i = 0; i < this.maxSize; ++i) {
            if (!this.elementArray[i].valid || this.elementArray[i].servant != servant) continue;
            return this.elementArray[i].toBytes();
        }
        return null;
    }

    private void doubleSize() {
        int i;
        Element[] old = this.elementArray;
        int oldSize = this.maxSize;
        this.maxSize *= 2;
        this.elementArray = new Element[this.maxSize];
        for (i = 0; i < oldSize; ++i) {
            this.elementArray[i] = old[i];
        }
        this.elementArray[this.maxSize - 1] = new Element(this.maxSize - 1, null);
        for (i = this.maxSize - 2; i >= oldSize; --i) {
            this.elementArray[i] = new Element(i, this.elementArray[i + 1]);
        }
        this.freeList = this.elementArray[oldSize];
    }
}

