/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.plugin.hwlb;

import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.CorbaClientRequestDispatcherImpl;
import com.sun.corba.ee.impl.transport.CorbaConnectionCacheBase;
import com.sun.corba.ee.impl.transport.CorbaContactInfoListImpl;
import com.sun.corba.ee.impl.transport.SocketOrChannelConnectionImpl;
import com.sun.corba.ee.impl.transport.SocketOrChannelContactInfoImpl;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.orb.DataCollector;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBConfigurator;
import com.sun.corba.ee.spi.protocol.CorbaClientRequestDispatcher;
import com.sun.corba.ee.spi.protocol.RequestDispatcherRegistry;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import com.sun.corba.ee.spi.transport.CorbaContactInfo;
import com.sun.corba.ee.spi.transport.CorbaContactInfoList;
import com.sun.corba.ee.spi.transport.CorbaContactInfoListFactory;
import com.sun.corba.ee.spi.transport.CorbaOutboundConnectionCache;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.LocalObject;

public class NoConnectionCacheImpl
extends LocalObject
implements ORBConfigurator {
    private static ThreadLocal connectionCache = new ThreadLocal();

    private static NCCConnectionCacheImpl getConnectionCache(ORB orb) {
        NCCConnectionCacheImpl result = (NCCConnectionCacheImpl)connectionCache.get();
        if (result == null) {
            result = new NCCConnectionCacheImpl(orb);
            connectionCache.set(result);
        }
        return result;
    }

    @Override
    public void configure(DataCollector dc, final ORB orb) {
        CorbaContactInfoListFactory factory = new CorbaContactInfoListFactory(){

            @Override
            public void setORB(ORB orb2) {
            }

            @Override
            public CorbaContactInfoList create(IOR ior) {
                return new NCCContactInfoListImpl(orb, ior);
            }
        };
        orb.getORBData().alwaysEnterBlockingRead(false);
        orb.setCorbaContactInfoListFactory(factory);
        NCCClientRequestDispatcherImpl crd = new NCCClientRequestDispatcherImpl();
        RequestDispatcherRegistry rdr = orb.getRequestDispatcherRegistry();
        for (int ctr = 0; ctr < 63; ++ctr) {
            CorbaClientRequestDispatcher disp = rdr.getClientRequestDispatcher(ctr);
            if (disp == null) continue;
            rdr.registerClientRequestDispatcher(crd, ctr);
        }
    }

    private static class NCCClientRequestDispatcherImpl
    extends CorbaClientRequestDispatcherImpl {
        private NCCClientRequestDispatcherImpl() {
        }

        @Override
        public void endRequest(ORB broker, Object self, CDRInputObject inputObject) {
            super.endRequest(broker, self, inputObject);
            NoConnectionCacheImpl.getConnectionCache(broker).remove(null);
        }
    }

    public static class NCCContactInfoListImpl
    extends CorbaContactInfoListImpl {
        public NCCContactInfoListImpl(ORB orb, IOR ior) {
            super(orb, ior);
        }

        @Override
        public CorbaContactInfo createContactInfo(String type, String hostname, int port) {
            return new NCCContactInfoImpl(this.orb, this, this.effectiveTargetIOR, this.orb.getORBData().getGIOPAddressDisposition(), type, hostname, port);
        }
    }

    private static class NCCContactInfoImpl
    extends SocketOrChannelContactInfoImpl {
        private boolean debug;

        @Override
        public void dprint(String msg) {
            ORBUtility.dprint("NCCContactInfoImpl", msg);
        }

        public NCCContactInfoImpl(ORB orb, CorbaContactInfoList contactInfoList, IOR effectiveTargetIOR, short addressingDisposition, String socketType, String hostname, int port) {
            super(orb, contactInfoList, effectiveTargetIOR, addressingDisposition, socketType, hostname, port);
            this.debug = orb.transportDebugFlag;
        }

        @Override
        public boolean shouldCacheConnection() {
            if (this.debug) {
                this.dprint("shouldCacheConnection : returns false");
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CorbaConnection createConnection() {
            if (this.debug) {
                this.dprint("createConnection->");
            }
            try {
                NCCConnectionImpl connection = new NCCConnectionImpl(this.orb, this, this.socketType, this.hostname, this.port);
                if (this.debug) {
                    this.dprint("createConnection: created " + connection);
                }
                NCCConnectionCacheImpl cc = NoConnectionCacheImpl.getConnectionCache(this.orb);
                cc.put(this, connection);
                connection.setConnectionCache(cc);
                NCCConnectionImpl nCCConnectionImpl = connection;
                return nCCConnectionImpl;
            }
            finally {
                if (this.debug) {
                    this.dprint("createConnection<-");
                }
            }
        }
    }

    private static class NCCConnectionImpl
    extends SocketOrChannelConnectionImpl {
        private static int count = 0;
        private int myCount = count++;
        private boolean debug;

        @Override
        public void dprint(String msg) {
            ORBUtility.dprint("NCCConnectionImpl", msg);
        }

        public NCCConnectionImpl(ORB orb, CorbaContactInfo contactInfo, String socketType, String hostname, int port) {
            super(orb, contactInfo, socketType, hostname, port);
            if (this.debug) {
                this.dprint("constructed new NCCConnectionImpl: " + this.toString());
            }
        }

        @Override
        public String toString() {
            return "NCCConnectionImpl(" + this.myCount + ")[" + super.toString() + "]";
        }

        @Override
        public synchronized void close() {
            if (this.debug) {
                this.dprint("close->: " + this);
            }
            super.closeConnectionResources();
            if (this.debug) {
                this.dprint("close<-: " + this);
            }
        }
    }

    private static class NCCConnectionCacheImpl
    extends CorbaConnectionCacheBase
    implements CorbaOutboundConnectionCache {
        private Map store = new HashMap();
        private boolean debug;
        private CorbaConnection connection = null;

        @Override
        public void dprint(String msg) {
            ORBUtility.dprint("NCCConnectionCacheImpl", msg);
        }

        public NCCConnectionCacheImpl(ORB orb) {
            super(orb, "Dummy", "Dummy");
            this.debug = orb.transportDebugFlag;
        }

        @Override
        public Collection values() {
            return this.store.values();
        }

        @Override
        protected Object backingStore() {
            return this.store;
        }

        @Override
        public CorbaConnection get(CorbaContactInfo contactInfo) {
            return this.connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(CorbaContactInfo contactInfo, CorbaConnection conn) {
            if (this.debug) {
                this.dprint("put-> " + conn);
            }
            try {
                this.remove(contactInfo);
                this.connection = conn;
            }
            finally {
                if (this.debug) {
                    this.dprint("put<-");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(CorbaContactInfo contactInfo) {
            if (this.debug) {
                this.dprint("remove->");
            }
            try {
                if (this.connection != null) {
                    if (this.debug) {
                        this.dprint("remove: closing connection " + this.connection);
                    }
                    this.connection.close();
                    this.connection = null;
                } else if (this.debug) {
                    this.dprint("remove: connection is null");
                }
            }
            finally {
                if (this.debug) {
                    this.dprint("remove<-");
                }
            }
        }
    }
}

