/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.naming.namingutil;

import com.sun.corba.ee.impl.naming.namingutil.IIOPEndpointInfo;
import com.sun.corba.ee.impl.naming.namingutil.INSURLBase;
import com.sun.corba.ee.impl.naming.namingutil.Utility;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class CorbalocURL
extends INSURLBase {
    public CorbalocURL(String aURL) {
        String url = aURL;
        if (url != null) {
            try {
                url = Utility.cleanEscapes(url);
            }
            catch (Exception e) {
                this.badAddress(e);
            }
            int endIndex = url.indexOf(47);
            if (endIndex == -1) {
                endIndex = url.length();
            }
            if (endIndex == 0) {
                this.badAddress(null);
            }
            StringTokenizer endpoints = new StringTokenizer(url.substring(0, endIndex), ",");
            while (endpoints.hasMoreTokens()) {
                String endpointInfo = endpoints.nextToken();
                IIOPEndpointInfo iiopEndpointInfo = null;
                if (endpointInfo.startsWith("iiop:")) {
                    iiopEndpointInfo = this.handleIIOPColon(endpointInfo);
                } else if (endpointInfo.startsWith("rir:")) {
                    this.handleRIRColon(endpointInfo);
                    this.rirFlag = true;
                } else if (endpointInfo.startsWith(":")) {
                    iiopEndpointInfo = this.handleColon(endpointInfo);
                } else {
                    this.badAddress(null);
                }
                if (this.rirFlag) continue;
                if (this.theEndpointInfo == null) {
                    this.theEndpointInfo = new ArrayList();
                }
                this.theEndpointInfo.add(iiopEndpointInfo);
            }
            if (url.length() > endIndex + 1) {
                this.theKeyString = url.substring(endIndex + 1);
            }
        }
    }

    private IIOPEndpointInfo handleIIOPColon(String iiopInfo) {
        iiopInfo = iiopInfo.substring(4);
        return this.handleColon(iiopInfo);
    }

    private IIOPEndpointInfo handleColon(String iiopInfo) {
        String hostandport = iiopInfo = iiopInfo.substring(1);
        StringTokenizer tokenizer = new StringTokenizer(iiopInfo, "@");
        IIOPEndpointInfo iiopEndpointInfo = new IIOPEndpointInfo();
        int tokenCount = tokenizer.countTokens();
        if (tokenCount == 0 || tokenCount > 2) {
            this.badAddress(null);
        }
        if (tokenCount == 2) {
            String version = tokenizer.nextToken();
            int dot = version.indexOf(46);
            if (dot == -1) {
                this.badAddress(null);
            }
            try {
                iiopEndpointInfo.setVersion(Integer.parseInt(version.substring(0, dot)), Integer.parseInt(version.substring(dot + 1)));
                hostandport = tokenizer.nextToken();
            }
            catch (Throwable e) {
                this.badAddress(e);
            }
        }
        try {
            int squareBracketBeginIndex = hostandport.indexOf(91);
            if (squareBracketBeginIndex != -1) {
                String ipv6Port = this.getIPV6Port(hostandport);
                if (ipv6Port != null) {
                    iiopEndpointInfo.setPort(Integer.parseInt(ipv6Port));
                }
                iiopEndpointInfo.setHost(this.getIPV6Host(hostandport));
                return iiopEndpointInfo;
            }
            tokenizer = new StringTokenizer(hostandport, ":");
            if (tokenizer.countTokens() == 2) {
                iiopEndpointInfo.setHost(tokenizer.nextToken());
                iiopEndpointInfo.setPort(Integer.parseInt(tokenizer.nextToken()));
            } else if (hostandport != null && hostandport.length() != 0) {
                iiopEndpointInfo.setHost(hostandport);
            }
        }
        catch (Throwable e) {
            this.badAddress(e);
        }
        Utility.validateGIOPVersion(iiopEndpointInfo);
        return iiopEndpointInfo;
    }

    private void handleRIRColon(String rirInfo) {
        if (rirInfo.length() != 4) {
            this.badAddress(null);
        }
    }

    private String getIPV6Port(String endpointInfo) {
        int squareBracketEndIndex = endpointInfo.indexOf(93);
        if (squareBracketEndIndex + 1 != endpointInfo.length()) {
            if (endpointInfo.charAt(squareBracketEndIndex + 1) != ':') {
                throw new RuntimeException("Host and Port is not separated by ':'");
            }
            return endpointInfo.substring(squareBracketEndIndex + 2);
        }
        return null;
    }

    private String getIPV6Host(String endpointInfo) {
        int squareBracketEndIndex = endpointInfo.indexOf(93);
        String ipv6Host = endpointInfo.substring(1, squareBracketEndIndex);
        return ipv6Host;
    }

    @Override
    public boolean isCorbanameURL() {
        return false;
    }
}

