/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.oa.poa;

import com.sun.corba.ee.impl.oa.poa.POAImpl;
import com.sun.corba.ee.spi.orbutil.fsm.Action;
import com.sun.corba.ee.spi.orbutil.fsm.FSM;
import com.sun.corba.ee.spi.orbutil.fsm.FSMImpl;
import com.sun.corba.ee.spi.orbutil.fsm.Guard;
import com.sun.corba.ee.spi.orbutil.fsm.Input;
import com.sun.corba.ee.spi.orbutil.fsm.Runner;
import com.sun.corba.ee.spi.orbutil.fsm.State;
import com.sun.corba.ee.spi.orbutil.fsm.StateEngine;
import java.util.concurrent.locks.Condition;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;

public class AOMEntry
extends FSMImpl {
    private Runner runner = new Runner((FSM)this);
    private final Thread[] etherealizer;
    private final int[] counter;
    private final Condition wait;
    final POAImpl poa;
    public static final State INVALID = new State("Invalid", State.Kind.INITIAL);
    public static final State INCARN = new State("Incarnating"){

        public void postAction(FSM fsm) {
            AOMEntry entry = (AOMEntry)fsm;
            entry.wait.signalAll();
        }
    };
    public static final State VALID = new State("Valid");
    public static final State ETHP = new State("EtherealizePending");
    public static final State ETH = new State("Etherealizing"){

        public FSM preAction(FSM fsm) {
            AOMEntry entry = (AOMEntry)fsm;
            Thread etherealizer = entry.etherealizer[0];
            if (etherealizer != null) {
                etherealizer.start();
            }
            return null;
        }

        public void postAction(FSM fsm) {
            AOMEntry entry = (AOMEntry)fsm;
            entry.wait.signalAll();
        }
    };
    public static final State DESTROYED = new State("Destroyed");
    static final Input START_ETH = new Input.Base("startEtherealize");
    static final Input ETH_DONE = new Input.Base("etherealizeDone");
    static final Input INC_DONE = new Input.Base("incarnateDone");
    static final Input INC_FAIL = new Input.Base("incarnateFailure");
    static final Input ACTIVATE = new Input.Base("activateObject");
    static final Input ENTER = new Input.Base("enter");
    static final Input EXIT = new Input.Base("exit");
    private static Action incrementAction = new Action.Base("increment"){

        public void doIt(FSM fsm, Input in) {
            AOMEntry entry = (AOMEntry)fsm;
            int[] nArray = entry.counter;
            nArray[0] = nArray[0] + 1;
        }
    };
    private static Action decrementAction = new Action.Base("decrement"){

        public void doIt(FSM fsm, Input in) {
            AOMEntry entry = (AOMEntry)fsm;
            if (entry.counter[0] <= 0) {
                throw entry.poa.lifecycleWrapper().aomEntryDecZero();
            }
            int[] nArray = entry.counter;
            nArray[0] = nArray[0] - 1;
        }
    };
    private static Action throwIllegalStateExceptionAction = new Action.Base("throwIllegalStateException"){

        public void doIt(FSM fsm, Input in) {
            throw new IllegalStateException("No transitions allowed from the DESTROYED state");
        }
    };
    private static Action oaaAction = new Action.Base("throwObjectAlreadyActive"){

        public void doIt(FSM fsm, Input in) {
            throw new RuntimeException((Throwable)new ObjectAlreadyActive());
        }
    };
    private static Guard waitGuard = new Guard.Base("wait"){

        public Guard.Result evaluate(FSM fsm, Input in) {
            AOMEntry entry = (AOMEntry)fsm;
            try {
                entry.wait.await();
            }
            catch (InterruptedException exc) {
                // empty catch block
            }
            return Guard.Result.DEFERRED;
        }
    };
    private static Guard.Base.IntFunc counterFunc = new Guard.Base.IntFunc("counterFunc"){

        public int evaluate(FSM fsm, Input in) {
            AOMEntry entry = (AOMEntry)fsm;
            return entry.counter[0];
        }
    };
    private static Guard.Base.IntFunc one = Guard.Base.constant((int)1);
    private static Guard.Base.IntFunc zero = Guard.Base.constant((int)0);
    private static Guard greaterZeroGuard = Guard.Base.makeGuard((Guard.Base.Predicate)Guard.Base.gt((Guard.Base.IntFunc)counterFunc, (Guard.Base.IntFunc)zero));
    private static Guard zeroGuard = Guard.Base.makeGuard((Guard.Base.Predicate)Guard.Base.eq((Guard.Base.IntFunc)counterFunc, (Guard.Base.IntFunc)zero));
    private static Guard greaterOneGuard = Guard.Base.makeGuard((Guard.Base.Predicate)Guard.Base.gt((Guard.Base.IntFunc)counterFunc, (Guard.Base.IntFunc)one));
    private static Guard oneGuard = Guard.Base.makeGuard((Guard.Base.Predicate)Guard.Base.eq((Guard.Base.IntFunc)counterFunc, (Guard.Base.IntFunc)one));
    private static StateEngine engine = StateEngine.create();

    public AOMEntry(POAImpl poa) {
        super(engine, INVALID, poa.getORB().poaFSMDebugFlag);
        this.poa = poa;
        this.etherealizer = new Thread[1];
        this.etherealizer[0] = null;
        this.counter = new int[1];
        this.counter[0] = 0;
        this.wait = poa.poaMutex.newCondition();
    }

    public void startEtherealize(Thread etherealizer) {
        this.etherealizer[0] = etherealizer;
        this.runner.doIt(START_ETH);
    }

    public void etherealizeComplete() {
        this.runner.doIt(ETH_DONE);
    }

    public void incarnateComplete() {
        this.runner.doIt(INC_DONE);
    }

    public void incarnateFailure() {
        this.runner.doIt(INC_FAIL);
    }

    public void enter() {
        this.runner.doIt(ENTER);
    }

    public void exit() {
        this.runner.doIt(EXIT);
    }

    public void activateObject() throws ObjectAlreadyActive {
        try {
            this.runner.doIt(ACTIVATE);
        }
        catch (RuntimeException exc) {
            Throwable thr = exc.getCause();
            if (thr instanceof ObjectAlreadyActive) {
                throw (ObjectAlreadyActive)thr;
            }
            throw exc;
        }
    }

    static {
        engine.add(INVALID, ENTER, incrementAction, INCARN);
        engine.add(INVALID, ACTIVATE, null, VALID);
        engine.setDefault(INVALID);
        engine.add(INCARN, ENTER, waitGuard, null, INCARN);
        engine.add(INCARN, EXIT, null, INCARN);
        engine.add(INCARN, START_ETH, waitGuard, null, INCARN);
        engine.add(INCARN, INC_DONE, null, VALID);
        engine.add(INCARN, INC_FAIL, decrementAction, INVALID);
        engine.add(INCARN, ACTIVATE, oaaAction, INCARN);
        engine.add(VALID, ENTER, incrementAction, VALID);
        engine.add(VALID, EXIT, decrementAction, VALID);
        engine.add(VALID, START_ETH, greaterZeroGuard, null, ETHP);
        engine.add(VALID, START_ETH, zeroGuard, null, ETH);
        engine.add(VALID, ACTIVATE, oaaAction, VALID);
        engine.add(ETHP, ENTER, waitGuard, null, ETHP);
        engine.add(ETHP, START_ETH, null, ETHP);
        engine.add(ETHP, EXIT, greaterOneGuard, decrementAction, ETHP);
        engine.add(ETHP, EXIT, oneGuard, decrementAction, ETH);
        engine.add(ETHP, ACTIVATE, oaaAction, ETHP);
        engine.add(ETH, START_ETH, null, ETH);
        engine.add(ETH, ETH_DONE, null, DESTROYED);
        engine.add(ETH, ENTER, waitGuard, null, ETH);
        engine.add(ETH, ACTIVATE, oaaAction, ETH);
        engine.setDefault(DESTROYED, throwIllegalStateExceptionAction, DESTROYED);
        engine.done();
    }
}

