/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.osgi.loader;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ClassCodeBaseHandler;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.generic.UnaryFunction;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public class OSGIListener
implements BundleActivator,
SynchronousBundleListener {
    private static ORBUtilSystemException wrapper = ORB.getStaticLogWrapperTable().get_UTIL_ORBUtil();
    private static final String ORB_PROVIDER_KEY = "ORB-Class-Provider";
    private static PackageAdmin pkgAdmin;
    private static Map<String, Bundle> classNameMap;
    private static Map<String, Bundle> packageNameMap;
    private static final boolean DEBUG;
    private static UnaryFunction<String, Class<?>> classNameResolver;
    private static ClassCodeBaseHandler ccbHandler;

    private static synchronized void mapContents() {
        if (DEBUG) {
            OSGIListener.msg("Contents of classNameMap:");
            for (Map.Entry<String, Bundle> entry : classNameMap.entrySet()) {
                OSGIListener.msg(entry.getKey() + "=>" + entry.getValue().getSymbolicName());
            }
        }
    }

    private static void msg(String arg) {
        ClassLoader cl = OSGIListener.class.getClassLoader();
        System.out.println("OSGIListener(" + cl + "): " + arg);
    }

    private static String getBundleEventType(int type) {
        if (type == 1) {
            return "INSTALLED";
        }
        if (type == 512) {
            return "LAZY_ACTIVATION";
        }
        if (type == 32) {
            return "RESOLVED";
        }
        if (type == 2) {
            return "STARTED";
        }
        if (type == 128) {
            return "STARTING";
        }
        if (type == 4) {
            return "STOPPED";
        }
        if (type == 256) {
            return "STOPPING";
        }
        if (type == 16) {
            return "UNINSTALLED";
        }
        if (type == 64) {
            return "UNRESOLVED";
        }
        if (type == 8) {
            return "UPDATED";
        }
        return "ILLEGAL-EVENT-TYPE";
    }

    public static UnaryFunction<String, Class<?>> classNameResolver() {
        return classNameResolver;
    }

    private static Dictionary getHeaders(final Bundle bundle) {
        SecurityManager sman = System.getSecurityManager();
        if (sman == null) {
            return bundle.getHeaders();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Dictionary>(){

            @Override
            public Dictionary run() {
                return bundle.getHeaders();
            }
        });
    }

    public static ClassCodeBaseHandler classCodeBaseHandler() {
        return ccbHandler;
    }

    private static synchronized void insertClasses(Bundle bundle) {
        ExportedPackage[] epkgs;
        String orbProvider;
        Dictionary dict = OSGIListener.getHeaders(bundle);
        String name = bundle.getSymbolicName();
        if (dict != null && (orbProvider = (String)dict.get(ORB_PROVIDER_KEY)) != null) {
            for (String string : orbProvider.split(",")) {
                String className = string.trim();
                classNameMap.put(className, bundle);
                wrapper.insertOrbProvider(className, name);
            }
        }
        if (pkgAdmin != null && (epkgs = pkgAdmin.getExportedPackages(bundle)) != null) {
            for (ExportedPackage exportedPackage : epkgs) {
                String pname = exportedPackage.getName();
                packageNameMap.put(pname, bundle);
                wrapper.insertBundlePackage(pname, bundle.getSymbolicName());
            }
        }
    }

    private static synchronized void removeClasses(Bundle bundle) {
        ExportedPackage[] epkgs;
        String orbProvider;
        Dictionary dict = OSGIListener.getHeaders(bundle);
        String name = bundle.getSymbolicName();
        if (dict != null && (orbProvider = (String)dict.get(ORB_PROVIDER_KEY)) != null) {
            for (String string : orbProvider.split(",")) {
                classNameMap.remove(string);
                wrapper.removeOrbProvider(string, name);
            }
        }
        if (pkgAdmin != null && (epkgs = pkgAdmin.getExportedPackages(bundle)) != null) {
            for (ExportedPackage exportedPackage : epkgs) {
                String pname = exportedPackage.getName();
                packageNameMap.remove(pname);
                wrapper.removeBundlePackage(pname, bundle.getSymbolicName());
            }
        }
    }

    private static synchronized Bundle getBundleForClass(String className) {
        Bundle result = classNameMap.get(className);
        if (result == null) {
            wrapper.classNotFoundInClassNameMap(className);
            int index = className.lastIndexOf(".");
            if (index > 0) {
                String packageName = className.substring(0, index);
                result = packageNameMap.get(packageName);
                if (result == null) {
                    wrapper.classNotFoundInPackageNameMap(className);
                } else {
                    wrapper.classFoundInPackageNameMap(className, result.getSymbolicName());
                }
            }
        } else {
            wrapper.classFoundInClassNameMap(className, result.getSymbolicName());
        }
        return result;
    }

    public void start(BundleContext context) {
        ServiceReference sref = context.getServiceReference("org.osgi.service.packageadmin.PackageAdmin");
        pkgAdmin = (PackageAdmin)context.getService(sref);
        if (pkgAdmin == null) {
            wrapper.packageAdminServiceNotAvailable();
        }
        context.addBundleListener((BundleListener)this);
        wrapper.probeBundlesForProviders();
        for (Bundle bundle : context.getBundles()) {
            OSGIListener.insertClasses(bundle);
        }
        OSGIListener.mapContents();
    }

    public void stop(BundleContext context) {
        Bundle myBundle = context.getBundle();
        OSGIListener.removeClasses(myBundle);
        OSGIListener.mapContents();
    }

    public void bundleChanged(BundleEvent event) {
        int type = event.getType();
        Bundle bundle = event.getBundle();
        String name = bundle.getSymbolicName();
        wrapper.receivedBundleEvent(OSGIListener.getBundleEventType(type), name);
        if (type == 2) {
            OSGIListener.insertClasses(bundle);
        } else if (type == 1) {
            OSGIListener.removeClasses(bundle);
        }
        OSGIListener.mapContents();
    }

    static {
        classNameMap = new HashMap<String, Bundle>();
        packageNameMap = new HashMap<String, Bundle>();
        DEBUG = Boolean.getBoolean("com.sun.corba.ee.ORBDebugOSGIListener");
        classNameResolver = new ClassNameResolverImpl();
        ccbHandler = new ClassCodeBaseHandlerImpl();
    }

    private static class ClassCodeBaseHandlerImpl
    implements ClassCodeBaseHandler {
        private static final String PREFIX = "osgi://";

        private ClassCodeBaseHandlerImpl() {
        }

        @Override
        public String getCodeBase(Class cls) {
            String hver;
            if (cls == null) {
                return null;
            }
            if (pkgAdmin == null) {
                return null;
            }
            Bundle bundle = pkgAdmin.getBundle(cls);
            if (bundle == null) {
                wrapper.classNotFoundInBundle(cls);
                return null;
            }
            String name = bundle.getSymbolicName();
            Dictionary headers = OSGIListener.getHeaders(bundle);
            String version = "0.0.0";
            if (headers != null && (hver = (String)headers.get("Bundle-Version")) != null) {
                version = hver;
            }
            wrapper.foundClassInBundleVersion(cls, name, version);
            return PREFIX + name + "/" + version;
        }

        @Override
        public Class loadClass(String codebase, String className) {
            String rest;
            int index;
            if (codebase == null) {
                Bundle bundle = OSGIListener.getBundleForClass(className);
                if (bundle != null) {
                    try {
                        return bundle.loadClass(className);
                    }
                    catch (ClassNotFoundException exc) {
                        wrapper.couldNotLoadClassInBundle(exc, (Object)className, (Object)bundle.getSymbolicName());
                        return null;
                    }
                }
                return null;
            }
            if (codebase.startsWith(PREFIX) && (index = (rest = codebase.substring(PREFIX.length())).indexOf("/")) > 0) {
                Bundle[] defBundles;
                String name = rest.substring(0, index);
                String version = rest.substring(index + 1);
                if (pkgAdmin != null && (defBundles = pkgAdmin.getBundles(name, version)) != null) {
                    try {
                        wrapper.foundClassInBundleVersion(className, name, version);
                        return defBundles[0].loadClass(className);
                    }
                    catch (ClassNotFoundException cnfe) {
                        wrapper.classNotFoundInBundleVersion(className, name, version);
                    }
                }
            }
            return null;
        }
    }

    private static class ClassNameResolverImpl
    implements UnaryFunction<String, Class<?>> {
        private ClassNameResolverImpl() {
        }

        public Class<?> evaluate(String arg) {
            Bundle bundle = OSGIListener.getBundleForClass(arg);
            if (bundle == null) {
                wrapper.classNotFoundInBundle(arg);
                return null;
            }
            wrapper.foundClassInBundle(arg, bundle);
            try {
                return bundle.loadClass(arg);
            }
            catch (ClassNotFoundException ex) {
                throw wrapper.bundleCouldNotLoadClass(ex, (Object)arg, (Object)bundle);
            }
        }

        public String toString() {
            return "OSGiClassNameResolver";
        }
    }
}

