/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding.fast.bytebuffer;

import com.sun.corba.ee.impl.encoding.fast.bytebuffer.Allocator;
import com.sun.corba.ee.impl.encoding.fast.bytebuffer.AllocatorImpl;
import com.sun.corba.ee.impl.encoding.fast.bytebuffer.AllocatorPoolImpl;
import com.sun.corba.ee.impl.encoding.fast.bytebuffer.SlabPoolImpl;
import java.io.Closeable;

public class AllocatorFactory {
    int MIN_HEADER_SIZE = 8;

    private AllocatorFactory() {
    }

    public static Allocator makeAllocator(int headerSize, int allocatorSize, Allocator.BufferType bt) {
        return new AllocatorImpl(headerSize, allocatorSize, bt);
    }

    public static Allocator makePoolAllocator(int headerSize, SlabPool pool) {
        return new AllocatorPoolImpl(headerSize, pool);
    }

    public SlabPool makeSlabPool(int maxAllocationSize, long minSize, long maxSize, Allocator.BufferType bt) {
        return new SlabPoolImpl(maxAllocationSize, minSize, maxSize, bt);
    }

    public static interface SlabPool
    extends Closeable {
        public int maxAllocationSize();

        public Allocator.BufferType bufferType();

        public int numFreeSlabs();

        public int numPartialSlabs();

        public int numFullSlabs();

        public long minSize();

        public long maxSize();

        public long freeSpace();

        public long unavailableSpace();

        public long allocatedSpace();
    }
}

