/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding.fast.bytebuffer;

import com.sun.corba.ee.impl.encoding.fast.bytebuffer.BufferWrapper;
import com.sun.corba.ee.impl.encoding.fast.bytebuffer.Reader;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ReaderImpl
implements Reader {
    private static boolean DEBUG = true;
    private BlockingQueue<BufferWrapper> buffers = new LinkedBlockingQueue<BufferWrapper>();
    private int queueSize = 0;
    private volatile BufferWrapper current = null;
    private boolean closed = false;
    private long timeout;
    private ByteOrder byteOrder;
    public static final int HEADER_SIZE = 8;

    private static void msg(String msg) {
        System.out.println("READER:DEBUG:" + msg);
    }

    private static void msg(Exception exc) {
        ReaderImpl.msg("Exception:" + exc);
        exc.printStackTrace();
    }

    private static void displayBuffer(String str, BufferWrapper wrapper) {
        ReaderImpl.msg(str);
        ReaderImpl.msg("\tposition()     = " + wrapper.buffer().position());
        ReaderImpl.msg("\tlimit()        = " + wrapper.buffer().limit());
        ReaderImpl.msg("\tcapacity()     = " + wrapper.buffer().capacity());
    }

    public ReaderImpl(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout must not be negative.");
        }
        this.timeout = timeout;
        this.byteOrder = ByteOrder.BIG_ENDIAN;
    }

    @Override
    public boolean isBlockingStream() {
        return this.timeout > 0L;
    }

    @Override
    public ByteOrder order() {
        return this.byteOrder;
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    @Override
    public synchronized void receiveData(BufferWrapper bb) {
        bb.reset();
        bb.buffer().order(this.byteOrder);
        this.buffers.offer(bb);
        this.queueSize += bb.remaining();
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        this.current.dispose();
        this.current = null;
        for (BufferWrapper bw : this.buffers) {
            bw.dispose();
        }
        this.buffers = null;
        this.queueSize = 0;
    }

    private synchronized int currentAvailable() {
        if (this.current == null) {
            return 0;
        }
        return this.current.buffer().remaining();
    }

    private synchronized int totalAvailable() {
        return this.queueSize + this.currentAvailable();
    }

    public synchronized void ensurePrimitive(int size) {
        if (this.closed) {
            throw new IllegalStateException("ByteBufferReader is closed");
        }
        while (this.currentAvailable() < size) {
            BufferWrapper next = null;
            if (this.timeout > 0L) {
                try {
                    next = this.buffers.poll(this.timeout, TimeUnit.MILLISECONDS);
                    if (next != null) {
                        this.queueSize -= next.remaining();
                    }
                }
                catch (InterruptedException exc) {
                    throw new RuntimeException(exc);
                }
                if (next == null) {
                    throw new RuntimeException("Timed out in read while waiting for more data");
                }
            } else {
                next = (BufferWrapper)this.buffers.poll();
                if (next == null) {
                    throw new BufferUnderflowException();
                }
            }
            if (this.current != null) {
                next.prepend(this.current.buffer());
                this.current.dispose();
            }
            this.current = next;
        }
    }

    @Override
    public int availableDataSize() {
        return this.queueSize + this.current.remaining();
    }

    @Override
    public boolean getBoolean() {
        try {
            this.ensurePrimitive(1);
            return this.current.buffer().get() == 1;
        }
        catch (Exception exc) {
            ReaderImpl.displayBuffer("getBoolean buffer underflow: current", this.current);
            return false;
        }
    }

    @Override
    public byte getByte() {
        try {
            this.ensurePrimitive(1);
            return this.current.buffer().get();
        }
        catch (Exception exc) {
            ReaderImpl.displayBuffer("getByte buffer underflow: current", this.current);
            return 0;
        }
    }

    @Override
    public char getChar() {
        this.ensurePrimitive(2);
        return this.current.buffer().getChar();
    }

    @Override
    public short getShort() {
        this.ensurePrimitive(2);
        return this.current.buffer().getShort();
    }

    @Override
    public int getInt() {
        this.ensurePrimitive(4);
        return this.current.buffer().getInt();
    }

    @Override
    public long getLong() {
        this.ensurePrimitive(8);
        return this.current.buffer().getLong();
    }

    @Override
    public float getFloat() {
        this.ensurePrimitive(4);
        return this.current.buffer().getFloat();
    }

    @Override
    public double getDouble() {
        this.ensurePrimitive(8);
        return this.current.buffer().getDouble();
    }

    private void arraySizeCheck(int sizeInBytes) {
        if (this.timeout == 0L && sizeInBytes > this.totalAvailable()) {
            throw new BufferUnderflowException();
        }
    }

    @Override
    public void getBooleanArray(boolean[] data) {
        this.arraySizeCheck(data.length);
        for (int ctr = 0; ctr < data.length; ++ctr) {
            data[ctr] = this.getBoolean();
        }
    }

    @Override
    public void getByteArray(byte[] data) {
        this.arraySizeCheck(data.length);
        int offset = 0;
        while (true) {
            ByteBuffer typedBuffer;
            int dataSizeToRead;
            if ((dataSizeToRead = data.length - offset) > (typedBuffer = this.current.buffer()).remaining()) {
                dataSizeToRead = typedBuffer.remaining();
            }
            typedBuffer.get(data, offset, dataSizeToRead);
            if ((offset += dataSizeToRead) == data.length) break;
            this.ensurePrimitive(1);
        }
    }

    @Override
    public void getBytes(BufferWrapper buffer) {
        buffer.reset();
        this.arraySizeCheck(buffer.remaining());
        boolean offset = false;
        while (true) {
            if (buffer.remaining() <= this.current.remaining()) break;
            buffer.buffer().put(this.current.buffer());
            this.ensurePrimitive(1);
        }
        int save = this.current.buffer().limit();
        this.current.buffer().limit(buffer.remaining());
        ByteBuffer tail = this.current.buffer().slice();
        this.current.buffer().limit(save);
        buffer.buffer().put(tail);
    }

    @Override
    public void getCharArray(char[] data) {
        this.arraySizeCheck(2 * data.length);
        int offset = 0;
        while (true) {
            CharBuffer typedBuffer;
            int dataSizeToRead;
            if ((dataSizeToRead = data.length - offset) > (typedBuffer = this.current.buffer().asCharBuffer()).remaining()) {
                dataSizeToRead = typedBuffer.remaining();
            }
            typedBuffer.get(data, offset, dataSizeToRead);
            if ((offset += dataSizeToRead) == data.length) break;
            this.ensurePrimitive(2);
        }
    }

    @Override
    public void getShortArray(short[] data) {
        this.arraySizeCheck(2 * data.length);
        int offset = 0;
        while (true) {
            ShortBuffer typedBuffer;
            int dataSizeToRead;
            if ((dataSizeToRead = data.length - offset) > (typedBuffer = this.current.buffer().asShortBuffer()).remaining()) {
                dataSizeToRead = typedBuffer.remaining();
            }
            typedBuffer.get(data, offset, dataSizeToRead);
            if ((offset += dataSizeToRead) == data.length) break;
            this.ensurePrimitive(2);
        }
    }

    @Override
    public void getIntArray(int[] data) {
        this.arraySizeCheck(4 * data.length);
        int offset = 0;
        while (true) {
            IntBuffer typedBuffer;
            int dataSizeToRead;
            if ((dataSizeToRead = data.length - offset) > (typedBuffer = this.current.buffer().asIntBuffer()).remaining()) {
                dataSizeToRead = typedBuffer.remaining();
            }
            typedBuffer.get(data, offset, dataSizeToRead);
            if ((offset += dataSizeToRead) == data.length) break;
            this.ensurePrimitive(4);
        }
    }

    @Override
    public void getLongArray(long[] data) {
        this.arraySizeCheck(8 * data.length);
        int offset = 0;
        while (true) {
            LongBuffer typedBuffer;
            int dataSizeToRead;
            if ((dataSizeToRead = data.length - offset) > (typedBuffer = this.current.buffer().asLongBuffer()).remaining()) {
                dataSizeToRead = typedBuffer.remaining();
            }
            typedBuffer.get(data, offset, dataSizeToRead);
            if ((offset += dataSizeToRead) == data.length) break;
            this.ensurePrimitive(8);
        }
    }

    @Override
    public void getFloatArray(float[] data) {
        this.arraySizeCheck(4 * data.length);
        int offset = 0;
        while (true) {
            FloatBuffer typedBuffer;
            int dataSizeToRead;
            if ((dataSizeToRead = data.length - offset) > (typedBuffer = this.current.buffer().asFloatBuffer()).remaining()) {
                dataSizeToRead = typedBuffer.remaining();
            }
            typedBuffer.get(data, offset, dataSizeToRead);
            if ((offset += dataSizeToRead) == data.length) break;
            this.ensurePrimitive(4);
        }
    }

    @Override
    public void getDoubleArray(double[] data) {
        this.arraySizeCheck(8 * data.length);
        int offset = 0;
        while (true) {
            DoubleBuffer typedBuffer;
            int dataSizeToRead;
            if ((dataSizeToRead = data.length - offset) > (typedBuffer = this.current.buffer().asDoubleBuffer()).remaining()) {
                dataSizeToRead = typedBuffer.remaining();
            }
            typedBuffer.get(data, offset, dataSizeToRead);
            if ((offset += dataSizeToRead) == data.length) break;
            this.ensurePrimitive(8);
        }
    }
}

