/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding.fast.bytebuffer;

import com.sun.corba.ee.impl.encoding.fast.bytebuffer.Allocator;
import com.sun.corba.ee.impl.encoding.fast.bytebuffer.AllocatorFactory;
import com.sun.corba.ee.impl.encoding.fast.bytebuffer.Slab;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SlabPoolImpl
implements AllocatorFactory.SlabPool {
    private int maxAllocationSize;
    private long minSize;
    private long maxSize;
    private Allocator.BufferType bufferType;
    private boolean closed = false;
    private Set<Slab> emptySlabs;
    private Set<Slab> fullSlabs;
    private Set<Slab> partialSlabs;

    public SlabPoolImpl(int maxAllocationSize, long minSize, long maxSize, Allocator.BufferType bufferType) {
        this.maxAllocationSize = maxAllocationSize;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.bufferType = bufferType;
        this.emptySlabs = new HashSet<Slab>();
        this.fullSlabs = new HashSet<Slab>();
        this.partialSlabs = new HashSet<Slab>();
        while (this.freeSpace() < minSize) {
            Slab slab = new Slab(maxAllocationSize, bufferType);
            this.emptySlabs.add(slab);
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("SlabPoolImpl is closed");
        }
    }

    @Override
    public synchronized void close() {
        this.checkClosed();
        this.emptySlabs = null;
        this.fullSlabs = null;
        this.partialSlabs = null;
        this.closed = true;
    }

    @Override
    public synchronized int maxAllocationSize() {
        this.checkClosed();
        return this.maxAllocationSize;
    }

    @Override
    public synchronized long minSize() {
        this.checkClosed();
        return this.minSize;
    }

    @Override
    public synchronized long maxSize() {
        this.checkClosed();
        return this.maxSize;
    }

    @Override
    public synchronized int numFreeSlabs() {
        this.checkClosed();
        return this.emptySlabs.size();
    }

    @Override
    public synchronized int numPartialSlabs() {
        this.checkClosed();
        return this.partialSlabs.size();
    }

    @Override
    public synchronized int numFullSlabs() {
        this.checkClosed();
        return this.fullSlabs.size();
    }

    private long totalSpaceInUse() {
        long result = this.maxAllocationSize;
        return result *= (long)(this.emptySlabs.size() + this.partialSlabs.size() + this.fullSlabs.size());
    }

    private long computeAvailableSize(Set<Slab> set) {
        long result = 0L;
        for (Slab slab : set) {
            result += (long)slab.sizeAvailable();
        }
        return result;
    }

    private long computeAllocatedSize(Set<Slab> set) {
        long result = 0L;
        for (Slab slab : set) {
            result += (long)slab.sizeAllocated();
        }
        return result;
    }

    private long computeDisposedSize(Set<Slab> set) {
        long result = 0L;
        for (Slab slab : set) {
            result += (long)slab.sizeDisposed();
        }
        return result;
    }

    @Override
    public synchronized long freeSpace() {
        this.checkClosed();
        return this.computeAvailableSize(this.emptySlabs) + this.computeAvailableSize(this.partialSlabs);
    }

    @Override
    public synchronized long unavailableSpace() {
        this.checkClosed();
        return this.computeDisposedSize(this.partialSlabs) + this.computeDisposedSize(this.fullSlabs);
    }

    @Override
    public synchronized long allocatedSpace() {
        this.checkClosed();
        return this.computeAllocatedSize(this.partialSlabs) + this.computeAllocatedSize(this.fullSlabs);
    }

    @Override
    public synchronized Allocator.BufferType bufferType() {
        this.checkClosed();
        return this.bufferType;
    }

    public synchronized Slab getSlab() {
        this.checkClosed();
        Slab result = null;
        Iterator<Slab> i$ = this.emptySlabs.iterator();
        if (i$.hasNext()) {
            Slab slab;
            result = slab = i$.next();
        }
        if (result == null) {
            result = new Slab(this.maxAllocationSize, this.bufferType);
        } else {
            this.emptySlabs.remove(result);
        }
        this.partialSlabs.add(result);
        return result;
    }

    public synchronized void releaseSlab(Slab slab) {
        this.checkClosed();
        slab.markFull();
        this.partialSlabs.remove(slab);
        this.fullSlabs.add(slab);
    }

    public synchronized void dispose(Slab slab, ByteBuffer buffer) {
        this.checkClosed();
        slab.dispose(buffer);
        if (slab.getState() == Slab.State.EMPTY) {
            this.fullSlabs.remove(slab);
            slab.markEmpty();
            if (this.totalSpaceInUse() < this.maxSize) {
                this.emptySlabs.add(slab);
            }
        }
    }
}

