/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.naming.pcosnaming;

import com.sun.corba.ee.impl.naming.cosnaming.BindingIteratorImpl;
import com.sun.corba.ee.impl.naming.pcosnaming.InternalBindingKey;
import com.sun.corba.ee.impl.naming.pcosnaming.InternalBindingValue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class PersistentBindingIterator
extends BindingIteratorImpl {
    private POA biPOA;
    private int currentSize;
    private HashMap<InternalBindingKey, InternalBindingValue> map;
    private Iterator<InternalBindingKey> iterator;

    public PersistentBindingIterator(ORB orb, Map<InternalBindingKey, InternalBindingValue> aTable, POA thePOA) throws Exception {
        super(orb);
        this.map = new HashMap<InternalBindingKey, InternalBindingValue>(aTable);
        this.iterator = this.map.keySet().iterator();
        this.currentSize = this.map.size();
        this.biPOA = thePOA;
    }

    @Override
    public final boolean nextOneImpl(BindingHolder b) {
        boolean hasMore = this.iterator.hasNext();
        if (hasMore) {
            InternalBindingKey theBindingKey = this.iterator.next();
            InternalBindingValue theElement = this.map.get(theBindingKey);
            NameComponent n = new NameComponent(theBindingKey.id, theBindingKey.kind);
            NameComponent[] nlist = new NameComponent[]{n};
            BindingType theType = theElement.theBindingType;
            b.value = new Binding(nlist, theType);
        } else {
            b.value = new Binding(new NameComponent[0], BindingType.nobject);
        }
        return hasMore;
    }

    @Override
    public final void destroyImpl() {
        try {
            byte[] objectId = this.biPOA.servant_to_id((Servant)this);
            if (objectId != null) {
                this.biPOA.deactivate_object(objectId);
            }
        }
        catch (Exception e) {
            throw new INTERNAL("Exception in BindingIterator.Destroy " + e);
        }
    }

    @Override
    public final int remainingElementsImpl() {
        return this.currentSize;
    }
}

