/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.oa.poa;

import com.sun.corba.ee.impl.logging.OMGSystemException;
import com.sun.corba.ee.impl.logging.POASystemException;
import com.sun.corba.ee.impl.oa.poa.DelegateImpl;
import com.sun.corba.ee.impl.oa.poa.POACurrent;
import com.sun.corba.ee.impl.oa.poa.POAImpl;
import com.sun.corba.ee.spi.ior.ObjectAdapterId;
import com.sun.corba.ee.spi.oa.ObjectAdapter;
import com.sun.corba.ee.spi.oa.ObjectAdapterFactory;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.closure.Closure;
import com.sun.corba.ee.spi.orbutil.closure.ClosureFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.gmbal.ManagedObjectManager;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.portable.Delegate;

@ManagedObject
@Description(value="The factory for all POAs and POAManagers")
@AMXMetadata(isSingleton=true)
public class POAFactory
implements ObjectAdapterFactory {
    private Map<Servant, POA> exportedServantsToPOA = new WeakHashMap<Servant, POA>();
    private Set<POAManager> poaManagers = Collections.synchronizedSet(new HashSet(4));
    private int poaManagerId = 0;
    private int poaId = 0;
    private POAImpl rootPOA = null;
    private DelegateImpl delegateImpl = null;
    private ORB orb = null;
    private POASystemException wrapper;
    private OMGSystemException omgWrapper;
    private boolean isShuttingDown = false;
    private ManagedObjectManager mom;

    public POASystemException getWrapper() {
        return this.wrapper;
    }

    @ManagedAttribute
    @Description(value="The servants managed by a particular POA")
    private synchronized List<ServantPOAPair> getExportedServants() {
        ArrayList<ServantPOAPair> result = new ArrayList<ServantPOAPair>();
        for (Map.Entry<Servant, POA> entry : this.exportedServantsToPOA.entrySet()) {
            POAImpl pimpl = (POAImpl)entry.getValue();
            result.add(new ServantPOAPair(entry.getKey(), pimpl));
        }
        return result;
    }

    @ManagedAttribute
    @Description(value="The POAManagers")
    private synchronized Set<POAManager> getPOAManagers() {
        return new HashSet<POAManager>(this.poaManagers);
    }

    @ManagedAttribute
    @Description(value="The last allocated POAManager id")
    private synchronized int getPOAManagerId() {
        return this.poaManagerId;
    }

    @ManagedAttribute
    @Description(value="The last allocated POAManager id")
    private synchronized int getPOAId() {
        return this.poaId;
    }

    @ManagedAttribute(id="RootPOA")
    @Description(value="The root POA")
    private synchronized POAImpl getDisplayRootPOA() {
        return this.rootPOA;
    }

    public synchronized POA lookupPOA(Servant servant) {
        return this.exportedServantsToPOA.get(servant);
    }

    public synchronized void registerPOAForServant(POA poa, Servant servant) {
        this.exportedServantsToPOA.put(servant, poa);
    }

    public synchronized void unregisterPOAForServant(POA poa, Servant servant) {
        this.exportedServantsToPOA.remove(servant);
    }

    @Override
    public void init(ORB orb) {
        this.orb = orb;
        this.wrapper = orb.getLogWrapperTable().get_OA_LIFECYCLE_POA();
        this.omgWrapper = orb.getLogWrapperTable().get_OA_LIFECYCLE_OMG();
        this.delegateImpl = new DelegateImpl(orb, this);
        this.registerRootPOA();
        POACurrent poaCurrent = new POACurrent(orb);
        orb.getLocalResolver().register("POACurrent", ClosureFactory.makeConstant((java.lang.Object)((java.lang.Object)poaCurrent)));
        this.mom = orb.mom();
        this.mom.registerAtRoot((java.lang.Object)this);
    }

    @Override
    public ObjectAdapter find(ObjectAdapterId oaid) {
        POA poa = null;
        try {
            boolean first = true;
            Iterator<String> iter = oaid.iterator();
            poa = this.getRootPOA();
            while (iter.hasNext()) {
                String name = iter.next();
                if (first) {
                    if (!name.equals("RootPOA")) {
                        throw this.wrapper.makeFactoryNotPoa(name);
                    }
                    first = false;
                    continue;
                }
                poa = poa.find_POA(name, true);
            }
        }
        catch (AdapterNonExistent ex) {
            throw this.omgWrapper.noObjectAdaptor(ex);
        }
        catch (OBJECT_NOT_EXIST ex) {
            throw ex;
        }
        catch (TRANSIENT ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw this.wrapper.poaLookupError(ex);
        }
        if (poa == null) {
            throw this.wrapper.poaLookupError();
        }
        return (ObjectAdapter)poa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean waitForCompletion) {
        Iterator<POAManager> managers = null;
        POAFactory pOAFactory = this;
        synchronized (pOAFactory) {
            this.isShuttingDown = true;
            managers = new HashSet<POAManager>(this.poaManagers).iterator();
        }
        while (managers.hasNext()) {
            try {
                managers.next().deactivate(true, waitForCompletion);
            }
            catch (AdapterInactive adapterInactive) {}
        }
    }

    public synchronized void removePoaManager(POAManager manager) {
        this.poaManagers.remove(manager);
        this.mom.unregister((java.lang.Object)manager);
    }

    public synchronized void addPoaManager(POAManager manager) {
        this.poaManagers.add(manager);
    }

    public synchronized int newPOAManagerId() {
        return this.poaManagerId++;
    }

    public void registerRootPOA() {
        Closure rpClosure = new Closure(){

            public java.lang.Object evaluate() {
                return POAImpl.makeRootPOA(POAFactory.this.orb);
            }
        };
        this.orb.getLocalResolver().register("RootPOA", ClosureFactory.makeFuture((Closure)rpClosure));
    }

    public synchronized POA getRootPOA() {
        if (this.rootPOA == null) {
            if (this.isShuttingDown) {
                throw this.omgWrapper.noObjectAdaptor();
            }
            try {
                Object obj = this.orb.resolve_initial_references("RootPOA");
                this.rootPOA = (POAImpl)obj;
            }
            catch (InvalidName inv) {
                throw this.wrapper.cantResolveRootPoa(inv);
            }
        }
        return this.rootPOA;
    }

    public Delegate getDelegateImpl() {
        return this.delegateImpl;
    }

    public synchronized int newPOAId() {
        return this.poaId++;
    }

    @Override
    public ORB getORB() {
        return this.orb;
    }

    @ManagedData
    @Description(value="A servant registered with a particular POA")
    public static class ServantPOAPair {
        private Servant servant;
        private POAImpl poa;

        public ServantPOAPair(Servant servant, POAImpl poa) {
            this.servant = servant;
            this.poa = poa;
        }

        @ManagedAttribute
        @Description(value="Servant")
        Servant getServant() {
            return this.servant;
        }

        @ManagedAttribute
        @Description(value="POA for Servant")
        POAImpl getPOA() {
            return this.poa;
        }
    }
}

