/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding.fast;

import com.sun.corba.ee.impl.encoding.fast.EmergeCode;
import com.sun.corba.ee.impl.encoding.fast.EmergeCodeFactory;
import com.sun.corba.ee.spi.orbutil.fsm.Action;
import com.sun.corba.ee.spi.orbutil.fsm.FSM;
import com.sun.corba.ee.spi.orbutil.fsm.FSMImpl;
import com.sun.corba.ee.spi.orbutil.fsm.Guard;
import com.sun.corba.ee.spi.orbutil.fsm.Input;
import com.sun.corba.ee.spi.orbutil.fsm.Runner;
import com.sun.corba.ee.spi.orbutil.fsm.State;
import com.sun.corba.ee.spi.orbutil.fsm.StateEngine;
import java.util.HashSet;
import java.util.Set;

public class EmergeLLP {
    static final Input PRIMITIVE = new Input.Base("Primitive");
    static final Input ARRAY = new Input.Base("Array");
    static final Input SIMPLE_MESSAGE = new Input.Base("SimpleMessage");
    static final Input REF = new Input.Base("Ref");
    static final Input MSG_START = new Input.Base("MsgStart");
    static final Input MSG_END = new Input.Base("MsgEnd");
    static final Input TUPLE_START = new Input.Base("TupleStart");
    static final Input TUPLE_END = new Input.Base("TupleEnd");
    static final Input PART_SIMPLE = new Input.Base("PartSimple");
    static final Input PART_CUSTOM = new Input.Base("PartCustom");
    static final Input END_OF_DATA = new Input.Base("EndOfData");
    static final Input LABEL_MSG_REPLY_GOOD = new Input.Base("LabelMsgReplyGood");
    static final Input ILLEGAL_CODE = new Input.Base("IllegalCode");
    private static Input[] inputs = new Input[256];
    private static final State ERROR;
    long partCtr = 0L;
    long dataCtr = 0L;
    private Runner runner;
    FSM valueFSM = new LLPValue();

    void setDataCtr(long value) {
        this.dataCtr = value;
    }

    void setPartCtr(long value) {
        this.partCtr = value;
    }

    public EmergeLLP() {
        LLPMain mainFSM = new LLPMain();
        this.runner = new Runner((FSM)mainFSM);
    }

    public void checkState(EmergeCode input) {
        this.runner.doIt(inputs[input.code()]);
    }

    static {
        block8: for (int ctr = 0; ctr <= 255; ++ctr) {
            EmergeCode ec = EmergeCodeFactory.getCode(ctr);
            if (!ec.isValidEmergeCode()) {
                EmergeLLP.inputs[ctr] = ILLEGAL_CODE;
                continue;
            }
            if (ec.isPrimitive()) {
                EmergeLLP.inputs[ctr] = PRIMITIVE;
                continue;
            }
            if (ec.isArray()) {
                EmergeLLP.inputs[ctr] = ARRAY;
                continue;
            }
            switch (ec.getKind()) {
                case TUPLE: {
                    EmergeCode.TupleCode tc = ec.getValue(EmergeCode.TupleCode.class);
                    if (tc == EmergeCode.TupleCode.TUPLE_START) {
                        EmergeLLP.inputs[ctr] = TUPLE_START;
                        continue block8;
                    }
                    if (tc != EmergeCode.TupleCode.TUPLE_END) continue block8;
                    EmergeLLP.inputs[ctr] = TUPLE_END;
                    continue block8;
                }
                case PART: {
                    EmergeCode.PartCode pc = ec.getValue(EmergeCode.PartCode.class);
                    if (pc == EmergeCode.PartCode.NO_CUSTOM) {
                        EmergeLLP.inputs[ctr] = PART_SIMPLE;
                        continue block8;
                    }
                    if (pc != EmergeCode.PartCode.HAS_CUSTOM) continue block8;
                    EmergeLLP.inputs[ctr] = PART_CUSTOM;
                    continue block8;
                }
                case MSG: {
                    EmergeCode.MsgCode mc = ec.getValue(EmergeCode.MsgCode.class);
                    if (mc == EmergeCode.MsgCode.MSG_START) {
                        EmergeLLP.inputs[ctr] = MSG_START;
                        continue block8;
                    }
                    if (mc != EmergeCode.MsgCode.MSG_END) continue block8;
                    EmergeLLP.inputs[ctr] = MSG_END;
                    continue block8;
                }
                case LABEL_MSG: {
                    EmergeCode.LabelMsg lmc = ec.getValue(EmergeCode.LabelMsg.class);
                    if (lmc == EmergeCode.LabelMsg.REPLY_GOOD) {
                        EmergeLLP.inputs[ctr] = LABEL_MSG_REPLY_GOOD;
                        continue block8;
                    }
                    EmergeLLP.inputs[ctr] = SIMPLE_MESSAGE;
                    continue block8;
                }
                case FLIST: 
                case CLOSE_SESSION: 
                case REJECT_REQUEST: {
                    EmergeLLP.inputs[ctr] = SIMPLE_MESSAGE;
                    continue block8;
                }
                case REF: {
                    EmergeLLP.inputs[ctr] = REF;
                }
            }
        }
        ERROR = new State("Error", State.Kind.FINAL){

            public FSM preAction(FSM fsm) {
                throw new IllegalStateException("Illegal state");
            }
        };
    }

    private final class LLPValue
    extends FSMImpl {
        private final Set<State> states;
        private final State VALUE;
        private final State SIMPLE_PART;
        private final State CUSTOM_PART;
        private final State EXPECT_TUPLE_START;
        private final State CUSTOM_PART_TUPLE;
        private final State VALUE_END;
        private final Action ddc;
        private final Action dpc;
        private final Action ddpc;
        private final Guard.Base.IntFunc df;
        private final Guard.Base.IntFunc pf;
        private final Guard.Base.IntFunc one;
        private final Guard dataNotDone;
        private final Guard dataDone;
        private final Guard partNotDone;
        private final Guard partDone;
        private final Guard dataDoneMoreParts;
        private final Guard dataDonePartsDone;
        private StateEngine engine;

        public LLPValue() {
            super(StateEngine.create(), null);
            this.states = new HashSet<State>();
            this.VALUE = new State(this.states, "Value", State.Kind.INITIAL);
            this.SIMPLE_PART = new State(this.states, "SimplePart");
            this.CUSTOM_PART = new State(this.states, "CustomPart");
            this.EXPECT_TUPLE_START = new State(this.states, "ExpectTupleStart");
            this.CUSTOM_PART_TUPLE = new State(this.states, "CustomPartTuple");
            this.VALUE_END = new State("ValueEnd", State.Kind.FINAL);
            this.ddc = new Action.Base("decrement(dataCtr)"){

                public void doIt(FSM fsm, Input in) {
                    --EmergeLLP.this.dataCtr;
                }
            };
            this.dpc = new Action.Base("decrement(partCtr)"){

                public void doIt(FSM fsm, Input in) {
                    --EmergeLLP.this.partCtr;
                }
            };
            this.ddpc = Action.Base.compose((Action)this.ddc, (Action)this.dpc);
            this.df = new Guard.Base.IntFunc("EmergeLLP.dataCtr"){

                public int evaluate(FSM fsm, Input inp) {
                    return (int)EmergeLLP.this.dataCtr;
                }
            };
            this.pf = new Guard.Base.IntFunc("EmergeLLP.partCtr"){

                public int evaluate(FSM fsm, Input inp) {
                    return (int)EmergeLLP.this.partCtr;
                }
            };
            this.one = Guard.Base.constant((int)1);
            this.dataNotDone = Guard.Base.makeGuard((Guard.Base.Predicate)Guard.Base.gt((Guard.Base.IntFunc)this.df, (Guard.Base.IntFunc)this.one));
            this.dataDone = Guard.Base.makeGuard((Guard.Base.Predicate)Guard.Base.eq((Guard.Base.IntFunc)this.df, (Guard.Base.IntFunc)this.one));
            this.partNotDone = Guard.Base.makeGuard((Guard.Base.Predicate)Guard.Base.gt((Guard.Base.IntFunc)this.pf, (Guard.Base.IntFunc)this.one));
            this.partDone = Guard.Base.makeGuard((Guard.Base.Predicate)Guard.Base.eq((Guard.Base.IntFunc)this.pf, (Guard.Base.IntFunc)this.one));
            this.dataDoneMoreParts = Guard.Base.makeGuard((Guard.Base.Predicate)Guard.Base.and((Guard.Base.Predicate)Guard.Base.eq((Guard.Base.IntFunc)this.df, (Guard.Base.IntFunc)this.one), (Guard.Base.Predicate)Guard.Base.gt((Guard.Base.IntFunc)this.pf, (Guard.Base.IntFunc)this.one)));
            this.dataDonePartsDone = Guard.Base.makeGuard((Guard.Base.Predicate)Guard.Base.and((Guard.Base.Predicate)Guard.Base.eq((Guard.Base.IntFunc)this.df, (Guard.Base.IntFunc)this.one), (Guard.Base.Predicate)Guard.Base.eq((Guard.Base.IntFunc)this.pf, (Guard.Base.IntFunc)this.one)));
            this.setState(this.VALUE);
            this.engine = this.getStateEngine();
            for (State state : this.states) {
                this.engine.setDefault(state, ERROR);
            }
            this.engine.add(this.VALUE, PART_SIMPLE, null, this.SIMPLE_PART);
            this.engine.add(this.VALUE, PART_CUSTOM, null, this.CUSTOM_PART);
            this.engine.add(this.SIMPLE_PART, PRIMITIVE, this.dataNotDone, this.ddc, this.SIMPLE_PART);
            this.engine.add(this.SIMPLE_PART, PRIMITIVE, this.dataDoneMoreParts, this.ddpc, this.VALUE);
            this.engine.add(this.SIMPLE_PART, PRIMITIVE, this.dataDonePartsDone, this.ddpc, this.VALUE_END);
            this.engine.add(this.CUSTOM_PART, PRIMITIVE, this.dataNotDone, this.ddc, this.CUSTOM_PART);
            this.engine.add(this.CUSTOM_PART, PRIMITIVE, this.dataDone, this.ddc, this.EXPECT_TUPLE_START);
            this.engine.add(this.EXPECT_TUPLE_START, TUPLE_START, null, this.CUSTOM_PART_TUPLE);
            this.engine.add(this.CUSTOM_PART_TUPLE, PRIMITIVE, null, this.CUSTOM_PART_TUPLE);
            this.engine.add(this.CUSTOM_PART_TUPLE, TUPLE_END, this.partNotDone, this.dpc, this.VALUE);
            this.engine.add(this.CUSTOM_PART_TUPLE, TUPLE_END, this.partDone, this.dpc, this.VALUE_END);
        }
    }

    private final class LLPMain
    extends FSMImpl {
        private final Set<State> states;
        private final State START;
        private final State LABEL_MSG;
        private final State START_MSG;
        private final State EXPECT_TUPLE_START_2;
        private final State HANDLE_REF_SEQ;
        private final State OTHER_VALUE;
        private final State MESSAGE_VALUE;
        private final State END;
        private final StateEngine engine;

        LLPMain() {
            super(StateEngine.create(), null);
            this.states = new HashSet<State>();
            this.START = new State(this.states, "Start", State.Kind.INITIAL);
            this.LABEL_MSG = new State(this.states, "LabelMsg");
            this.START_MSG = new State(this.states, "StartMsg");
            this.EXPECT_TUPLE_START_2 = new State(this.states, "ExpectTupleStart2");
            this.HANDLE_REF_SEQ = new State(this.states, "HandleRefSeq");
            this.OTHER_VALUE = new State("OtherValue", State.Kind.REFERENCE){

                public FSM preAction(FSM fsm) {
                    return EmergeLLP.this.valueFSM;
                }

                public State returnAction(FSM fsm, FSM nestedFSM) {
                    if (fsm.getState() == LLPMain.this.OTHER_VALUE) {
                        return LLPMain.this.START;
                    }
                    if (fsm.getState() == LLPMain.this.MESSAGE_VALUE) {
                        return LLPMain.this.END;
                    }
                    throw new IllegalStateException("Bad state");
                }
            };
            this.MESSAGE_VALUE = new State("MessageValue", State.Kind.REFERENCE){

                public FSM preAction(FSM fsm) {
                    return EmergeLLP.this.valueFSM;
                }
            };
            this.END = new State("End", State.Kind.FINAL);
            this.setState(this.START);
            this.engine = this.getStateEngine();
            for (State state : this.states) {
                this.engine.setDefault(state, ERROR);
            }
            this.engine.add(this.START, PRIMITIVE, null, this.START);
            this.engine.add(this.START, ARRAY, null, this.START);
            this.engine.add(this.START, SIMPLE_MESSAGE, null, this.START);
            this.engine.add(this.START, END_OF_DATA, null, this.END);
            this.engine.add(this.START, MSG_START, null, this.START_MSG);
            this.engine.add(this.START, LABEL_MSG_REPLY_GOOD, null, this.LABEL_MSG);
            this.engine.add(this.START, REF, null, this.OTHER_VALUE);
            this.engine.add(this.START_MSG, TUPLE_START, null, this.EXPECT_TUPLE_START_2);
            this.engine.add(this.EXPECT_TUPLE_START_2, PRIMITIVE, null, this.EXPECT_TUPLE_START_2);
            this.engine.add(this.EXPECT_TUPLE_START_2, TUPLE_END, null, this.HANDLE_REF_SEQ);
            this.engine.add(this.HANDLE_REF_SEQ, ARRAY, null, this.HANDLE_REF_SEQ);
            this.engine.add(this.HANDLE_REF_SEQ, MSG_END, null, this.START);
            this.engine.add(this.HANDLE_REF_SEQ, REF, null, this.MESSAGE_VALUE);
        }
    }
}

