/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding.fast;

import com.sun.corba.ee.impl.encoding.fast.LookupTable;
import com.sun.corba.ee.spi.orbutil.generic.Holder;
import com.sun.corba.ee.spi.orbutil.generic.UnaryFunction;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LookupTableConcurrentImpl<K, V>
implements LookupTable<K, V> {
    private final ConcurrentMap<WeakKey<K>, Reference<?>> localDescs = new ConcurrentHashMap();
    private final ReferenceQueue<K> localDescsQueue = new ReferenceQueue();
    private final UnaryFunction<K, V> factory;
    private final Class<V> token;

    public LookupTableConcurrentImpl(UnaryFunction<K, V> factory, Class<V> token) {
        this.factory = factory;
        this.token = token;
    }

    void processQueue(ReferenceQueue<K> queue, ConcurrentMap<? extends WeakReference<K>, ?> map) {
        Reference<K> ref;
        while ((ref = queue.poll()) != null) {
            map.remove(ref);
        }
    }

    @Override
    public V lookup(Holder<Boolean> firstTime, K k) {
        if (firstTime != null) {
            firstTime.content((Object)false);
        }
        this.processQueue(this.localDescsQueue, this.localDescs);
        WeakKey<K> key = new WeakKey<K>(k, this.localDescsQueue);
        Reference ref = (Reference)this.localDescs.get(key);
        Object entry = null;
        if (ref != null) {
            entry = ref.get();
        }
        EntryFuture future = null;
        if (entry == null) {
            EntryFuture newEntry = new EntryFuture();
            SoftReference newRef = new SoftReference(newEntry);
            do {
                if (ref != null) {
                    this.localDescs.remove(key, ref);
                }
                if ((ref = (Reference)this.localDescs.putIfAbsent(key, newRef)) == null) continue;
                entry = ref.get();
            } while (ref != null && entry == null);
            if (entry == null) {
                future = newEntry;
            }
        }
        if (this.token.isInstance(entry)) {
            return this.token.cast(entry);
        }
        if (entry instanceof EntryFuture) {
            future = (EntryFuture)entry;
            entry = future.getOwner() == Thread.currentThread() ? null : future.get();
        }
        if (entry == null) {
            try {
                entry = this.factory.evaluate(k);
                if (firstTime != null) {
                    firstTime.content((Object)true);
                }
            }
            catch (Throwable th) {
                entry = th;
            }
            if (future.set(entry)) {
                this.localDescs.put(key, new SoftReference<Object>(entry));
            } else {
                entry = future.get();
            }
        }
        if (this.token.isInstance(entry)) {
            return this.token.cast(entry);
        }
        if (entry instanceof RuntimeException) {
            throw (RuntimeException)entry;
        }
        if (entry instanceof Error) {
            throw (Error)entry;
        }
        throw new InternalError("unexpected entry: " + entry);
    }

    static class WeakKey<K>
    extends WeakReference<K> {
        private final int hash;

        WeakKey(K cl, ReferenceQueue<K> refQueue) {
            super(cl, refQueue);
            this.hash = System.identityHashCode(cl);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof WeakKey) {
                Object referent = this.get();
                return referent != null && referent == ((WeakKey)obj).get();
            }
            return false;
        }
    }

    private static class EntryFuture<K> {
        private static final Object unset = new Object();
        private final Thread owner = Thread.currentThread();
        private Object entry = unset;

        private EntryFuture() {
        }

        synchronized boolean set(Object entry) {
            if (this.entry != unset) {
                return false;
            }
            this.entry = entry;
            this.notifyAll();
            return true;
        }

        synchronized Object get() {
            boolean interrupted = false;
            while (this.entry == unset) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                });
            }
            return this.entry;
        }

        Thread getOwner() {
            return this.owner;
        }
    }
}

