/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.naming.pcosnaming;

import com.sun.corba.ee.impl.naming.pcosnaming.CounterDB;
import com.sun.corba.ee.impl.naming.pcosnaming.NameService;
import com.sun.corba.ee.impl.naming.pcosnaming.NamingContextImpl;
import com.sun.corba.ee.spi.orb.ORB;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import org.omg.CORBA.LocalObject;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;

public class ServantManagerImpl
extends LocalObject
implements ServantLocator {
    private static final long serialVersionUID = 4028710359865748280L;
    private transient ORB orb;
    private transient NameService theNameService;
    private File logDir;
    private HashMap<String, NamingContextImpl> contexts;
    private transient CounterDB counterDb;
    private int counter;
    private static final String objKeyPrefix = "NC";

    ServantManagerImpl(ORB orb, File logDir, NameService aNameService) {
        this.logDir = logDir;
        this.orb = orb;
        this.counterDb = new CounterDB(logDir);
        this.contexts = new HashMap();
        this.theNameService = aNameService;
    }

    public Servant preinvoke(byte[] oid, POA adapter, String operation, CookieHolder cookie) throws ForwardRequest {
        String objKey = new String(oid);
        Object servant = (Servant)this.contexts.get(objKey);
        if (servant == null) {
            servant = this.readInContext(objKey);
        }
        return servant;
    }

    public void postinvoke(byte[] oid, POA adapter, String operation, Object cookie, Servant servant) {
    }

    public NamingContextImpl readInContext(String objKey) {
        NamingContextImpl context = this.contexts.get(objKey);
        if (context != null) {
            return context;
        }
        File contextFile = new File(this.logDir, objKey);
        if (contextFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(contextFile);
                ObjectInputStream ois = new ObjectInputStream(fis);
                context = (NamingContextImpl)ois.readObject();
                context.setORB(this.orb);
                context.setServantManagerImpl(this);
                context.setRootNameService(this.theNameService);
                ois.close();
            }
            catch (Exception ex) {
                throw new RuntimeException("No file for context " + objKey);
            }
        }
        if (context != null) {
            this.contexts.put(objKey, context);
        }
        return context;
    }

    public NamingContextImpl addContext(String objKey, NamingContextImpl context) {
        File contextFile = new File(this.logDir, objKey);
        if (contextFile.exists()) {
            context = this.readInContext(objKey);
        } else {
            try {
                FileOutputStream fos = new FileOutputStream(contextFile);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(context);
                oos.close();
            }
            catch (Exception ex) {
                throw new RuntimeException("Error in adding new context " + objKey, ex);
            }
        }
        try {
            this.contexts.remove(objKey);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in removing old context " + objKey, e);
        }
        this.contexts.put(objKey, context);
        return context;
    }

    public void updateContext(String objKey, NamingContextImpl context) {
        File contextFile = new File(this.logDir, objKey);
        if (contextFile.exists()) {
            contextFile.delete();
            contextFile = new File(this.logDir, objKey);
        }
        try {
            FileOutputStream fos = new FileOutputStream(contextFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(context);
            oos.close();
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not update context " + objKey, ex);
        }
    }

    public static String getRootObjectKey() {
        return "NC0";
    }

    public String getNewObjectKey() {
        return objKeyPrefix + this.counterDb.getNextCounter();
    }
}

